/*
 * Decompiled with CFR 0.152.
 */
package AbiFileReader;

import AbiFileReader.ABIHeader;
import AbiFileReader.AbiItem;
import AbiFileReader.BinaryChain;
import AbiFileReader.TOCDef;
import AbiFileReader.TOCDefTable;
import AbiFileReader.TOCEntry;
import Chromatograms.Chromatogram;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class AbiFile
implements Iterable<AbiItem> {
    private ABIHeader header;
    private final BinaryChain<TOCEntry> tocEntries = new BinaryChain();
    private Chromatogram chromatogram;
    private short version = 0;

    public Chromatogram getChromatogram() {
        if (this.chromatogram == null) {
            this.genChromatogram();
        }
        return this.chromatogram;
    }

    public Object getData(String tagName, int tagNum) {
        return this.tocEntries.get(tagName + tagNum);
    }

    public boolean isValid() {
        return this.header != null && this.header.isValid();
    }

    public static Chromatogram loadChromatogram(File file) {
        try {
            return AbiFile.loadAbi(file).getChromatogram();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void genChromatogram() {
        this.chromatogram = new Chromatogram();
        TOCEntry tocEntry = this.tocEntries.get("PBAS1");
        if (tocEntry != null) {
            this.chromatogram.sequence = new String(tocEntry.data);
        }
        if ((tocEntry = this.tocEntries.get("PCON1")) != null) {
            this.chromatogram.conf = new String(tocEntry.data);
        }
        if ((tocEntry = this.tocEntries.get("DATA9")) != null) {
            this.chromatogram.bytesGTrace = tocEntry.data;
        }
        if ((tocEntry = this.tocEntries.get("DATA10")) != null) {
            this.chromatogram.bytesATrace = tocEntry.data;
        }
        if ((tocEntry = this.tocEntries.get("DATA11")) != null) {
            this.chromatogram.bytesTTrace = tocEntry.data;
        }
        if ((tocEntry = this.tocEntries.get("DATA12")) != null) {
            this.chromatogram.bytesCTrace = tocEntry.data;
        }
        if ((tocEntry = this.tocEntries.get("PLOC1")) != null) {
            this.chromatogram.bytesPeaks = tocEntry.data;
        }
        this.chromatogram.aTrace = AbiFile.convertBytesToShorts(this.chromatogram.bytesATrace);
        this.chromatogram.tTrace = AbiFile.convertBytesToShorts(this.chromatogram.bytesTTrace);
        this.chromatogram.cTrace = AbiFile.convertBytesToShorts(this.chromatogram.bytesCTrace);
        this.chromatogram.gTrace = AbiFile.convertBytesToShorts(this.chromatogram.bytesGTrace);
        this.chromatogram.basePos = AbiFile.convertBytesToShorts(this.chromatogram.bytesPeaks);
    }

    public static AbiFile loadAbi(File file) throws IOException {
        AbiFile abiFile = new AbiFile();
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        String filePath = file.getAbsolutePath().toLowerCase();
        if (!filePath.endsWith(".ab1") && !filePath.endsWith(".fsa")) {
            return null;
        }
        RandomAccessFile inStream = new RandomAccessFile(file, "r");
        abiFile.header = ABIHeader.readHeader(inStream);
        if (abiFile.header.isValid()) {
            int fileOffset = abiFile.header.dataOffset;
            if (abiFile.header.numElements > 1) {
                for (int x = 0; x < abiFile.header.numElements; ++x) {
                    inStream.seek(fileOffset);
                    TOCEntry entry = TOCEntry.readEntry(inStream);
                    abiFile.tocEntries.add(entry, entry.tagName + entry.tagNum);
                    fileOffset += abiFile.header.elementSize;
                }
            }
        }
        inStream.close();
        return abiFile;
    }

    private static int getDataType(TOCEntry tocEntry) {
        return AbiFile.getDataType(tocEntry, TOCDefTable.TABLE5);
    }

    private static Object getData(TOCEntry tocEntry) {
        if (tocEntry != null) {
            int type = AbiFile.getDataType(tocEntry);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 18: {
                    return new String(tocEntry.data, 1, tocEntry.data.length - 1);
                }
                case 19: {
                    return new String(tocEntry.data, 0, tocEntry.data.length - 1);
                }
                case 1024: {
                    return tocEntry.data;
                }
            }
        }
        return null;
    }

    private static int getDataType(TOCEntry tocEntry, TOCDefTable table) {
        TOCDef def = table.table.get(tocEntry.tagName + tocEntry.tagNum);
        return def != null ? def.type : 99;
    }

    private static short[] convertBytesToShorts(byte[] srcBytes) {
        if (srcBytes == null) {
            return null;
        }
        int y = 0;
        short[] DestArray = new short[srcBytes.length / 2];
        for (int x = 0; x < srcBytes.length; x += 2) {
            int b0 = 0xFF & srcBytes[x];
            int b1 = 0xFF & srcBytes[x + 1];
            DestArray[y] = (short)(256 * b0 + b1);
            ++y;
        }
        return DestArray;
    }

    public void write(File file) {
        try {
            FileOutputStream writer = new FileOutputStream(file);
            byte[] data = this.writeToArray();
            writer.write(data);
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] writeToArray() {
        int fileSize = 108;
        fileSize += this.tocEntries.size() * 28;
        for (TOCEntry entry : this.tocEntries) {
            if (entry.dataSize <= 4) continue;
            fileSize += entry.dataSize;
        }
        byte[] fileData = new byte[fileSize];
        byte[] headerBytes = this.header.toByteArray();
        return fileData;
    }

    @Override
    public Iterator<AbiItem> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<AbiItem> {
        int currentIndex = 0;

        @Override
        public boolean hasNext() {
            return this.currentIndex < AbiFile.this.tocEntries.size();
        }

        @Override
        public AbiItem next() {
            if (!this.hasNext()) {
                return null;
            }
            return this.itemFrom(this.currentIndex++);
        }

        private AbiItem itemFrom(int index) {
            TOCEntry entry = (TOCEntry)AbiFile.this.tocEntries.get(index);
            AbiItem retItem = new AbiItem();
            retItem.TagName = entry.tagName;
            retItem.TagNum = entry.tagNum;
            retItem.value = entry.data;
            return retItem;
        }

        @Override
        public void remove() {
            if (this.indexValid(this.currentIndex)) {
                AbiFile.this.tocEntries.remove(this.currentIndex);
            }
        }

        private boolean indexValid(int index) {
            return index >= 0 && index < AbiFile.this.tocEntries.size();
        }

        @Override
        public void forEachRemaining(Consumer<? super AbiItem> action) {
            Objects.requireNonNull(action);
            while (this.indexValid(this.currentIndex)) {
                ++this.currentIndex;
                action.accept(this.itemFrom(this.currentIndex));
            }
            this.currentIndex = -1;
        }
    }
}

