/*
 * Decompiled with CFR 0.152.
 */
package AbiFileReader;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

class BinaryChain<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    transient Node<T> iteratorNode = null;
    transient Node<T> lastIteratorRet = null;
    transient Node<T> root = new Node();
    private int count = 0;
    private transient Node<T> currentNode = null;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public T[] toArray() {
        Object[] items = null;
        if (this.count > 0 && this.root.next != null) {
            items = (Object[])Array.newInstance(this.root.next.object.getClass(), this.count);
            Node node = this.root.next;
            for (int x = 0; x < this.count; ++x) {
                items[x] = node.object;
                node = node.next;
            }
        }
        return items;
    }

    public Object[] toObjectArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] items = new Object[this.count];
        Node node = this.root.next;
        for (int x = 0; x < this.count; ++x) {
            items[x] = node.object;
            node = node.next;
        }
        return items;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.clearBinaryNode(this.root);
        this.root.next = null;
        this.root.previous = null;
        this.root = new Node();
        this.count = 0;
        this.currentNode = null;
    }

    public T getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        this.currentNode = this.root.next;
        return this.root.next.object;
    }

    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        this.currentNode = this.root.previous;
        return this.root.previous.object;
    }

    public T getNext() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.currentNode != null) {
            if (this.currentNode.next == null || this.currentNode.next == this.root.next) {
                this.currentNode = null;
                return null;
            }
            this.currentNode = this.currentNode.next;
            return this.currentNode.object;
        }
        if (this.currentNode == null) {
            return this.getFirst();
        }
        return null;
    }

    public T getPrevious() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.currentNode != null) {
            if (this.currentNode.previous == null || this.currentNode.previous == this.root) {
                this.currentNode = null;
                return null;
            }
            this.currentNode = this.currentNode.previous;
            return this.currentNode.object;
        }
        if (this.currentNode == null) {
            return this.getLast();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean hasNext() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentNode == null) {
            this.currentNode = this.root.next;
        }
        return this.currentNode != null && this.currentNode.next != null && this.currentNode.next != this.root.next;
    }

    public boolean hasPrevious() {
        return this.isEmpty() ? false : this.currentNode != null && this.currentNode.previous != null && this.currentNode.next != this.root.previous;
    }

    public void addBefore(T obj, String key, String targetKey) {
        this.addBeforeAfter(obj, key, targetKey, true);
    }

    public void addAfter(T obj, String key, String targetKey) {
        this.addBeforeAfter(obj, key, targetKey, false);
    }

    public boolean add(T obj) {
        return this.addObject(obj, obj.toString(), true);
    }

    public boolean add(T obj, String key) {
        return this.addObject(obj, key, true);
    }

    public boolean addIfAbsent(T obj) {
        return this.addObject(obj, obj.toString(), false);
    }

    public boolean addIfAbsent(T obj, String key) {
        return this.addObject(obj, key, false);
    }

    private boolean addObject(T obj, byte[] key, boolean overwrite) {
        if (obj == null || key == null || key.length == 0) {
            return false;
        }
        Node<T> node = this.getBinaryNode(key, true);
        if (node.object != null) {
            if (!overwrite) {
                return false;
            }
            node.object = obj;
            return true;
        }
        node.object = obj;
        if (this.count == 0) {
            this.setFirstNode(node);
            return true;
        }
        node.previous = this.root.previous;
        if (this.root.previous != null) {
            this.root.previous.next = node;
        }
        node.next = null;
        this.root.previous = node;
        ++this.count;
        return true;
    }

    private boolean addObject(T obj, String key, boolean overwrite) {
        if (obj == null || key == null || key.length() == 0) {
            return false;
        }
        Node<T> node = this.getBinaryNode(this.numberToKey(key.hashCode()), true);
        if (node.object != null) {
            if (!overwrite) {
                return false;
            }
            node.object = obj;
            return true;
        }
        node.object = obj;
        if (this.count == 0) {
            this.setFirstNode(node);
            return true;
        }
        node.previous = this.root.previous;
        if (this.root.previous != null) {
            this.root.previous.next = node;
        }
        node.next = null;
        this.root.previous = node;
        ++this.count;
        return true;
    }

    public boolean addAsFirst(T obj) {
        return this.addAsFirst(obj, obj.toString());
    }

    public boolean addAsFirst(T obj, String key) {
        if (obj == null) {
            return false;
        }
        Node<T> node = this.putBinary(obj, key.hashCode());
        if (node == null) {
            return false;
        }
        node.next = this.root.next;
        if (this.count == 0) {
            this.setFirstNode(node);
            return true;
        }
        if (this.root.next != null) {
            this.root.next.previous = node;
        }
        this.root.next = node;
        if (this.count == 0) {
            this.root.previous = node;
        }
        ++this.count;
        return true;
    }

    public void sort(Comparator c) {
        int x;
        if (this.count < 2) {
            return;
        }
        Node[] nodes = new Node[this.count];
        Node<T> node = this.root;
        for (x = 0; x < this.count; ++x) {
            nodes[x] = node.next;
            node = node.next;
        }
        for (x = 0; x < this.count - 1; ++x) {
            Node node2;
            int highIndex = x;
            for (int y = x + 1; y < this.count; ++y) {
                if (c.compare(nodes[highIndex].object, nodes[y].object) <= 0) continue;
                highIndex = y;
            }
            if (highIndex == x) continue;
            Node node1 = nodes[x];
            nodes[x] = node2 = nodes[highIndex];
            nodes[highIndex] = node1;
        }
        this.root.next = nodes[0];
        this.root.previous = nodes[this.count - 1];
        nodes[0].previous = null;
        nodes[this.count - 1].next = null;
        for (x = 0; x < this.count - 1; ++x) {
            nodes[x].next = nodes[x + 1];
            nodes[x + 1].previous = nodes[x];
        }
        nodes[this.count - 1].previous = nodes[this.count - 2];
        this.currentNode = null;
    }

    public void sort2(Comparator c) {
        if (this.count < 2) {
            return;
        }
        Node cNode = this.root.next;
        while (cNode != null && cNode.next != null) {
            Node highNode = cNode;
            Node nNode = cNode.next;
            while (nNode != null) {
                if (c.compare(nNode.object, highNode.object) > 0) {
                    highNode = nNode;
                }
                nNode = nNode.next;
            }
            if (highNode != cNode) {
                if (cNode == this.root.next) {
                    this.root.next = highNode;
                }
                if (cNode == this.root.previous) {
                    this.root.previous = highNode;
                }
                Node l1 = cNode.previous;
                Node r1 = cNode.next;
                Node l2 = highNode.previous;
                Node r2 = highNode.next;
                if (l1 != null) {
                    l1.next = highNode;
                }
                if (r1 != null) {
                    r1.previous = highNode;
                }
                highNode.previous = l1;
                highNode.next = r1;
                if (l2 != null) {
                    l2.next = cNode;
                }
                if (r2 != null) {
                    r2.previous = cNode;
                }
                cNode.previous = l2;
                cNode.next = r2;
                cNode = highNode;
            }
            cNode = cNode.next;
        }
        this.currentNode = null;
    }

    public void removeDuplicates(Comparator c) {
        if (this.count < 2) {
            return;
        }
        Node node1 = this.root.next;
        while (node1.next != null && node1 != this.root.previous) {
            Node node2 = node1.next;
            while (node2 != null) {
                if (c.compare(node1.object, node2.object) == 0) {
                    Node node3 = node2.next;
                    this.removeNode(node2);
                    this.removeBinaryNode(node2);
                    node2 = node3;
                    continue;
                }
                node2 = node2.next;
            }
            node1 = node1.next;
        }
    }

    private void addBeforeAfter(T obj, String key, String targetKey, boolean addBefore) {
        if (obj == null || key == null || key.length() == 0 || targetKey == null || targetKey.length() == 0) {
            return;
        }
        Node<T> dst = this.getBinaryNode(targetKey, false);
        if (dst == null) {
            return;
        }
        Node<T> newNode = this.getBinaryNode(key, true);
        if (newNode.object == null) {
            newNode.object = obj;
            if (addBefore) {
                this.addBefore(newNode, dst);
            } else {
                this.addAfter(newNode, dst);
            }
        }
    }

    private void addBefore(Node<T> node, Node<T> dstNode) {
        if (node == null || dstNode == null) {
            return;
        }
        node.previous = dstNode.previous;
        node.next = dstNode;
        if (dstNode.previous != null) {
            dstNode.previous.next = node;
        }
        dstNode.previous = node;
    }

    private void addAfter(Node<T> node, Node<T> dstNode) {
        if (node == null || dstNode == null) {
            return;
        }
        node.previous = dstNode;
        node.next = dstNode.next;
        if (dstNode.next != null) {
            dstNode.next.previous = node;
        }
        dstNode.next = node;
    }

    private void setFirstNode(Node<T> node) {
        this.root.next = node;
        this.root.previous = node;
        this.count = 1;
    }

    private boolean removeNode(Node<T> node) {
        if (node == null) {
            return false;
        }
        this.cut(node);
        this.removeBinaryNode(node);
        return true;
    }

    public boolean remove(int index) {
        return this.removeNode(this.getChainNode(index));
    }

    public boolean remove(String key) {
        if (this.isEmpty() || key == null || key.length() == 0) {
            return false;
        }
        Node<T> node = this.getBinaryNode(key, false);
        if (node == null) {
            return false;
        }
        this.cut(node);
        this.removeBinaryNode(node);
        return true;
    }

    public T extract(String key) {
        if (this.isEmpty() || key == null || key.length() == 0) {
            return null;
        }
        Node<T> node = this.getBinaryNode(key, false);
        if (node == null) {
            return null;
        }
        this.cut(node);
        this.removeBinaryNode(node);
        return node.object;
    }

    private Node<T> cut(Node node) {
        if (this.iteratorNode != null && node == this.iteratorNode) {
            if (this.iteratorNode == this.root.next) {
                this.iteratorNode = this.root;
                this.lastIteratorRet = null;
            } else {
                this.iteratorNode = this.lastIteratorRet;
                this.lastIteratorRet = this.iteratorNode.previous;
            }
        }
        if (node.next == node) {
            this.root.next = null;
            this.root.previous = null;
        } else {
            if (node.previous != null) {
                node.previous.next = node.next;
            }
            if (node.next != null) {
                node.next.previous = node.previous;
            }
            if (this.root.previous == node) {
                this.root.previous = node.previous;
            }
            if (this.root.next == node) {
                this.root.next = node.next;
            }
        }
        node.next = null;
        node.previous = null;
        if (node == this.currentNode) {
            this.currentNode = null;
        }
        --this.count;
        return node;
    }

    public T popLast() {
        if (this.root.previous == null) {
            return null;
        }
        Node<T> item = this.cut(this.root.previous);
        Object obj = item.object;
        this.removeBinaryNode(item);
        item.object = null;
        return obj;
    }

    public T popFirst() {
        if (this.root.next == null) {
            return null;
        }
        Node<T> item = this.cut(this.root.next);
        Object obj = item.object;
        this.removeBinaryNode(item);
        item.object = null;
        return obj;
    }

    private Node<T> putBinary(T object, long key) {
        return this.putBinaryNode(object, this.numberToKey(key), true);
    }

    public T get(String key) {
        Node<T> node = this.getBinaryNode(this.numberToKey(key.hashCode()), false);
        return node == null ? null : (T)node.object;
    }

    public T get(String key, T defaultValue) {
        Node<T> node = this.getBinaryNode(this.numberToKey(key.hashCode()), false);
        return node == null ? defaultValue : node.object;
    }

    public T get(int index) {
        Node<T> node = this.getChainNode(index);
        return node == null ? null : (T)node.object;
    }

    public boolean insert(T obj, int index) {
        return this.insertObject(obj, obj.toString(), index, true);
    }

    public boolean insert(T obj, String key, int index) {
        return this.insertObject(obj, key, index, true);
    }

    private boolean insertObject(T obj, String key, int index, boolean overwrite) {
        if (index < 0 || index >= this.count) {
            return false;
        }
        if (index == 0) {
            this.addAsFirst(obj, key);
            return true;
        }
        if (index == this.count - 1) {
            this.add(obj, key);
            return true;
        }
        Node<T> preNode = this.getChainNode(index);
        if (preNode == null) {
            return false;
        }
        Node<T> newNode = this.getBinaryNode(this.numberToKey(key.hashCode()), true);
        if (newNode == null || !overwrite && newNode.object != null) {
            return false;
        }
        newNode.object = obj;
        this.addAfter(newNode, preNode);
        return true;
    }

    public boolean containsKey(String key) {
        Node<T> node = this.getBinaryNode(this.numberToKey(key.hashCode()), false);
        return node != null && node.object != null;
    }

    public int indexOf(T obj) {
        Node<T> cNode = this.root;
        for (int x = 0; x <= this.count; ++x) {
            if (cNode.object == obj) {
                return x;
            }
            cNode = cNode.next;
        }
        return -1;
    }

    private Node<T> getChainNode(int index) {
        if (index < 0 || index >= this.count) {
            return null;
        }
        Node<T> cNode = this.root;
        if (index <= this.count / 2) {
            for (int x = 0; x <= index; ++x) {
                cNode = cNode.next;
            }
        } else {
            for (int x = this.count - 1; x >= index; --x) {
                cNode = cNode.previous;
            }
        }
        return cNode;
    }

    private void clearBinaryNode(Node node) {
        if (node != null) {
            if (node.bNodeL != null) {
                this.clearBinaryNode(node.bNodeL);
                node.bNodeL = null;
            }
            if (node.bNodeR != null) {
                this.clearBinaryNode(node.bNodeR);
                node.bNodeR = null;
            }
            node.object = null;
            node.bParent = null;
            node.next = null;
            node.previous = null;
        }
    }

    private void removeBinaryNode(Node node) {
        if (node == null) {
            return;
        }
        node.object = null;
        Node n = node;
        while (n.bNodeL == null && n.bNodeR == null && n.bParent != null) {
            if (n.bParent.bNodeL == n) {
                n.bParent.bNodeL = null;
            } else {
                n.bParent.bNodeR = null;
            }
            n = n.bParent;
        }
    }

    private Node<T> putBinaryNode(T object, byte[] key, boolean overwrite) {
        Node<T> node = this.getBinaryNode(key, true);
        if (node.object == null) {
            node.object = object;
            return node;
        }
        if (!overwrite) {
            return null;
        }
        node.object = object;
        return null;
    }

    private Node<T> getBinaryNode(String key, boolean create) {
        return this.getBinaryNode(this.numberToKey(key.hashCode()), create);
    }

    private Node<T> getBinaryNode(byte[] key, boolean create) {
        Node<T> cNode = this.root;
        for (int charIndex = 0; charIndex < key.length; ++charIndex) {
            byte c = key[charIndex];
            if (c == 0) {
                if (cNode.bNodeL == null) {
                    if (!create) {
                        return null;
                    }
                    cNode.bNodeL = new Node();
                }
                cNode = cNode.bNodeL;
                continue;
            }
            if (c != 1) continue;
            if (cNode.bNodeR == null) {
                if (!create) {
                    return null;
                }
                cNode.bNodeR = new Node();
            }
            cNode = cNode.bNodeR;
        }
        if (cNode.key == null) {
            cNode.key = key;
        }
        return cNode;
    }

    private byte[] numberToKey(long key) {
        return BinaryChain.toRevBinaryArray(key);
    }

    private static byte[] toRevBinaryArray(long val) {
        int shift = 1;
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        byte[] buf = new byte[chars];
        int charPos = 0;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[charPos] = (byte)(digits[(int)val & mask] - 48);
            val >>>= shift;
        } while (++charPos < buf.length);
        return buf;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    public String toString() {
        return "BinaryChain, count=" + this.count;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node node = this.root.next;
        while (node != null) {
            if (node.object != null) {
                s.writeObject(node.key);
                s.writeObject(node.object);
            }
            node = node.next;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.clear();
        s.defaultReadObject();
        this.root = new Node();
        int entries = this.count;
        this.count = 0;
        for (int x = 0; x < entries; ++x) {
            byte[] key = (byte[])s.readObject();
            Object obj = s.readObject();
            if (obj == null) continue;
            this.addObject(obj, key, true);
        }
    }

    private class Node<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Node<T> previous;
        public Node<T> next;
        public byte[] key;
        public T object;
        Node<T> bParent;
        Node<T> bNodeL = null;
        Node<T> bNodeR = null;

        public Node() {
        }

        public Node(T obj) {
            this();
            this.object = obj;
        }
    }

    private class Itr
    implements Iterator<T> {
        public Itr() {
            BinaryChain.this.iteratorNode = BinaryChain.this.root;
        }

        @Override
        public boolean hasNext() {
            return BinaryChain.this.iteratorNode != null && BinaryChain.this.iteratorNode.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                return null;
            }
            BinaryChain.this.lastIteratorRet = BinaryChain.this.iteratorNode;
            BinaryChain.this.iteratorNode = BinaryChain.this.iteratorNode.next;
            return BinaryChain.this.iteratorNode.object;
        }

        @Override
        public void remove() {
            if (BinaryChain.this.iteratorNode != null && BinaryChain.this.iteratorNode != BinaryChain.this.root) {
                Node next = BinaryChain.this.iteratorNode.next;
                BinaryChain.this.removeNode(BinaryChain.this.iteratorNode);
                BinaryChain.this.iteratorNode = next;
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Node cursor = BinaryChain.this.iteratorNode;
            Objects.requireNonNull(action);
            if (cursor != null) {
                BinaryChain.this.lastIteratorRet = cursor;
                while (cursor.next != null) {
                    cursor = cursor.next;
                    action.accept(cursor.object);
                }
            }
            BinaryChain.this.iteratorNode = null;
            BinaryChain.this.lastIteratorRet = null;
        }
    }
}

