/*
 * Decompiled with CFR 0.152.
 */
package AlignmentTools;

public class DnaAlignment {
    private static final int GAP_PENALTY = -1;
    private static final int MATCH_SCORE = 2;
    private static final int MISMATCH_SCORE = -1;

    public static void main(String[] args) {
        int i;
        String seq1 = "ACTGAGTCA";
        String seq2 = "AGCAGATC";
        int[][] scoreMatrix = new int[seq1.length() + 1][seq2.length() + 1];
        for (i = 0; i <= seq1.length(); ++i) {
            scoreMatrix[i][0] = -1 * i;
        }
        for (int j = 0; j <= seq2.length(); ++j) {
            scoreMatrix[0][j] = -1 * j;
        }
        for (i = 1; i <= seq1.length(); ++i) {
            for (int j = 1; j <= seq2.length(); ++j) {
                int match = scoreMatrix[i - 1][j - 1] + (seq1.charAt(i - 1) == seq2.charAt(j - 1) ? 2 : -1);
                int delete = scoreMatrix[i - 1][j] + -1;
                int insert = scoreMatrix[i][j - 1] + -1;
                scoreMatrix[i][j] = Math.max(match, Math.max(delete, insert));
            }
        }
        StringBuilder align1 = new StringBuilder();
        StringBuilder align2 = new StringBuilder();
        int i2 = seq1.length();
        int j = seq2.length();
        while (i2 > 0 || j > 0) {
            if (i2 > 0 && scoreMatrix[i2][j] == scoreMatrix[i2 - 1][j] + -1) {
                align1.append(seq1.charAt(--i2));
                align2.append("-");
                continue;
            }
            if (j > 0 && scoreMatrix[i2][j] == scoreMatrix[i2][j - 1] + -1) {
                align1.append("-");
                align2.append(seq2.charAt(--j));
                continue;
            }
            align1.append(seq1.charAt(--i2));
            align2.append(seq2.charAt(--j));
        }
    }
}

