/*
 * Decompiled with CFR 0.152.
 */
package AlignmentTools;

import AlignmentTools.PairwiseAlignment;

public class QuadAlignment {
    private static char[] qryChars;
    private static char[] refChars;
    static StringBuilder alignedQry;
    static StringBuilder alignedRef;
    private static int score;
    private static ScoreSet scoreSet;
    private static Node[][] nodes;
    static String alignedQryString;
    static String alignedRefString;

    public static String getAlignedQuery() {
        return alignedQry.toString();
    }

    public static String getAlignedReference() {
        return alignedRef.toString();
    }

    public static int getScore() {
        return score;
    }

    public static void align(String query, String reference) {
        QuadAlignment.align(query.toCharArray(), reference.toCharArray(), new ScoreSet(), false);
    }

    public static void align(char[] query, char[] reference) {
        QuadAlignment.align(query, reference, new ScoreSet(), false);
    }

    public static void align(String query, String reference, int matchScore, int mismatchPenalty, int gapPenalty, int beginGapPenalty, int endGapPenalty) {
        QuadAlignment.align(query.toCharArray(), reference.toCharArray(), new ScoreSet(matchScore, mismatchPenalty, gapPenalty, beginGapPenalty, endGapPenalty), false);
    }

    public static void align(String query, String reference, boolean convertTerminalGapsToSpaces) {
        QuadAlignment.align(query.toCharArray(), reference.toCharArray(), new ScoreSet(), convertTerminalGapsToSpaces);
    }

    public static void align(char[] query, char[] reference, boolean convertTerminalGapsToSpaces) {
        QuadAlignment.align(query, reference, new ScoreSet(), convertTerminalGapsToSpaces);
    }

    public static void align(String query, String reference, int matchScore, int mismatchPenalty, int gapPenalty, int beginGapPenalty, int endGapPenalty, boolean convertTerminalGapsToSpaces) {
        QuadAlignment.align(query.toCharArray(), reference.toCharArray(), new ScoreSet(matchScore, mismatchPenalty, gapPenalty, beginGapPenalty, endGapPenalty), convertTerminalGapsToSpaces);
    }

    static void align(String query, String reference, ScoreSet scoreset) {
        QuadAlignment.align(query.toCharArray(), reference.toCharArray(), scoreset, false);
    }

    static void align(String query, String reference, ScoreSet scoreset, boolean convertTerminalGapsToSpaces) {
        QuadAlignment.align(query.toCharArray(), reference.toCharArray(), scoreset, convertTerminalGapsToSpaces);
    }

    static void align(char[] query, char[] reference, ScoreSet scoreset, boolean convertTerminalGapsToSpaces) {
        scoreSet = scoreset;
        alignedQry = new StringBuilder();
        alignedRef = new StringBuilder();
        QuadAlignment.initializeMatrix(query, reference);
        QuadAlignment.fillMatrix();
        int i = nodes.length - 1;
        int j = nodes[0].length - 1;
        int mIndex = query.length - 1;
        int nIndex = reference.length - 1;
        Node currentNode = nodes[nodes.length - 1][nodes[0].length - 1];
        while (currentNode.tracebackI != null || currentNode.tracebackJ != null) {
            if (currentNode.tracebackI == i - 1 && currentNode.tracebackJ == j - 1) {
                alignedQry.append(query[mIndex]);
                alignedRef.append(reference[nIndex]);
                --mIndex;
                --nIndex;
            } else if (currentNode.tracebackJ == j - 1) {
                alignedQry.append("-");
                alignedRef.append(reference[nIndex]);
                --nIndex;
            } else {
                alignedQry.append(query[mIndex]);
                alignedRef.append("-");
                --mIndex;
            }
            i = currentNode.tracebackI;
            j = currentNode.tracebackJ;
            currentNode = nodes[i][j];
        }
        alignedQry = alignedQry.reverse();
        alignedRef = alignedRef.reverse();
        if (convertTerminalGapsToSpaces) {
            alignedQryString = PairwiseAlignment.convertTrailingGaps(alignedQry);
            alignedRefString = PairwiseAlignment.convertTrailingGaps(alignedRef);
        } else {
            alignedQryString = alignedQry.toString();
            alignedRefString = alignedRef.toString();
        }
    }

    private static void initializeMatrix(char[] sequenceOne, char[] sequenceTwo) {
        int i;
        alignedQryString = null;
        alignedRefString = null;
        qryChars = sequenceOne;
        refChars = sequenceTwo;
        score = 0;
        nodes = new Node[qryChars.length + 1][refChars.length + 1];
        for (i = 0; i < nodes.length; ++i) {
            for (int j = 0; j < nodes[i].length; ++j) {
                QuadAlignment.nodes[i][j] = new Node();
            }
        }
        QuadAlignment.nodes[0][0].value = 0;
        for (i = 1; i < nodes.length; ++i) {
            QuadAlignment.nodes[i][0].value = QuadAlignment.scoreSet.useBeginGapLeft ? QuadAlignment.nodes[i - 1][0].value + QuadAlignment.scoreSet.beginGap : QuadAlignment.nodes[i - 1][0].value + QuadAlignment.scoreSet.gap;
            QuadAlignment.nodes[i][0].tracebackI = i - 1;
            QuadAlignment.nodes[i][0].tracebackJ = 0;
        }
        for (int j = 1; j < nodes[0].length; ++j) {
            QuadAlignment.nodes[0][j].value = QuadAlignment.scoreSet.useBeginGapTop ? QuadAlignment.nodes[0][j - 1].value + QuadAlignment.scoreSet.beginGap : QuadAlignment.nodes[0][j - 1].value + QuadAlignment.scoreSet.gap;
            QuadAlignment.nodes[0][j].tracebackI = 0;
            QuadAlignment.nodes[0][j].tracebackJ = j - 1;
        }
    }

    private static void fillMatrix() {
        for (int i = 1; i < nodes.length; ++i) {
            for (int j = 1; j < nodes[0].length; ++j) {
                int b;
                int a;
                if (i == nodes.length - 1 && j == nodes[0].length - 1) {
                    a = QuadAlignment.scoreSet.useEndGapRight ? QuadAlignment.nodes[i - 1][j].value + QuadAlignment.scoreSet.endGap : QuadAlignment.nodes[i - 1][j].value + QuadAlignment.scoreSet.gap;
                    b = QuadAlignment.scoreSet.useEndGapBottom ? QuadAlignment.nodes[i][j - 1].value + QuadAlignment.scoreSet.endGap : QuadAlignment.nodes[i][j - 1].value + QuadAlignment.scoreSet.gap;
                } else if (i == nodes.length - 1) {
                    a = QuadAlignment.nodes[i - 1][j].value + QuadAlignment.scoreSet.gap;
                    b = QuadAlignment.scoreSet.useEndGapBottom ? QuadAlignment.nodes[i][j - 1].value + QuadAlignment.scoreSet.endGap : QuadAlignment.nodes[i][j - 1].value + QuadAlignment.scoreSet.gap;
                } else if (j == nodes[0].length - 1) {
                    a = QuadAlignment.scoreSet.useEndGapRight ? QuadAlignment.nodes[i - 1][j].value + QuadAlignment.scoreSet.endGap : QuadAlignment.nodes[i - 1][j].value + QuadAlignment.scoreSet.gap;
                    b = QuadAlignment.nodes[i][j - 1].value + QuadAlignment.scoreSet.gap;
                } else {
                    a = QuadAlignment.nodes[i - 1][j].value + QuadAlignment.scoreSet.gap;
                    b = QuadAlignment.nodes[i][j - 1].value + QuadAlignment.scoreSet.gap;
                }
                int c = QuadAlignment.nodes[i - 1][j - 1].value + scoreSet.getScore(qryChars[i - 1], refChars[j - 1]);
                if (a >= b && a >= c) {
                    QuadAlignment.nodes[i][j].value = a;
                    QuadAlignment.nodes[i][j].tracebackI = i - 1;
                    QuadAlignment.nodes[i][j].tracebackJ = j;
                    continue;
                }
                if (b >= c && b >= a) {
                    QuadAlignment.nodes[i][j].value = b;
                    QuadAlignment.nodes[i][j].tracebackI = i;
                    QuadAlignment.nodes[i][j].tracebackJ = j - 1;
                    continue;
                }
                QuadAlignment.nodes[i][j].value = c;
                QuadAlignment.nodes[i][j].tracebackI = i - 1;
                QuadAlignment.nodes[i][j].tracebackJ = j - 1;
            }
        }
        score = QuadAlignment.nodes[QuadAlignment.nodes.length - 1][QuadAlignment.nodes[0].length - 1].value;
    }

    static {
        alignedQryString = null;
        alignedRefString = null;
    }

    static class ScoreSet {
        boolean useBeginGapTop = true;
        boolean useBeginGapLeft = true;
        boolean useEndGapBottom = true;
        boolean useEndGapRight = true;
        int beginGap = 0;
        int endGap = 0;
        int gap = -2;
        int match = 2;
        int mismatch = -1;

        public ScoreSet() {
        }

        public ScoreSet(int match, int mismatch, int gapPenalty, int beginGapPenalty, int endGapPenalty) {
            this.setScoreSetParam(match, mismatch, gapPenalty, beginGapPenalty, endGapPenalty);
        }

        public void setScoreSetParam(int match, int mismatch, int gapPenalty, int beginGapPenalty, int endGapPenalty) {
            this.match = match;
            this.mismatch = mismatch;
            this.gap = gapPenalty;
            this.beginGap = beginGapPenalty;
            this.endGap = endGapPenalty;
        }

        public int getScore(char r1, char r2) {
            if (r1 == r2) {
                return this.match;
            }
            return this.mismatch;
        }
    }

    private static class Node {
        public int value = 0;
        public Integer tracebackI;
        public Integer tracebackJ;

        private Node() {
        }
    }
}

