/*
 * Decompiled with CFR 0.152.
 */
package AppHistory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class History {
    private Preferences userPref = Preferences.userRoot();
    private static final String EXT = "_config.xml";
    private static final String GB_NAME_FILTER = "\\w\\-'";
    private String appName = null;

    public Preferences getUserPref() {
        return this.userPref;
    }

    public void setApp(Class<?> c, String appName) {
        if (c == null) {
            this.userPref = Preferences.userRoot();
        } else {
            this.userPref = Preferences.userNodeForPackage(c);
            this.setAppName(appName);
            if (!this.userPref.getBoolean("loaded", false) && this.load()) {
                this.userPref.putBoolean("loaded", true);
            }
        }
    }

    public int getCount(String key, int maxCount) {
        key = key + "_";
        for (int x = 1; x < maxCount; ++x) {
            if (this.userPref.get(key + x, null) != null) continue;
            return x - 1;
        }
        return maxCount;
    }

    public void deleteByValue(String key, String value, int maxCount) {
        String baseKey = key + "_";
        for (int x = 1; x <= maxCount; ++x) {
            String val = this.userPref.get(baseKey + x, null);
            if (val == null || !val.equals(value)) continue;
            this.delete(key, x, maxCount);
        }
    }

    public boolean delete(String key, int index, int maxCount) {
        block3: {
            if (index < 1 || index > maxCount) {
                return false;
            }
            key = key + "_";
            if (index == maxCount) {
                this.userPref.remove(key + maxCount);
                return true;
            }
            int x = index;
            if (x >= maxCount) break block3;
            String nextVal = this.userPref.get(key + (x + 1), null);
            if (nextVal != null) {
                this.userPref.put(key + x, nextVal);
                this.userPref.remove(key + (x + 1));
                return true;
            }
            this.userPref.remove(key + x);
        }
        return true;
    }

    public boolean insertFirst(String key, String value, int maxCount) {
        return this.insert(key, value, 1, maxCount, true) == 1;
    }

    public boolean insertFirst(String key, String value, int maxCount, boolean removeDuplicates) {
        return this.insert(key, value, 1, maxCount, removeDuplicates) == 1;
    }

    public int insert(String key, String value, int index, int maxCount) {
        return this.insert(key, value, index, maxCount, true);
    }

    public int insert(String key, String value, int index, int maxCount, boolean removeDuplicates) {
        if (index < 1) {
            index = 1;
        }
        if (index > maxCount) {
            index = maxCount;
        }
        if (removeDuplicates) {
            String baseKey2 = key + "_";
            for (int x = maxCount; x > 0; --x) {
                String val = this.userPref.get(baseKey2 + x, null);
                if (val == null || !val.equalsIgnoreCase(value)) continue;
                this.delete(key, x, maxCount);
                if (x >= index) continue;
                --index;
            }
        }
        int actualIndex = this.insertItem(key, value, index, maxCount);
        return actualIndex;
    }

    private int insertItem(String key, String value, int index, int maxCount) {
        if (index < 1 || index > maxCount) {
            return 0;
        }
        int count = this.getCount(key, maxCount);
        key = key + "_";
        if (count < index) {
            index = count + 1;
            this.userPref.put(key + index, value);
            return index;
        }
        if (count < maxCount) {
            ++count;
        }
        for (int x = count; x > index; --x) {
            String val = this.userPref.get(key + (x - 1), null);
            this.userPref.put(key + x, val);
        }
        this.userPref.put(key + index, value);
        return index;
    }

    public void removeAll(String key, int maxCount) {
        String baseKey2 = key + "_";
        for (int x = maxCount; x > 0; --x) {
            String bk2 = baseKey2 + x;
            String val = this.userPref.get(bk2, null);
            if (val == null) continue;
            this.userPref.remove(bk2);
        }
    }

    public String get(String key) {
        return this.get(key, 1, 1, null);
    }

    public String get(String key, String defaultValue) {
        return this.get(key, 1, 1, defaultValue);
    }

    public String get(String key, int index, int maxCount) {
        return this.get(key, index, maxCount, null);
    }

    public String get(String key, int index, int maxCount, String defaultValue) {
        if (index < 1 || index > maxCount) {
            return defaultValue;
        }
        String val = this.userPref.get(key + "_" + index, defaultValue);
        return val == null ? defaultValue : val;
    }

    public String[] getAll(String baseKey, int maxCount) {
        baseKey = baseKey + "_";
        String[] items = new String[maxCount];
        int foundCount = 0;
        for (int x = 1; x <= maxCount; ++x) {
            String val = this.userPref.get(baseKey + x, null);
            if (val == null) continue;
            items[foundCount] = val;
            ++foundCount;
        }
        if (foundCount == 0) {
            return null;
        }
        if (foundCount == maxCount) {
            return items;
        }
        String[] finalItems = new String[foundCount];
        System.arraycopy(items, 0, finalItems, 0, foundCount);
        return finalItems;
    }

    public String getAppName() {
        return this.appName;
    }

    private void setAppName(String name) {
        if ((name = History.safeName(name)) != null && name.length() > 0) {
            this.appName = name;
        }
    }

    private static String safeName(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        return name.replaceAll(GB_NAME_FILTER, "");
    }

    public boolean load() {
        return this.load(new File(this.appName + EXT));
    }

    public boolean load(String filepath) {
        return this.load(new File(filepath));
    }

    public boolean load(File file) {
        try {
            if (!file.exists()) {
                return false;
            }
            Preferences.importPreferences(new FileInputStream(file));
            return true;
        }
        catch (IOException | InvalidPreferencesFormatException ex) {
            return false;
        }
    }

    public boolean save() {
        return this.save(new File(this.appName + EXT));
    }

    public boolean save(String filepath) {
        return this.save(new File(filepath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.userPref.exportNode(fileOutputStream);
            fileOutputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ex) {
            boolean bl = false;
            return bl;
        }
        catch (IOException | BackingStoreException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

