/*
 * Decompiled with CFR 0.152.
 */
package BaseClasses;

import BaseClasses.RendererColors;
import JMConstants.Constants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractBaseIcon
implements Icon,
Constants {
    protected RendererColors colors = new RendererColors();
    protected int width = 16;
    protected int height = 16;
    protected boolean needsRegen = true;
    protected Icon icon;
    private Icon errorIcon = null;

    public AbstractBaseIcon() {
    }

    public AbstractBaseIcon(int width, int height) {
        this();
        this.width = width;
        this.height = height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getIcon();
        if (icon != null) {
            icon.paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void setSize(int width, int height) {
        if (width == 0 && height == 0) {
            return;
        }
        if (width > 0) {
            this.width = width;
        }
        if (height > 0) {
            this.height = height;
        }
        this.needsRegen = true;
    }

    public void resetIcon() {
        this.icon = null;
        this.errorIcon = null;
        this.needsRegen = false;
    }

    protected void regenIcon() {
        this.icon = this.makeIcon();
    }

    public Icon getIcon(Component c) {
        if (this.needsRegen) {
            this.resetIcon();
        }
        return this.getIcon();
    }

    private Icon getErrorIcon() {
        if (this.errorIcon == null) {
            this.genErrorIcon();
        }
        return this.errorIcon;
    }

    protected void genErrorIcon() {
        BufferedImage canvasBuffer = new BufferedImage(this.width, this.height, 6);
        Graphics2D canvasGraphics = (Graphics2D)canvasBuffer.getGraphics();
        canvasGraphics.setColor(Color.white);
        canvasGraphics.fillRect(0, 0, this.width, this.height);
        canvasGraphics.setColor(Color.red);
        canvasGraphics.drawLine(0, 0, this.width, this.height);
        canvasGraphics.drawLine(0, this.height, this.width, 0);
        canvasGraphics.drawRect(0, 0, this.width - 1, this.height - 1);
        this.errorIcon = new ImageIcon(canvasBuffer);
    }

    private Icon makeIcon() {
        BufferedImage buffer = new BufferedImage(this.width, this.height, 6);
        Graphics2D g2d = (Graphics2D)buffer.getGraphics();
        return this.drawIcon(g2d) ? new ImageIcon(buffer) : null;
    }

    public abstract boolean drawIcon(Graphics2D var1);

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.makeIcon();
        }
        return this.icon != null ? this.icon : this.getErrorIcon();
    }

    public Color getColor(int colorType, int state) {
        return this.colors.getColor(colorType, state);
    }

    public RendererColors getColors() {
        return this.colors;
    }

    public void setColor(int colorType, int state, Color color) {
        this.colors.setColor(colorType, state, color);
        this.needsRegen = true;
    }

    public void setColors(int colorType, Color color) {
        this.colors.setColors(colorType, color);
        this.needsRegen = true;
    }

    public void setColors(RendererColors colors) {
        this.colors = colors;
        this.needsRegen = true;
    }

    protected void setActiveColors(boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        this.colors.setActiveColors(enabled, selected, rollOver, pressed);
    }

    public Color getActiveColor(int state) {
        return this.colors.getActiveColor(state);
    }
}

