/*
 * Decompiled with CFR 0.152.
 */
package BioDocumentFilters;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class BioAllowedKeyFilter
extends DocumentFilter {
    public static final String FILTER_GB_NAME = "\\w\\-'";
    public static final String FILTER_AA = "*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy";
    public static final String FILTER_ATGC = "ATGCatgc";
    public static final String FILTER_ATGCN = "atgcnATGCN";
    public static final String FILTER_ATGCN_GAP = "atgcnATGCN-";
    public static final String FILTER_DNA_DEGEN = "ACGTRYSWKMBDHVNacgtryswkmbdhvn";
    public static final String FILTER_DNA_DEGEN_GAP = "ACGTRYSWKMBDHVNacgtryswkmbdhvn-";
    public static final String FILTER_AUGC = "AUGCaugc";
    public static final String FILTER_AUGCN = "AUGCaugcNn";
    public static final String FILTER_AMINO_ACIDS = "*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy";
    public static final String FILTER_AMINO_ACIDS_GAP = "*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy-";
    public static final BioAllowedKeyFilter DNA_ACGT_Filter = new BioAllowedKeyFilter("ATGCatgc");
    public static final BioAllowedKeyFilter DNAFilter = new BioAllowedKeyFilter("atgcnATGCN");
    public static final BioAllowedKeyFilter DNA_DEGEN_Filter = new BioAllowedKeyFilter("ACGTRYSWKMBDHVNacgtryswkmbdhvn");
    public static final BioAllowedKeyFilter DNA_DEGEN_GAP_Filter = new BioAllowedKeyFilter("ACGTRYSWKMBDHVNacgtryswkmbdhvn-");
    public static final BioAllowedKeyFilter DNAGapFilter = new BioAllowedKeyFilter("atgcnATGCN-");
    public static final BioAllowedKeyFilter ProteinFilter = new BioAllowedKeyFilter("*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy");
    public static final BioAllowedKeyFilter ProteinGapFilter = new BioAllowedKeyFilter("*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy-");
    public static final BioAllowedKeyFilter GenbankNameFilter = new BioAllowedKeyFilter("\\w\\-'");
    String regExFilter = null;

    public BioAllowedKeyFilter() {
    }

    public BioAllowedKeyFilter(String allowed) {
        this.regExFilter = "[^" + allowed + "]";
    }

    public void setRegExFilter(String regExFilter) {
        this.regExFilter = regExFilter;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        if (this.regExFilter == null) {
            super.insertString(fb, offset, text, attr);
        } else {
            super.insertString(fb, offset, text.replaceAll(this.regExFilter, ""), attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (this.regExFilter == null) {
            super.replace(fb, offset, length, text, attrs);
        } else {
            super.replace(fb, offset, length, text.replaceAll(this.regExFilter, ""), attrs);
        }
    }
}

