/*
 * Decompiled with CFR 0.152.
 */
package BitString;

import java.util.Arrays;

public class BitString {
    private static final byte[] BITMASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private int mByteIndex = 0;
    private int mBitIndex = 0;
    private byte[] charData;
    private int mBitLength = 0;
    private int mByteLength = 0;
    private static int BUFFERSIZE = 250;

    public void setBufferSize(int BufferSize) {
        if (BufferSize > 0) {
            BUFFERSIZE = BufferSize;
        }
    }

    public int getBufferSize() {
        return BUFFERSIZE;
    }

    public BitString() {
        this.charData = new byte[BUFFERSIZE];
        Arrays.fill(this.charData, (byte)0);
    }

    public BitString(int BufferSize) {
        this.charData = new byte[BufferSize];
        Arrays.fill(this.charData, (byte)0);
    }

    public BitString(String data) {
        this.setString(data);
    }

    public BitString(byte[] data) {
        this.setString(data, 0, data.length);
    }

    public BitString(byte[] data, int startOffset) {
        this.setString(data, startOffset, data.length);
    }

    public BitString(byte[] data, int startOffset, int stopOffset) {
        this.setString(data, startOffset, stopOffset);
    }

    public BitString(BitString data) {
        this.clone(data);
    }

    public void clone(BitString data) {
        this.charData = new byte[data.charData.length];
        System.arraycopy(data.charData, 0, this.charData, 0, data.mByteLength);
        this.mBitIndex = data.mBitIndex;
        this.mByteIndex = data.mByteIndex;
        this.mByteLength = data.mByteLength;
    }

    public int length() {
        return this.mByteLength;
    }

    public int bitLength() {
        return this.mBitLength;
    }

    public void setBitLength(int BitLength) {
        this.charData = BitLength % 8 == 0 ? new byte[BitLength / 8] : new byte[BitLength / 8 + 1];
        this.mBitLength = BitLength;
        this.mByteIndex = 0;
        this.mBitIndex = 0;
    }

    private void incBuffer(int appendByteSize) {
        byte[] newBuffer = new byte[appendByteSize + this.charData.length];
        System.arraycopy(this.charData, 0, newBuffer, 0, this.charData.length);
        this.charData = newBuffer;
    }

    public void setString(String data) {
        byte[] tmpData = data.getBytes();
        this.setString(tmpData, 0, tmpData.length);
    }

    public void setString(byte[] data) {
        this.setString(data, 0, data.length);
    }

    public void setString(byte[] data, int startOffset) {
        this.setString(data, startOffset, data.length);
    }

    public void setString(byte[] data, int startOffset, int stopOffset) {
        int newLen = stopOffset - startOffset;
        this.charData = new byte[newLen + BUFFERSIZE];
        System.arraycopy(data, startOffset, this.charData, 0, newLen);
        this.mByteLength = newLen;
        this.mBitLength = newLen * 8;
        this.mByteIndex = 0;
        this.mBitIndex = 0;
    }

    public void setChar(char Char) {
        this.charData[this.mByteIndex] = (byte)Char;
        this.goToNextByte();
    }

    public void setShort(short value) {
        this.setByte((byte)(value & 0xFF));
        this.setByte((byte)(value >> 8 & 0xFF));
    }

    public void setInt(int value) {
        this.setByte((byte)value);
        this.setByte((byte)(value >>> 8));
        this.setByte((byte)(value >>> 16));
        this.setByte((byte)(value >>> 24));
    }

    public void setByte(byte Byte) {
        this.charData[this.mByteIndex] = Byte;
        this.goToNextByte();
    }

    public void setBit() {
        int n = this.mByteIndex;
        this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
        this.goToNextBit();
    }

    public void setBit(boolean value) {
        if (value) {
            int n = this.mByteIndex;
            this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
        } else {
            int n = this.mByteIndex;
            this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
            int n2 = this.mByteIndex;
            this.charData[n2] = (byte)(this.charData[n2] ^ BITMASK[this.mBitIndex]);
        }
        this.goToNextBit();
    }

    public void setBit(byte value) {
        if (value != 0) {
            int n = this.mByteIndex;
            this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
        } else {
            int n = this.mByteIndex;
            this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
            int n2 = this.mByteIndex;
            this.charData[n2] = (byte)(this.charData[n2] ^ BITMASK[this.mBitIndex]);
        }
        this.goToNextBit();
    }

    public void append(byte data) {
        this.mBitIndex = 0;
        this.mByteIndex = this.mByteLength;
        this.goToNextByte();
    }

    public void append(byte[] data) {
        int newLen = this.mByteLength + data.length;
        if (this.mByteLength >= this.charData.length) {
            this.incBuffer(newLen - this.mByteLength + BUFFERSIZE);
        }
        System.arraycopy(data, 0, this.charData, this.mByteLength + 1, data.length);
        this.mByteLength = newLen;
        this.mBitIndex = 0;
        this.mByteIndex = newLen;
    }

    public int bitPosition() {
        return this.mByteIndex * 8 + this.mBitIndex;
    }

    public void goToBit(int Index) {
        this.mByteIndex = Index / 8;
        this.mBitIndex = Index - this.mByteIndex * 8;
    }

    public void goToNextBit() {
        ++this.mBitIndex;
        if (this.mBitIndex == 8) {
            this.goToNextByte();
        } else if (this.mByteIndex + this.mBitIndex > this.mBitLength) {
            ++this.mBitLength;
        }
    }

    public void goToNextByte() {
        ++this.mByteIndex;
        this.mBitIndex = 0;
        if (this.mByteIndex > this.mByteLength) {
            this.mByteLength = this.mByteIndex;
            this.mBitLength = this.mByteLength * 8;
        }
        if (this.mByteIndex >= this.charData.length - 1) {
            this.incBuffer(BUFFERSIZE);
        }
    }

    public void goToPrevBit() {
        --this.mBitIndex;
        if (this.mBitIndex == -1) {
            --this.mByteIndex;
            this.mBitIndex = 7;
        }
    }

    public void goToByte(int Index) {
        this.mByteIndex = Index - 1;
        this.goToNextByte();
    }

    public void goToStart() {
        this.mByteIndex = 0;
        this.mBitIndex = 0;
    }

    public void goToEnd() {
        this.goToByte(this.mByteLength);
    }

    public boolean atEnd() {
        return this.mByteIndex == this.mByteLength;
    }

    public String toString() {
        return new String(this.getBytes());
    }

    public int bitIndex() {
        return this.mBitIndex;
    }

    public int byteIndex() {
        return this.mByteIndex;
    }

    public byte getBit() {
        byte outBit = 0;
        if (this.charData[this.mByteIndex] == (this.charData[this.mByteIndex] | BITMASK[this.mBitIndex])) {
            outBit = 1;
        }
        this.goToNextBit();
        return outBit;
    }

    public byte getBit(int Index) {
        int tmpByteIndex = Index / 8;
        int tmpBitIndex = Index - this.mByteIndex;
        if (this.charData[tmpByteIndex] == (this.charData[tmpByteIndex] | BITMASK[tmpBitIndex])) {
            return 1;
        }
        return 0;
    }

    public byte getByte() {
        this.goToNextByte();
        return this.charData[this.mByteIndex - 1];
    }

    public byte getByte(int Index) {
        return this.charData[Index];
    }

    public char getChar() {
        this.goToNextByte();
        return (char)(this.charData[this.mByteIndex - 1] & 0xFF);
    }

    public char getChar(int Index) {
        return (char)(this.charData[Index] & 0xFF);
    }

    public short getShort() {
        int b0 = 0xFF & this.charData[this.mByteIndex];
        int b1 = 0xFF & this.charData[this.mByteIndex + 1];
        this.mByteIndex += 2;
        this.mBitIndex = 0;
        return (short)(b1 << 8 | b0);
    }

    public short getShort(int Index) {
        int b0 = 0xFF & this.charData[Index];
        int b1 = 0xFF & this.charData[Index + 1];
        return (short)(b1 << 8 | b0);
    }

    public int getInt() {
        int b0 = 0xFF & this.charData[this.mByteIndex];
        int b1 = 0xFF & this.charData[this.mByteIndex + 1];
        int b2 = 0xFF & this.charData[this.mByteIndex + 2];
        int b3 = 0xFF & this.charData[this.mByteIndex + 3];
        this.mByteIndex += 4;
        this.mBitIndex = 0;
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    public int getInt(int Index) {
        int b0 = 0xFF & this.charData[Index];
        int b1 = 0xFF & this.charData[Index + 1];
        int b2 = 0xFF & this.charData[Index + 2];
        int b3 = 0xFF & this.charData[Index + 3];
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    public byte[] getBytes() {
        if (this.mByteLength == this.charData.length) {
            return this.charData;
        }
        byte[] outBytes = new byte[this.mByteLength + 1];
        System.arraycopy(this.charData, 0, outBytes, 0, this.mByteLength + 1);
        return outBytes;
    }

    public byte[] getBytes(int startOffset) {
        int outLen = this.mByteLength - startOffset;
        byte[] outBytes = new byte[outLen];
        System.arraycopy(this.charData, 0, outBytes, 0, outLen);
        return outBytes;
    }

    public byte[] getBytes(int startOffset, int stopOffset) {
        if (stopOffset > this.mByteLength) {
            stopOffset = this.mByteLength;
        }
        int outLen = stopOffset - startOffset;
        byte[] outBytes = new byte[outLen];
        System.arraycopy(this.charData, 0, outBytes, 0, outLen);
        return outBytes;
    }

    public byte[] getNBytes(int length) {
        byte[] outBytes = new byte[length];
        System.arraycopy(this.charData, this.mByteIndex, outBytes, 0, length);
        this.mByteIndex += length;
        this.mBitIndex = 0;
        return outBytes;
    }

    public void removeWhiteSpaces() {
        int wIndex = 0;
        for (int rIndex = 0; rIndex < this.mByteLength; ++rIndex) {
            if (!(this.charData[rIndex] != 9 & this.charData[rIndex] != 32 & this.charData[rIndex] != 0 & this.charData[rIndex] != 13 & this.charData[rIndex] != 10)) continue;
            if (rIndex != wIndex) {
                this.charData[wIndex] = this.charData[rIndex];
            }
            ++wIndex;
        }
        for (int x = this.mByteLength = wIndex; x < this.charData.length; ++x) {
            this.charData[x] = 0;
        }
    }

    public void TrimLeft() {
        int x;
        int wIndex = 0;
        int rIndex = -1;
        for (x = 0; x < this.mByteLength && this.charData[x] == 32; ++x) {
            ++rIndex;
        }
        if (rIndex == -1) {
            return;
        }
        if (rIndex == this.mByteLength - 1) {
            Arrays.fill(this.charData, (byte)0);
            this.mByteLength = 0;
            this.mBitLength = 0;
            this.mByteIndex = 0;
            this.mBitIndex = 0;
            return;
        }
        for (x = ++rIndex; x < this.mByteLength; ++x) {
            this.charData[wIndex] = this.charData[rIndex];
        }
        for (x = this.mByteLength = wIndex; x < this.charData.length; ++x) {
            this.charData[x] = 0;
        }
    }

    public void TrimRight() {
        for (int x = this.mByteLength; x >= 0 && this.charData[x] == 32; ++x) {
            this.charData[x] = 0;
            --this.mByteLength;
        }
        this.mBitLength = this.mByteLength * 8;
        this.mByteIndex = 0;
        this.mBitIndex = 0;
    }

    public void replace(char targetByte, char newByte) {
        this.replace((byte)targetByte, (byte)newByte);
    }

    public void replace(byte targetByte, byte newByte) {
        for (int x = 0; x < this.mByteLength; ++x) {
            if (this.charData[x] != targetByte) continue;
            this.charData[x] = newByte;
        }
    }

    public void replace(char targetChar, String newSeq) {
        this.replace((byte)targetChar, newSeq.getBytes());
    }

    public void replace(byte targetByte, String newSeq) {
        this.replace(targetByte, newSeq.getBytes());
    }

    public void replace(byte targetByte, byte[] newByte) {
        if (newByte.length == 1) {
            this.replace(targetByte, newByte[0]);
            return;
        }
        int dSize = newByte.length - 1;
        int ItemsFound = 0;
        for (int x = 0; x < this.mByteLength; ++x) {
            if (this.charData[x] != targetByte) continue;
            ++ItemsFound;
        }
        if (ItemsFound == 0) {
            return;
        }
        int newLen = this.mByteLength + dSize * ItemsFound + BUFFERSIZE;
        byte[] tmpBuffer = new byte[newLen];
        int wIndex = 0;
        for (int x = 0; x < this.mByteLength; ++x) {
            if (this.charData[x] == targetByte) {
                for (int y = 0; y < newByte.length; ++y) {
                    tmpBuffer[wIndex] = newByte[y];
                    ++wIndex;
                }
                continue;
            }
            tmpBuffer[wIndex] = this.charData[x];
            ++wIndex;
        }
        this.charData = tmpBuffer;
        this.mByteLength = this.charData.length - BUFFERSIZE;
        this.mByteIndex = 0;
        this.mBitIndex = 0;
    }

    public static int[] BytesToInts(byte[] inBytes) {
        int[] outInts = new int[inBytes.length / 4];
        int inIndex = 0;
        for (int x = 0; x < outInts.length; ++x) {
            int b0 = 0xFF & inBytes[inIndex];
            int b1 = 0xFF & inBytes[inIndex + 1];
            int b2 = 0xFF & inBytes[inIndex + 2];
            int b3 = 0xFF & inBytes[inIndex + 3];
            outInts[x] = b3 << 24 | b2 << 16 | b1 << 8 | b0;
            inIndex += 4;
        }
        return outInts;
    }

    public static short[] BytesToShorts(byte[] inBytes) {
        short[] outShorts = new short[inBytes.length / 2];
        int inIndex = 0;
        for (int x = 0; x < outShorts.length; ++x) {
            int b0 = 0xFF & inBytes[inIndex];
            int b1 = 0xFF & inBytes[inIndex + 1];
            outShorts[x] = (short)(b1 << 8 | b0);
            inIndex += 2;
        }
        return outShorts;
    }
}

