/*
 * Decompiled with CFR 0.152.
 */
package BlockTree;

import BlockTree.AbstractBlockTreeNode;
import BlockTree.NodeBlock;
import BlockTree.XMLElement;
import NotePad.NotePadWindow;
import java.awt.Image;
import java.io.Serializable;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.TransferHandler;

public class NodeFolder
extends AbstractBlockTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ImageIcon iconClosed = new ImageIcon(NodeFolder.class.getResource("/images24/FOLDERCLOSED.png"));
    public static final ImageIcon iconOpen = new ImageIcon(NodeFolder.class.getResource("/images24/FOLDER.png"));
    public NotePadWindow editor;

    public void sortSequencesAtoZ() {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        Comparator c = (o1, o2) -> {
            if (o1 instanceof NodeBlock && o2 instanceof NodeBlock) {
                return ((NodeBlock)o1).getText().toUpperCase().compareTo(((NodeBlock)o2).getText().toUpperCase());
            }
            if (o1 instanceof NodeBlock) {
                return 1;
            }
            if (o2 instanceof NodeBlock) {
                return 2;
            }
            return 0;
        };
        this.children.sort(c);
    }

    public void sortSequencesZtoA() {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        Comparator c = (o1, o2) -> {
            if (o1 instanceof NodeBlock && o2 instanceof NodeBlock) {
                return ((NodeBlock)o2).getText().toUpperCase().compareTo(((NodeBlock)o1).getText().toUpperCase());
            }
            if (o1 instanceof NodeBlock) {
                return 1;
            }
            if (o2 instanceof NodeBlock) {
                return 2;
            }
            return 0;
        };
        this.children.sort(c);
    }

    @Override
    public void setAcceptsDrop(boolean AcceptDrop) {
        this.mAcceptDrop = AcceptDrop;
    }

    public boolean AcceptsDrop() {
        return this.mAcceptDrop;
    }

    public NodeFolder() {
        super("New Group");
        this.setIcon(iconClosed);
        this.initNode();
    }

    public NodeFolder(String caption) {
        super(caption);
        this.setIcon(iconClosed);
        this.initNode();
    }

    public NodeFolder(String caption, String DefaultIcon) {
        super(caption, DefaultIcon);
        this.initNode();
    }

    public NodeFolder(String caption, String DefaultIcon, String IconOpened) {
        super(caption);
        this.setIconOpened(IconOpened);
        this.setIcon(DefaultIcon);
        this.initNode();
    }

    public NodeFolder(String caption, String DefaultIcon, String IconOpened, String IconClosed) {
        super(caption);
        this.setIconOpened(IconOpened);
        this.setIconClosed(IconClosed);
        this.setIcon(DefaultIcon);
        this.initNode();
    }

    public NodeFolder(String caption, ImageIcon DefaultIcon) {
        super(caption, DefaultIcon);
        this.initNode();
    }

    public NodeFolder(String caption, ImageIcon DefaultIcon, ImageIcon IconOpened) {
        super(caption, DefaultIcon, IconOpened);
        this.initNode();
    }

    public NodeFolder(String caption, ImageIcon DefaultIcon, ImageIcon IconOpened, ImageIcon IconClosed) {
        super(caption, DefaultIcon, IconOpened, IconClosed);
        this.initNode();
    }

    public NodeFolder(String caption, Image DefaultIcon) {
        super(caption, DefaultIcon);
        this.initNode();
    }

    public NodeFolder(String caption, Image DefaultIcon, Image IconOpened) {
        super(caption, DefaultIcon, IconOpened);
        this.initNode();
    }

    public NodeFolder(String caption, Image DefaultIcon, Image IconOpened, Image IconClosed) {
        super(caption, DefaultIcon, IconOpened, IconClosed);
        this.initNode();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean acceptsDrop(TransferHandler.TransferSupport info) {
        return this.mAcceptDrop;
    }

    @Override
    public void initNode() {
        this.setIconClosed(iconClosed);
        this.setIcon(iconOpen);
        this.editable = true;
        this.mMovable = false;
        this.setAllowsChildren(true);
    }

    @Override
    public XMLElement toXML() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

