/*
 * Decompiled with CFR 0.152.
 */
package BlockTree;

import BlockTree.XMLConstants;
import BlockTree.XMLDocument;
import BlockTree.XMLElement;

class XMLAttribute
implements XMLConstants {
    String keyWord = "";
    String value = "";
    XMLElement parent;

    public XMLAttribute() {
    }

    public XMLAttribute(String keyWord, String value) {
        this.setKeyWord(keyWord);
        this.setValue(value);
    }

    String serialize() {
        if (this.keyWord == null || this.value == null) {
            return "";
        }
        if (this.value.contains("'") && this.value.contains("\"")) {
            return this.keyWord + "=" + '\"' + XMLDocument.escapeString(this.value) + '\"';
        }
        if (this.value.contains("\"")) {
            return this.keyWord + "='" + this.value + "'";
        }
        return this.keyWord + "=" + '\"' + this.value + '\"';
    }

    public String toString() {
        return this.serialize();
    }

    void parse(XMLDocument.ParseableObject xmlData) {
        while (xmlData.cIndex < xmlData.data.length) {
            switch (xmlData.data[xmlData.cIndex]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    break;
                }
                case '\"': 
                case '\'': {
                    this.value = this.value + XMLDocument.parseValue(xmlData);
                    return;
                }
                default: {
                    if (!(xmlData.data[xmlData.cIndex] >= 'A' && xmlData.data[xmlData.cIndex] <= 'Z' || xmlData.data[xmlData.cIndex] >= 'a' && xmlData.data[xmlData.cIndex] <= 'z' || xmlData.data[xmlData.cIndex] == '_') && xmlData.data[xmlData.cIndex] != ':') break;
                    this.keyWord = XMLDocument.parseName(xmlData);
                    --xmlData.cIndex;
                }
            }
            ++xmlData.cIndex;
        }
    }

    private void setValue(String value) {
        this.value = value;
    }

    private void setKeyWord(String keyWord) {
        this.keyWord = keyWord;
    }
}

