/*
 * Decompiled with CFR 0.152.
 */
package BlockTree;

import BlockTree.XMLAttribute;
import BlockTree.XMLConstants;
import BlockTree.XMLDocument;
import BlockTree.XMLTag;
import java.util.ArrayList;
import java.util.Arrays;

class XMLElement
implements XMLConstants {
    ArrayList<XMLElement> elements;
    String name = null;
    int m_eStyle = 0;
    ArrayList<XMLAttribute> attributes;
    XMLElement parent;
    String body = "";
    protected boolean forceCharData = false;

    public XMLElement() {
    }

    public XMLElement(String name) {
        this.name = name;
    }

    public boolean hasText() {
        return this.body != null && this.body.length() > 0;
    }

    public String getText() {
        if (this.hasText()) {
            return this.body;
        }
        return "";
    }

    public void setText(String text) {
        this.body = text;
        if (this.body == null) {
            this.body = "";
        }
    }

    public boolean isForceCharData() {
        return this.forceCharData;
    }

    public void setForceCharData(boolean forceCharData) {
        this.forceCharData = forceCharData;
    }

    public int getTagStyle() {
        return this.m_eStyle;
    }

    public void setTagStyle(int tagStyle) {
        this.m_eStyle = tagStyle;
    }

    public void setTagType(String RHS) {
        this.name = RHS;
    }

    public String getTagType() {
        return this.name;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasElements() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public void setParent(XMLElement parent) {
        if (parent == null) {
            if (this.parent != null) {
                this.parent.removeElement(this);
            }
        } else {
            parent.addElement(this);
        }
    }

    public int getAttributeCount() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return 0;
        }
        return this.attributes.size();
    }

    public int getElementCount() {
        if (this.elements == null || this.elements.isEmpty()) {
            return 0;
        }
        return this.elements.size();
    }

    public void addElement(XMLElement element) {
        this.addElement(element, 0);
    }

    public XMLElement addElement(String name) {
        return this.addElement(name, "", 0);
    }

    public XMLElement addElement(String name, String body) {
        return this.addElement(name, body, 0);
    }

    public XMLElement addElement(String name, String body, int before) {
        XMLElement element = new XMLElement();
        element.setName(name);
        element.body = body;
        this.addElement(element, before);
        return element;
    }

    public void addElement(XMLElement element, int before) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        if (this.elements.contains(element)) {
            return;
        }
        if (element.parent != null) {
            element.parent.removeElement(element);
        }
        if (before == 0) {
            this.elements.add(element);
        } else {
            this.elements.add(before, element);
        }
        element.parent = this;
    }

    public XMLElement getElement(int index) {
        if (this.elements == null || index >= this.elements.size()) {
            return null;
        }
        return this.elements.get(index);
    }

    public XMLElement getElement(String keyWord) {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        for (XMLElement element : this.elements) {
            if (!element.name.equals(keyWord)) continue;
            return element;
        }
        return null;
    }

    public String getChildElementText(String keyWord, String defaultText, int startingIndex) {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        for (int x = startingIndex; x < this.elements.size(); ++x) {
            XMLElement element = this.elements.get(x);
            if (!element.name.equals(keyWord)) continue;
            return element.body;
        }
        return defaultText;
    }

    public String getChildElementText(String keyWord, String defaultText) {
        return this.getChildElementText(keyWord, defaultText, 0);
    }

    public int getIndex() {
        if (this.parent == null || this.parent.elements == null) {
            return -1;
        }
        return this.parent.elements.indexOf(this);
    }

    public XMLElement[] getElements() {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        XMLElement[] outArray = new XMLElement[this.elements.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = this.elements.get(x);
        }
        return outArray;
    }

    public int getElementIndex(String keyWord) {
        if (this.elements == null || this.elements.isEmpty()) {
            return -1;
        }
        for (int x = 0; x < this.elements.size(); ++x) {
            if (!this.elements.get(x).getName().equalsIgnoreCase(keyWord)) continue;
            return x;
        }
        return -1;
    }

    public void addAttribute(XMLAttribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        if (!this.attributes.contains(attribute)) {
            if (attribute.parent != null && this.parent.attributes.contains(attribute)) {
                this.parent.attributes.remove(attribute);
            }
            this.attributes.add(attribute);
            attribute.parent = this;
        }
    }

    public XMLAttribute addAttribute(String keyWord, boolean value) {
        return this.addAttribute(keyWord, value ? "true" : "false");
    }

    public XMLAttribute addAttribute(String keyWord, int value) {
        return this.addAttribute(keyWord, String.valueOf(value));
    }

    public XMLAttribute addAttribute(String keyWord, String value) {
        XMLAttribute attrib = new XMLAttribute(keyWord, value);
        this.addAttribute(attrib);
        return attrib;
    }

    public XMLAttribute getAttribute(int index) {
        if (this.attributes == null || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index);
    }

    public int getAttribute(String name, int defaultVal) {
        return Integer.valueOf(this.getAttribute(name, String.valueOf(defaultVal)));
    }

    public boolean getAttribute(String name, boolean defaultVal) {
        String sVal;
        switch (sVal = this.getAttribute(name, "false").toLowerCase()) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
        }
        return defaultVal;
    }

    public String getAttribute(String name, String defaultVal) {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            for (XMLAttribute attribute : this.attributes) {
                if (!attribute.keyWord.equals(name)) continue;
                return attribute.value;
            }
        }
        return defaultVal;
    }

    public float getAttribute(String name, float defaultVal) {
        return Float.valueOf(this.getAttribute(name, String.valueOf(defaultVal))).floatValue();
    }

    public long getAttribute(String name, long defaultVal) {
        return Long.valueOf(this.getAttribute(name, String.valueOf(defaultVal)));
    }

    int getAttributeIndex(String keyWord) {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return -1;
        }
        for (int x = 0; x < this.attributes.size(); ++x) {
            if (!this.attributes.get((int)x).keyWord.equalsIgnoreCase(keyWord)) continue;
            return x;
        }
        return -1;
    }

    public XMLAttribute[] getAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return null;
        }
        XMLAttribute[] outArray = new XMLAttribute[this.attributes.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = this.attributes.get(x);
        }
        return outArray;
    }

    public void removeAttribute(int index) {
        if (this.attributes == null || this.attributes.size() < index) {
            return;
        }
        this.attributes.remove(index);
    }

    public void removeAttribute(String keyWord) {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return;
        }
        int foundIndex = -1;
        for (int x = 0; x < this.attributes.size(); ++x) {
            XMLAttribute attribute = this.attributes.get(x);
            if (!attribute.keyWord.equalsIgnoreCase(keyWord)) continue;
            foundIndex = x;
            break;
        }
        if (foundIndex > -1) {
            this.attributes.remove(foundIndex);
        }
    }

    public void removeElement(int index) {
        if (this.elements != null && this.elements.size() > index) {
            XMLElement child = this.elements.get(index);
            child.parent = null;
            this.elements.remove(child);
        }
    }

    public void removeElement(XMLElement element) {
        if (this.elements != null && !this.elements.isEmpty()) {
            element.parent = null;
            this.elements.remove(element);
        }
    }

    public void removeElement(String keyWord) {
        int index = this.getElementIndex(keyWord);
        if (index > -1) {
            this.removeElement(index);
        }
    }

    public void setName(String RHS) {
        this.name = RHS;
    }

    public String getName() {
        return this.name;
    }

    boolean parse(XMLDocument.ParseableObject xmlData) {
        return this.parse(xmlData, false);
    }

    boolean parse(XMLDocument.ParseableObject xmlData, boolean isBody) {
        boolean bStart = isBody;
        if (xmlData.cIndex < 0) {
            return false;
        }
        if (this.elements == null) {
            this.elements = new ArrayList();
        } else {
            this.elements.clear();
        }
        boolean chData = false;
        while (xmlData.cIndex < xmlData.data.length) {
            if (xmlData.data[xmlData.cIndex] == '<' && xmlData.cIndex < xmlData.data.length - 1 && xmlData.data[xmlData.cIndex + 1] != '!') {
                XMLTag oTag = new XMLTag();
                oTag.parse(xmlData);
                if (this.name == null) {
                    this.attributes = oTag.attributes;
                    this.name = oTag.name;
                    this.m_eStyle = oTag.m_eStyle;
                    switch (this.m_eStyle) {
                        case 2: {
                            return false;
                        }
                        case 1: {
                            this.name = null;
                            break;
                        }
                        case 0: {
                            bStart = true;
                            break;
                        }
                    }
                } else {
                    if (oTag.m_eStyle == 1) {
                        return true;
                    }
                    XMLElement oChild = new XMLElement();
                    oChild.attributes = oTag.attributes;
                    oChild.name = oTag.name;
                    oChild.m_eStyle = oTag.m_eStyle;
                    oChild.parse(xmlData, true);
                    if (oChild.body != null && oChild.body.length() > 0) {
                        this.processBody(oChild);
                    }
                    this.addElement(oChild);
                }
            } else if (this.isCData(xmlData)) {
                bStart = true;
                chData = true;
                this.body = this.getCDATA(xmlData);
            } else if (xmlData.data[xmlData.cIndex] == '<' && xmlData.cIndex < xmlData.data.length - 12 && xmlData.data[xmlData.cIndex + 1] == '!') {
                bStart = true;
                this.body = this.body + xmlData.data[xmlData.cIndex];
            } else if (xmlData.data[xmlData.cIndex] == '&') {
                if (bStart) {
                    this.body = this.body + XMLDocument.decodeEscape(xmlData);
                }
            } else if (bStart) {
                this.body = this.body + xmlData.data[xmlData.cIndex];
            }
            ++xmlData.cIndex;
        }
        if (!chData && this.body != null && this.body.length() > 0) {
            this.processBody(this);
            this.body = this.body.replaceFirst("[\\s\\t\\n\\r]+$", "");
        }
        return true;
    }

    private String getCDATA(XMLDocument.ParseableObject xmlData) {
        String body = "";
        while (xmlData.cIndex < xmlData.data.length - 4) {
            if (xmlData.data[xmlData.cIndex] == ']' && xmlData.data[xmlData.cIndex + 1] == ']' && xmlData.data[xmlData.cIndex + 2] == '>') {
                xmlData.cIndex += 2;
                break;
            }
            body = body + xmlData.data[xmlData.cIndex];
            ++xmlData.cIndex;
        }
        return body;
    }

    private boolean isCData(XMLDocument.ParseableObject xmlData) {
        if (xmlData.cIndex > xmlData.data.length - 12) {
            return false;
        }
        if (xmlData.data[xmlData.cIndex] != '<') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 1] != '!') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 2] != '[') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 3] != 'C') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 4] != 'D') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 5] != 'A') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 6] != 'T') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 7] != 'A') {
            return false;
        }
        if (xmlData.data[xmlData.cIndex + 8] != '[') {
            return false;
        }
        xmlData.cIndex += 9;
        return true;
    }

    String serializeTag(int tagStyle) {
        if (tagStyle == 0 || tagStyle == 2) {
            StringBuilder builder = new StringBuilder("<" + this.name);
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (XMLAttribute attribute : this.attributes) {
                    builder.append(" ").append(attribute.serialize());
                }
            }
            if (tagStyle == 2) {
                builder.append("/>");
            } else {
                builder.append(">");
            }
            return builder.toString();
        }
        return "</" + this.name + ">";
    }

    private String serializeTag() {
        return this.serializeTag(0);
    }

    public String serialize() {
        if (this.name == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.serializeTag());
        if (this.body != null && this.body.length() > 0) {
            if (this.body.length() > 49) {
                builder.append("\r\n" + XMLDocument.escapeString(this.body) + "\r\n");
            } else {
                builder.append(XMLDocument.escapeString(this.body));
            }
        }
        if (this.elements != null && !this.elements.isEmpty()) {
            for (XMLElement element : this.elements) {
                builder.append(element.serialize());
            }
        }
        builder.append(this.serializeTag(1));
        return builder.toString();
    }

    public String exportToString() {
        return this.exportToString(0);
    }

    public String exportToString(int indentLevel) {
        boolean haveElements;
        StringBuilder outString = new StringBuilder();
        int spacesPerIndent = 4;
        String indent = "";
        String NLIndent = "";
        String NLIndent2 = "";
        if (this.name == null) {
            return "";
        }
        if (indentLevel > 0) {
            indent = XMLElement.repeat(' ', indentLevel * spacesPerIndent);
        }
        NLIndent = "\r\n" + indent;
        NLIndent2 = "\r\n" + XMLElement.repeat(' ', (indentLevel + 1) * spacesPerIndent);
        String tmpBody = null;
        if (this.parent != null) {
            outString.append(NLIndent);
        }
        outString.append(this.serializeTag());
        boolean haveBody = false;
        boolean bl = haveElements = this.elements != null && !this.elements.isEmpty();
        if (this.body != null && this.body.length() > 0 && (tmpBody = XMLDocument.escapeString(this.body)) != null && tmpBody.length() > 0) {
            if (haveElements || tmpBody.contains("\r\n")) {
                haveBody = true;
                outString.append(NLIndent2).append(tmpBody.replace("\r\n", NLIndent2));
            } else {
                outString.append(tmpBody);
            }
        }
        if (haveElements) {
            haveElements = true;
            for (XMLElement element : this.elements) {
                outString.append(element.exportToString(indentLevel + 1));
            }
        }
        if (haveBody || haveElements) {
            outString.append(NLIndent);
        }
        outString.append(this.serializeTag(1));
        return outString.toString();
    }

    private void processBody(XMLElement element) {
        char chr;
        int index;
        if (element.body.length() == 0) {
            return;
        }
        int start = -1;
        int stop = -1;
        block6: for (index = 0; index < element.body.length(); ++index) {
            chr = element.body.charAt(index);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                default: {
                    start = index;
                    break block6;
                }
            }
        }
        if (start == -1) {
            element.body = "";
            return;
        }
        block7: for (index = element.body.length() - 1; index >= start; --index) {
            chr = element.body.charAt(index);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block7;
                }
                default: {
                    stop = index;
                    break block7;
                }
            }
        }
        if (stop == -1) {
            element.body = "";
            return;
        }
        element.body = element.body.substring(start, stop + 1);
        element.body = XMLDocument.unEscapeString(element.body);
    }

    public static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }

    public static String repeat(String string, int count) {
        int copied;
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return string;
        }
        byte[] value = string.getBytes();
        int coder = 0;
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single, coder);
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new OutOfMemoryError("Repeating " + len + " bytes String " + count + " times will produce a String exceeding maximum size.");
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple, coder);
    }
}

