/*
 * Decompiled with CFR 0.152.
 */
package Buttons;

import Buttons.ButtonStatedIcon;
import HSL.HSLColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ButtonRenderer {
    public eButtonType buttonType = eButtonType.CommandButton;
    private JComponent parent;
    boolean shiftOnPress = false;
    private int x1 = 0;
    private int y1 = 0;
    private int x2 = 0;
    private int y2 = 0;
    private String caption = "";
    private int lH;
    private int lW;
    private boolean useThemeColor = false;
    private boolean value = false;
    private Alignments captionAlign = new Alignments();
    private Alignments iconAlign = new Alignments();
    private GradientPaint gradient;
    private Color colorCaptionNormal = Color.black;
    private Color colorCaptionRollover = Color.black;
    private Color colorCaptionPressed = Color.black;
    private int deltaX = 0;
    private int deltaY = 0;
    private int mMouseState;
    private margin buttonMargins = new margin(0, 0, 10, 10);
    private margin iconMargins = new margin(2, 2, 2, 2);
    private Color colorNormal = Color.BLUE;
    private Color colorRolover = Color.BLUE;
    private Color colorPressed = Color.BLUE;
    private Color borderColorHot = this.colorRolover.darker();
    final ButtonStatedIcon icon = new ButtonStatedIcon();
    private Color borderColor = Color.red;
    private Color startColor = Color.white;
    private Color endColor = new Color(253, 81, 81);
    private int LastState = 0;
    private static final Color defShineyTopPressed = new Color(81, 149, 235);
    private static final Color defShineyBotPressed = new Color(36, 80, 193);
    private static final Color defShineyGlarePressed = new Color(148, 177, 228);
    private static final Color defShineyTopDef = new Color(116, 161, 216);
    private static final Color defShineyBotDef = new Color(81, 117, 206);
    private static final Color defShineyGlareDef = new Color(122, 157, 212);
    private static final Color defShineyTopHot = new Color(160, 191, 233);
    private static final Color defShineyBotHot = new Color(102, 132, 216);
    private static final Color defShineyGlareHot = new Color(200, 211, 242);
    private static final Color defShineyBorderDef = new Color(89, 134, 183);
    private Color shineyTopPressed = defShineyTopPressed;
    private Color shineyBotPressed = defShineyBotPressed;
    private Color shineyGlarePressed = defShineyGlarePressed;
    private Color shineyBorderPressed = defShineyBorderDef;
    private Color shineyTopDef = defShineyTopDef;
    private Color shineyBotDef = defShineyBotDef;
    private Color shineyGlareDef = defShineyGlareDef;
    private Color shineyBorderDef = defShineyBorderDef;
    private Color shineyTopHot = defShineyTopHot;
    private Color shineyBotHot = defShineyBotHot;
    private Color shineyGlareHot = defShineyGlareHot;
    private Color shineyBorderHot = defShineyBorderDef;
    private boolean shineyColorsMade = false;
    public ButtonStyle buttonStyle = ButtonStyle.GlossyButton;
    private boolean focusPainted = true;

    public void setColorBorderHot(Color color) {
        this.borderColorHot = color;
    }

    public Color getGradientBorderColor() {
        return this.borderColor;
    }

    public void setGradientBorderColor(Color color) {
        this.borderColor = color;
        this.parent.repaint();
    }

    public Color getGradientStartColor() {
        return this.startColor;
    }

    public void setGradientStartColor(Color color) {
        this.startColor = color;
        this.parent.repaint();
    }

    public Color getGradientEndColor() {
        return this.endColor;
    }

    public void setGradientEndColor(Color color) {
        this.endColor = color;
        this.parent.repaint();
    }

    public Icon getIcon() {
        return this.icon.getIcon(2);
    }

    public void setIcon(Icon icon) {
        this.icon.setIcon(icon, 2);
    }

    public Icon getIconHot() {
        return this.icon.getIcon(1);
    }

    public void setIconHot(Icon icon) {
        this.icon.setIcon(icon, 1);
    }

    public Icon getIconPressed() {
        return this.icon.getIcon(4);
    }

    public void setIconPressed(Icon icon) {
        this.icon.setIcon(icon, 4);
    }

    public void setDisabledSelectedIcon(Icon icon) {
        this.icon.setIcon(icon, 32);
    }

    public Icon getDisabledSelectedIcon() {
        return this.icon.getIcon(32);
    }

    public boolean isValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
        this.parent.repaint();
    }

    public boolean isShiftOnPress() {
        return this.shiftOnPress;
    }

    public void setShiftOnPress(boolean shift) {
        this.shiftOnPress = shift;
    }

    public eButtonType getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(eButtonType buttonType) {
        this.buttonType = buttonType;
        this.parent.repaint();
    }

    public Color getColorCaptionHot() {
        return this.colorCaptionRollover;
    }

    public void setColorCaptionHot(Color color) {
        this.colorCaptionRollover = color;
        this.parent.repaint();
    }

    public Color getColorCaptionPressed() {
        return this.colorCaptionPressed;
    }

    public void setColorCaptionPressed(Color color) {
        this.colorCaptionPressed = color;
        this.parent.repaint();
    }

    public boolean isUseThemeColors() {
        return this.useThemeColor;
    }

    public void setUseThemeColors(boolean use) {
        this.useThemeColor = use;
    }

    public Color getColorCaptionNormal() {
        return this.colorCaptionNormal;
    }

    public void setColorCaptionNormal(Color color) {
        this.colorCaptionNormal = color;
        this.parent.repaint();
    }

    public void setAllCaptionColors(Color color) {
        this.colorCaptionNormal = color;
        this.colorCaptionPressed = color;
        this.colorCaptionRollover = color;
        this.parent.repaint();
    }

    public Color getColorHot() {
        return this.colorRolover;
    }

    public void setColorRollover(Color color) {
        this.colorRolover = color;
        this.shineyColorsMade = false;
        this.parent.repaint();
    }

    public void setAllBackColors(Color color) {
        this.colorNormal = color;
        this.colorPressed = color;
        this.colorRolover = color;
        this.shineyColorsMade = false;
        this.parent.repaint();
    }

    public Color getColorPressed() {
        return this.colorPressed;
    }

    public void setColorPressed(Color color) {
        this.colorPressed = color;
        this.shineyColorsMade = false;
        this.parent.repaint();
    }

    public Color getColorNormal() {
        return this.colorNormal;
    }

    public void setColorNormal(Color color) {
        this.colorNormal = color;
        this.shineyColorsMade = false;
        this.parent.repaint();
    }

    public ButtonStyle getButtonStyle() {
        return this.buttonStyle;
    }

    public void setButtonStyle(ButtonStyle style) {
        this.buttonStyle = style;
        this.parent.repaint();
    }

    public Alignment getCaptionAlignment() {
        return this.captionAlign.alignment();
    }

    public void setCaptionAlignment(Alignment alignment) {
        this.captionAlign.setAlignment(alignment);
        this.parent.repaint();
    }

    public Alignment getIconAlignment() {
        return this.iconAlign.alignment();
    }

    public void setIconAlignment(Alignment alignment) {
        this.iconAlign.setAlignment(alignment);
        this.parent.repaint();
    }

    public void setFocusPainted(boolean focusPainted) {
        this.focusPainted = focusPainted;
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    private void GenShineyColors() {
        HSLColor color = new HSLColor(this.colorRolover);
        this.shineyTopHot = color.adjustHSL(0.89383566f, 0.62393165f, 1.5411766f);
        this.shineyBotHot = color.adjustHSL(0.93421054f, 0.59374994f, 1.2470589f);
        this.shineyGlareHot = color.adjustHSL(0.9345238f, 0.6176472f, 1.7333332f);
        this.shineyBorderHot = color.adjustHSL(0.8803192f, 0.39495805f, 1.0666667f);
        HSLColor color2 = new HSLColor(this.colorPressed);
        this.shineyTopPressed = color2.adjustHSL(0.8896104f, 0.7938144f, 1.2392157f);
        this.shineyBotPressed = color2.adjustHSL(0.9299363f, 0.68558955f, 0.8980392f);
        this.shineyGlarePressed = color2.adjustHSL(0.909375f, 0.59701484f, 1.4745098f);
        this.shineyBorderPressed = color2.adjustHSL(0.8803192f, 0.39495805f, 1.0666667f);
        HSLColor color3 = new HSLColor(this.colorNormal);
        this.shineyTopDef = color3.adjustHSL(0.8875f, 0.5617977f, 1.3019607f);
        this.shineyBotDef = color3.adjustHSL(0.92800003f, 0.5605382f, 1.1254902f);
        this.shineyGlareDef = color3.adjustHSL(0.90277773f, 0.51136357f, 1.309804f);
        this.shineyBorderDef = color3.adjustHSL(0.8803192f, 0.39495805f, 1.0666667f);
        this.shineyColorsMade = true;
    }

    public void paint(Graphics g, int state) {
        this.mMouseState = state;
        this.x1 = 0;
        this.y1 = 0;
        this.lH = this.parent.getHeight();
        this.lW = this.parent.getWidth();
        this.x2 = this.x1 + this.lW - 1;
        this.y2 = this.y1 + this.lH - 1;
        this.paint(g);
    }

    public void paint(Graphics g, int state, int x1, int y1) {
        this.mMouseState = state;
        this.x1 = x1;
        this.y1 = y1;
        this.lH = this.parent.getHeight();
        this.lW = this.parent.getWidth();
        this.x2 = x1 + this.lW - 1;
        this.y2 = y1 + this.lH - 1;
        this.paint(g);
    }

    public void paint(Graphics g, int x1, int y1, int x2, int y2, boolean mouseover, boolean mousedown, boolean disabled) {
        this.mMouseState = disabled ? 8 : (mousedown ? 4 : (mouseover ? 1 : 4));
        this.paint(g, this.mMouseState, x1, y1, x2, y2);
    }

    public void paint(Graphics g, int state, int x1, int y1, int x2, int y2) {
        this.mMouseState = state;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.lH = y2 - y1 + 1;
        this.lW = x2 - x1 + 1;
        this.paint(g);
    }

    private void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        switch (this.buttonStyle) {
            case Soft: {
                ButtonRenderer.paintSoft(this, g2d);
                break;
            }
            case Flat: {
                ButtonRenderer.paintFlat(this, g2d);
                break;
            }
            case OfficeXP: {
                ButtonRenderer.paintOfficeXP(this, g2d);
                break;
            }
            case OfficeXPColored: {
                ButtonRenderer.paintOfficeXPColored(this, g2d);
                break;
            }
            case Galaxy: {
                ButtonRenderer.paintGalaxy(this, g2d);
                break;
            }
            case GelButton: {
                ButtonRenderer.paintGelButton(this, g2d);
                break;
            }
            case VistaAero: 
            case VistaAeroColored: {
                ButtonRenderer.paintVista(this, g2d);
                break;
            }
            case GlossyButton: {
                ButtonRenderer.paintGlossyButton(this, g2d);
                break;
            }
            case ShineyButtonColored: {
                if (!this.shineyColorsMade) {
                    this.GenShineyColors();
                }
            }
            case ShineyButton: {
                ButtonRenderer.paintShineyButton(this, g2d);
                break;
            }
            case Plain: {
                ButtonRenderer.paintPlain(this, g2d);
                break;
            }
            case WindowsXP: {
                ButtonRenderer.paintWindows(this, g2d);
                break;
            }
            default: {
                ButtonRenderer.paintGradientButton(this, g2d);
            }
        }
    }

    private static void paintGradientButton(ButtonRenderer renderer, Graphics2D g2d) {
        g2d.setClip(new RoundRectangle2D.Double(renderer.x1 + 1, renderer.y1 + 1, renderer.lW - 2, renderer.lH - 2, 10.0, 10.0));
        if (renderer.LastState != renderer.mMouseState) {
            switch (renderer.mMouseState) {
                case 8: {
                    renderer.gradient = new GradientPaint(renderer.x1, renderer.y1, Color.WHITE, renderer.x2, renderer.y2, Color.LIGHT_GRAY, false);
                    break;
                }
                case 1: {
                    renderer.gradient = new GradientPaint(renderer.x1, renderer.y1, renderer.startColor, renderer.x2, renderer.y2, renderer.endColor.darker(), false);
                    break;
                }
                case 4: {
                    renderer.gradient = new GradientPaint(renderer.x1, renderer.y1, renderer.endColor.darker(), renderer.x2, renderer.y2, renderer.startColor, false);
                    break;
                }
                default: {
                    renderer.gradient = new GradientPaint(renderer.x1, renderer.y1, renderer.startColor, renderer.x2, renderer.y2, renderer.endColor, false);
                }
            }
        }
        Color textColor = renderer.mMouseState == 8 ? Color.GRAY : renderer.parent.getForeground();
        g2d.setPaint(renderer.gradient);
        g2d.fillRect(renderer.x1 + 1, renderer.y1 + 1, renderer.lW - 1, renderer.lH - 1);
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
        g2d.setClip(null);
        g2d.setColor(renderer.parent.hasFocus() && renderer.focusPainted ? renderer.borderColor.darker() : renderer.borderColor);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawRoundRect(renderer.x1 + 1, renderer.y1 + 1, renderer.lW - 2, renderer.lH - 2, 10, 10);
        g2d.setStroke(new BasicStroke(1.0f));
    }

    private static void paintVista(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Color borderColor;
        Rect ButtonRect = new Rect(renderer.x1 + 1, renderer.y1 + 1, renderer.x2 - 2, renderer.y2 - 2);
        g2d.setClip(new RoundRectangle2D.Double(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height, 3.0, 3.0));
        switch (renderer.mMouseState) {
            case 8: {
                Color ColorTop = renderer.buttonStyle == ButtonStyle.VistaAero ? new Color(232, 244, 255) : Color.LIGHT_GRAY;
                g2d.setColor(ColorTop);
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height);
                g2d.setColor(Color.WHITE);
                g2d.drawRect(ButtonRect.left + 1, ButtonRect.top + 1, ButtonRect.width - 2, ButtonRect.height - 2);
                borderColor = new Color(190, 172, 189);
                textColor = Color.GRAY;
                break;
            }
            case 1: {
                Color BotSide;
                Color TopSide;
                Color ColorBot;
                Color ColorTop;
                if (renderer.buttonStyle == ButtonStyle.VistaAero) {
                    ColorTop = new Color(222, 245, 255);
                    ColorBot = new Color(188, 231, 255);
                    TopSide = new Color(211, 241, 255);
                    BotSide = new Color(151, 218, 252);
                    borderColor = new Color(50, 117, 167);
                    textColor = Color.black;
                } else {
                    ColorTop = ButtonRenderer.ShiftColor(renderer.colorRolover, 0.1f);
                    ColorBot = ButtonRenderer.ShiftColor(ColorTop, -0.3f);
                    TopSide = ButtonRenderer.ShiftColor(ColorTop, -0.2f);
                    BotSide = ButtonRenderer.ShiftColor(ColorBot, -0.1f);
                    borderColor = ButtonRenderer.ShiftColor(ColorBot, -0.3f);
                    textColor = renderer.colorCaptionRollover;
                }
                g2d.setColor(ColorTop);
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height / 2);
                g2d.setColor(ColorBot);
                g2d.fillRect(ButtonRect.left, ButtonRect.height / 2 + 1, ButtonRect.width, ButtonRect.height / 2);
                ButtonRenderer.paintGradient(g2d, ColorTop, TopSide, new Rect(ButtonRect.right - 7, renderer.y1, ButtonRect.right, ButtonRect.height / 2), GradientDirection.horizontal);
                ButtonRenderer.paintGradient(g2d, TopSide, ColorTop, new Rect(renderer.x1 + 2, renderer.y1, renderer.x1 + 5, ButtonRect.height / 2), GradientDirection.horizontal);
                ButtonRenderer.paintGradient(g2d, ColorBot, BotSide, new Rect(ButtonRect.right - 7, ButtonRect.height / 2 + 1, ButtonRect.right, ButtonRect.Bottom), GradientDirection.horizontal);
                ButtonRenderer.paintGradient(g2d, BotSide, ColorBot, new Rect(renderer.x1 + 2, ButtonRect.height / 2 + 1, renderer.x1 + 7, ButtonRect.Bottom), GradientDirection.horizontal);
                break;
            }
            case 4: {
                Color ColorTopG;
                Color BotSide;
                Color TopSide;
                Color ColorBot;
                Color ColorTop;
                if (renderer.buttonStyle == ButtonStyle.VistaAero) {
                    ColorTop = new Color(194, 228, 246);
                    ColorBot = new Color(154, 210, 240);
                    TopSide = new Color(150, 205, 235);
                    BotSide = new Color(83, 176, 255);
                    ColorTopG = new Color(113, 156, 179);
                    borderColor = new Color(29, 65, 92);
                    textColor = Color.black;
                } else {
                    ColorTop = ButtonRenderer.ShiftColor(renderer.colorPressed, -0.1f);
                    ColorBot = ButtonRenderer.ShiftColor(ColorTop, -0.3f);
                    TopSide = ButtonRenderer.ShiftColor(ColorTop, -0.1f);
                    BotSide = ButtonRenderer.ShiftColor(ColorBot, -0.1f);
                    ColorTopG = ButtonRenderer.ShiftColor(BotSide, -0.3f);
                    borderColor = ButtonRenderer.ShiftColor(ColorBot, -0.3f);
                    textColor = renderer.colorCaptionPressed;
                }
                g2d.setColor(ColorTop);
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height / 2);
                g2d.setColor(ColorBot);
                g2d.fillRect(ButtonRect.left, ButtonRect.height / 2 + 1, ButtonRect.width, ButtonRect.height / 2);
                ButtonRenderer.paintGradient(g2d, ColorTopG, ColorTop, new Rect(renderer.x1, ButtonRect.top + 1, ButtonRect.right, ButtonRect.top + 4), GradientDirection.vertical);
                ButtonRenderer.paintGradient(g2d, TopSide, ColorTop, new Rect(renderer.x1 + 1, ButtonRect.top + 3, renderer.x1 + 6, ButtonRect.height / 2), GradientDirection.horizontal);
                ButtonRenderer.paintGradient(g2d, ColorTop, TopSide, new Rect(ButtonRect.right - 6, ButtonRect.top + 3, ButtonRect.right, ButtonRect.height / 2), GradientDirection.horizontal);
                ButtonRenderer.paintGradient(g2d, BotSide, ColorBot, new Rect(renderer.x1 + 1, ButtonRect.height / 2 + 1, renderer.x1 + 6, ButtonRect.height), GradientDirection.horizontal);
                ButtonRenderer.paintGradient(g2d, ColorBot, BotSide, new Rect(ButtonRect.right - 6, ButtonRect.height / 2 + 1, ButtonRect.right, ButtonRect.Bottom), GradientDirection.horizontal);
                textColor = renderer.parent.getForeground();
                break;
            }
            default: {
                Color ColorBot;
                Color ColorTop;
                if (renderer.buttonStyle == ButtonStyle.VistaAero) {
                    ColorTop = new Color(234, 246, 255);
                    ColorBot = new Color(213, 225, 242);
                    borderColor = new Color(112, 112, 112);
                    textColor = Color.black;
                } else {
                    ColorTop = ButtonRenderer.ShiftColor(renderer.colorNormal, 0.5f);
                    ColorBot = ButtonRenderer.ShiftColor(ColorTop, -0.2f);
                    borderColor = ButtonRenderer.ShiftColor(ColorBot, -0.5f);
                    textColor = renderer.colorCaptionNormal;
                }
                g2d.setColor(ColorTop);
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height / 2);
                g2d.setColor(ColorBot);
                g2d.fillRect(ButtonRect.left, ButtonRect.height / 2 + 1, ButtonRect.width, ButtonRect.height / 2);
            }
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
        g2d.setColor(renderer.parent.hasFocus() && renderer.isFocusPainted() ? borderColor.darker() : borderColor);
        g2d.setClip(null);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawRoundRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.height - 1, 3, 3);
    }

    private static void paintShineyButton(ButtonRenderer renderer, Graphics2D g2d) {
        Color ColorGlare;
        Color textColor;
        Color borderColor;
        Color ColorBot;
        Color ColorTop;
        int ellipse = 10;
        Rect ButtonRect = new Rect(renderer.x1 + 1, renderer.y1 + 1, renderer.x2, renderer.y2);
        g2d.setClip(new RoundRectangle2D.Double(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height, 10.0, 10.0));
        switch (renderer.mMouseState) {
            case 8: {
                ColorTop = Color.LIGHT_GRAY;
                Color ColorTop2 = Color.LIGHT_GRAY;
                ColorBot = Color.GRAY;
                Color ColorBot2 = Color.GRAY;
                g2d.setColor(ColorTop);
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height);
                borderColor = Color.GRAY;
                textColor = Color.WHITE;
                ColorGlare = Color.LIGHT_GRAY;
                break;
            }
            case 1: {
                if (renderer.buttonStyle.equals((Object)ButtonStyle.ShineyButtonColored)) {
                    ColorTop = renderer.shineyTopHot;
                    ColorBot = renderer.shineyBotHot;
                    ColorGlare = renderer.shineyGlareHot;
                    borderColor = renderer.shineyBorderHot;
                    textColor = renderer.colorCaptionRollover;
                    break;
                }
                ColorTop = defShineyTopHot;
                ColorBot = defShineyBotHot;
                ColorGlare = defShineyGlareHot;
                borderColor = defShineyBorderDef;
                textColor = Color.WHITE;
                break;
            }
            case 4: {
                if (renderer.buttonStyle.equals((Object)ButtonStyle.ShineyButtonColored)) {
                    ColorTop = renderer.shineyTopPressed;
                    ColorBot = renderer.shineyBotPressed;
                    borderColor = renderer.shineyBorderPressed;
                    ColorGlare = renderer.shineyGlarePressed;
                    textColor = renderer.colorCaptionPressed;
                    break;
                }
                ColorTop = defShineyTopPressed;
                ColorBot = defShineyBotPressed;
                ColorGlare = defShineyGlarePressed;
                borderColor = defShineyBorderDef;
                textColor = Color.WHITE;
                break;
            }
            default: {
                if (renderer.buttonStyle.equals((Object)ButtonStyle.ShineyButtonColored)) {
                    ColorTop = renderer.shineyTopDef;
                    ColorBot = renderer.shineyBotDef;
                    borderColor = renderer.shineyBorderDef;
                    ColorGlare = renderer.shineyGlareDef;
                    textColor = renderer.colorCaptionNormal;
                    break;
                }
                ColorTop = defShineyTopDef;
                ColorBot = defShineyBotDef;
                ColorGlare = defShineyGlareDef;
                borderColor = defShineyBorderDef;
                textColor = Color.WHITE;
            }
        }
        g2d.setColor(ColorTop);
        g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height);
        g2d.setClip(new RoundRectangle2D.Double(ButtonRect.left + 1, ButtonRect.MidY, ButtonRect.width - 2, ButtonRect.height / 2, 10.0, 10.0));
        g2d.setColor(ColorBot);
        g2d.fillRect(ButtonRect.left, ButtonRect.height / 2 + 1, ButtonRect.width, ButtonRect.height / 2);
        if (renderer.mMouseState != 8) {
            float radius = ButtonRect.MidY * 3 / 2;
            Point2D.Float center = new Point2D.Float(ButtonRect.MidX, (float)ButtonRect.height + radius / 2.0f);
            Color[] colors = new Color[]{ColorGlare, ColorGlare, ColorBot};
            float[] dist = new float[]{0.0f, 0.1f, 1.0f};
            RadialGradientPaint p = new RadialGradientPaint(center, radius, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            g2d.setPaint(p);
            g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.right, ButtonRect.Bottom);
        }
        g2d.setClip(new RoundRectangle2D.Double(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height, 10.0, 10.0));
        ButtonRenderer.paintGradient(g2d, ColorTop, Color.WHITE, new Rect(ButtonRect.left + ButtonRect.width / 4, ButtonRect.top + 2, ButtonRect.left + ButtonRect.MidX, ButtonRect.top + 2), GradientDirection.horizontal);
        ButtonRenderer.paintGradient(g2d, Color.WHITE, ColorTop, new Rect(ButtonRect.left + ButtonRect.MidX, ButtonRect.top + 2, ButtonRect.left + ButtonRect.width * 3 / 4, ButtonRect.top + 2), GradientDirection.horizontal);
        ButtonRenderer.paintGradient(g2d, ColorBot, Color.WHITE, new Rect(ButtonRect.left + ButtonRect.width / 4, ButtonRect.Bottom - 1, ButtonRect.left + ButtonRect.MidX, ButtonRect.Bottom - 1), GradientDirection.horizontal);
        ButtonRenderer.paintGradient(g2d, Color.WHITE, ColorBot, new Rect(ButtonRect.left + ButtonRect.MidX, ButtonRect.Bottom - 1, ButtonRect.left + ButtonRect.width * 3 / 4, ButtonRect.Bottom - 1), GradientDirection.horizontal);
        ButtonRenderer.paintGradient(g2d, ColorTop, Color.WHITE, new Rect(ButtonRect.left, ButtonRect.height / 4, ButtonRect.left + 1, ButtonRect.top + ButtonRect.MidY), GradientDirection.vertical);
        ButtonRenderer.paintGradient(g2d, Color.WHITE, ColorBot, new Rect(ButtonRect.left, ButtonRect.top + ButtonRect.MidY, ButtonRect.left + 1, ButtonRect.top + ButtonRect.Bottom * 3 / 4), GradientDirection.vertical);
        ButtonRenderer.paintGradient(g2d, ColorTop, Color.WHITE, new Rect(ButtonRect.right - 1, ButtonRect.top + ButtonRect.height / 4, ButtonRect.right, ButtonRect.top + ButtonRect.MidY), GradientDirection.vertical);
        ButtonRenderer.paintGradient(g2d, Color.WHITE, ColorBot, new Rect(ButtonRect.right - 1, ButtonRect.top + ButtonRect.MidY, ButtonRect.right, ButtonRect.top + ButtonRect.Bottom * 3 / 4), GradientDirection.vertical);
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
        g2d.setColor(renderer.parent.hasFocus() && renderer.focusPainted ? borderColor.darker() : borderColor);
        g2d.setClip(null);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawRoundRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.height - 1, 10, 10);
        g2d.setStroke(new BasicStroke(1.0f));
    }

    private static void paintGelButton(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Color Color3;
        Color Color2;
        Color Color1;
        Rect ButtonRect = new Rect(renderer.x1 + 1, renderer.y1 + 1, renderer.x2 - 2, renderer.y2 - 2);
        g2d.setClip(new RoundRectangle2D.Double(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height, 3.0, 3.0));
        switch (renderer.mMouseState) {
            case 8: {
                Color1 = ButtonRenderer.ShiftColor(Color.LIGHT_GRAY, 0.05f);
                Color2 = ButtonRenderer.ShiftColor(Color.LIGHT_GRAY, -0.02f);
                Color3 = Color.LIGHT_GRAY;
                textColor = Color.GRAY;
                break;
            }
            case 1: {
                Color1 = renderer.colorRolover;
                Color2 = ButtonRenderer.ShiftColor(Color1, -0.03f);
                Color3 = ButtonRenderer.ShiftColor(Color1, 0.1f);
                textColor = renderer.colorCaptionRollover;
                break;
            }
            case 4: {
                Color1 = renderer.colorPressed;
                Color2 = ButtonRenderer.ShiftColor(Color1, -0.09f);
                Color3 = ButtonRenderer.ShiftColor(Color1, 0.1f);
                textColor = renderer.colorCaptionPressed;
                break;
            }
            default: {
                Color1 = renderer.colorNormal;
                Color2 = ButtonRenderer.ShiftColor(Color1, -0.02f);
                Color3 = ButtonRenderer.ShiftColor(Color1, 0.2f);
                textColor = renderer.colorCaptionNormal;
            }
        }
        ButtonRenderer.paintGradient(g2d, Color.WHITE, Color1, new Rect(ButtonRect.left, ButtonRect.top, ButtonRect.right, 5), GradientDirection.vertical);
        ButtonRenderer.paintGradient(g2d, Color2, Color3, new Rect(0, 6, ButtonRect.right, ButtonRect.height), GradientDirection.vertical);
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
        g2d.setColor(renderer.parent.hasFocus() && renderer.focusPainted ? ButtonRenderer.ShiftColor(Color1, -0.1f).darker() : ButtonRenderer.ShiftColor(Color1, -0.1f));
        g2d.setClip(null);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawRoundRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.height - 1, 3, 3);
        g2d.setStroke(new BasicStroke(1.0f));
    }

    private static void paintGlossyButton(ButtonRenderer renderer, Graphics2D g2d) {
        int EllipseWd;
        Color textColor;
        Color BkCol;
        Color BColor3;
        Color GColor2;
        Color BColor2;
        Color BColor1;
        Color GrayColor = new Color(0xC0C0C0);
        switch (renderer.mMouseState) {
            case 8: {
                Color bColorTop = ButtonRenderer.ShiftColor(GrayColor, 0.1f);
                BColor1 = GrayColor;
                BColor2 = ButtonRenderer.ShiftColor(GrayColor, 0.2f);
                GColor2 = BColor1;
                BColor3 = Color.WHITE;
                BkCol = new Color(0x808080);
                textColor = Color.GRAY;
                break;
            }
            case 1: {
                Color bColorTop = ButtonRenderer.ShiftColor(renderer.colorRolover, 0.1f);
                BColor1 = renderer.colorRolover;
                BColor2 = ButtonRenderer.ShiftColor(renderer.colorRolover, -0.01f);
                GColor2 = BColor1;
                BColor3 = Color.WHITE;
                BkCol = ButtonRenderer.ShiftColor(renderer.colorRolover, -0.1f);
                if (!renderer.useThemeColor) {
                    textColor = renderer.colorCaptionRollover;
                    break;
                }
                textColor = renderer.parent.getForeground();
                break;
            }
            case 4: {
                Color bColorTop = ButtonRenderer.ShiftColor(renderer.colorPressed, -0.1f);
                BColor1 = ButtonRenderer.ShiftColor(renderer.colorPressed, -0.15f);
                GColor2 = BColor2 = bColorTop;
                BColor3 = Color.WHITE;
                BkCol = ButtonRenderer.ShiftColor(renderer.colorPressed, -0.1f);
                if (!renderer.useThemeColor) {
                    textColor = renderer.colorCaptionPressed;
                    break;
                }
                textColor = renderer.parent.getForeground();
                break;
            }
            default: {
                Color bColorTop = ButtonRenderer.ShiftColor(renderer.colorNormal, 0.1f);
                BColor1 = renderer.colorNormal;
                BColor2 = ButtonRenderer.ShiftColor(renderer.colorNormal, 0.1f);
                GColor2 = ButtonRenderer.ShiftColor(renderer.colorNormal, 0.05f);
                BColor3 = Color.WHITE;
                BkCol = ButtonRenderer.ShiftColor(renderer.colorNormal, -0.1f);
                textColor = !renderer.useThemeColor ? renderer.colorCaptionNormal : renderer.parent.getForeground();
            }
        }
        int BorderWidth = 2;
        int GradWd = EllipseWd = 15;
        int GradHt = 7;
        Rect ButtonRect = new Rect(renderer.x1 + 1, renderer.y1 + 1, renderer.x2 - BorderWidth, renderer.y2 - BorderWidth);
        g2d.setClip(new RoundRectangle2D.Double(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height, EllipseWd, EllipseWd));
        Rect GlareRect = new Rect(5, ButtonRect.top, ButtonRect.width - 8, (int)((double)(ButtonRect.Bottom - ButtonRect.top) / 1.75));
        if (GlareRect.Bottom - GlareRect.top > 20) {
            GlareRect.Bottom = GlareRect.top + 20;
        }
        Point pt1 = new Point(ButtonRect.left, GlareRect.Bottom - EllipseWd / 4);
        Point pt2 = new Point(ButtonRect.right, pt1.Y);
        Point pt3 = new Point(ButtonRect.left + GradWd / 2, pt1.Y + 7);
        Point pt4 = new Point(ButtonRect.right - GradWd / 2, pt3.Y);
        Point pt5 = new Point(pt3.X, ButtonRect.Bottom - GradHt);
        Point pt6 = new Point(pt4.X, pt5.Y);
        Rect RctMd = new Rect(pt3, pt6);
        Polygon polyTop = new Polygon();
        polyTop.addPoint(pt1.X, pt1.Y);
        polyTop.addPoint(pt2.X, pt2.Y);
        polyTop.addPoint(pt4.X, pt4.Y);
        polyTop.addPoint(pt3.X, pt3.Y);
        Polygon polyLt = new Polygon();
        polyLt.addPoint(pt1.X, pt1.Y);
        polyLt.addPoint(pt3.X, pt3.Y);
        polyLt.addPoint(pt5.X, pt5.Y);
        polyLt.addPoint(ButtonRect.left, ButtonRect.Bottom);
        Polygon polyRt = new Polygon();
        polyRt.addPoint(pt2.X, pt2.Y);
        polyRt.addPoint(pt4.X, pt4.Y);
        polyRt.addPoint(pt6.X, pt6.Y);
        polyRt.addPoint(ButtonRect.right, ButtonRect.Bottom);
        Polygon polyBt = new Polygon();
        polyBt.addPoint(ButtonRect.left, ButtonRect.Bottom);
        polyBt.addPoint(pt5.X, pt5.Y);
        polyBt.addPoint(pt6.X, pt6.Y);
        polyBt.addPoint(ButtonRect.right, ButtonRect.Bottom);
        Polygon polyMd = new Polygon();
        polyMd.addPoint(pt3.X, pt3.Y);
        polyMd.addPoint(pt4.X, pt4.Y);
        polyMd.addPoint(pt6.X, pt6.Y);
        polyMd.addPoint(pt5.X, pt5.Y);
        GradientPaint Glare = renderer.mMouseState == 4 ? new GradientPaint(0.0f, GlareRect.top, new Color(250, 250, 250), 0.0f, GlareRect.Bottom, BColor1, false) : new GradientPaint(0.0f, GlareRect.top, Color.WHITE, 0.0f, GlareRect.Bottom, GColor2, false);
        g2d.setPaint(BColor1);
        g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height);
        g2d.setPaint(Glare);
        g2d.fillRoundRect(GlareRect.left, GlareRect.top, GlareRect.right, GlareRect.Bottom, EllipseWd, EllipseWd);
        g2d.setColor(BColor2);
        g2d.fillRect(RctMd.left, RctMd.top, RctMd.width, RctMd.height);
        ButtonRenderer.paintGradient(g2d, BColor1, BColor2, polyTop, GradientDirection.vertical);
        ButtonRenderer.paintGradient(g2d, BColor1, BColor2, polyLt, GradientDirection.horizontal);
        ButtonRenderer.paintGradient(g2d, BColor2, BColor1, polyRt, GradientDirection.horizontal);
        ButtonRenderer.paintGradient(g2d, BColor2, BColor3, polyBt, GradientDirection.vertical);
        g2d.setColor(BColor1);
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
        g2d.setClip(null);
        g2d.setColor(renderer.parent.hasFocus() && renderer.focusPainted ? BkCol.darker() : BkCol);
        g2d.setStroke(new BasicStroke(BorderWidth));
        g2d.drawRoundRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.height - 1, EllipseWd, EllipseWd);
        g2d.setStroke(new BasicStroke(1.0f));
    }

    private static void paintSoft(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Rect ButtonRect = new Rect(renderer.x1, renderer.y1, renderer.x2 - 1, renderer.y2 - 1);
        if (renderer.mMouseState == 8) {
            g2d.setColor(renderer.parent.getBackground());
            g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height);
            textColor = Color.GRAY;
        } else {
            Color Color1;
            Color Color2;
            int L2 = ButtonRect.left + 1;
            int T2 = ButtonRect.top;
            switch (renderer.mMouseState) {
                case 4: {
                    if (!renderer.useThemeColor) {
                        g2d.setColor(renderer.colorPressed);
                        textColor = renderer.colorCaptionPressed;
                    } else {
                        g2d.setColor(renderer.parent.getBackground());
                        textColor = renderer.parent.getForeground();
                    }
                    g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height);
                    Color2 = Color.WHITE;
                    Color1 = new Color(160, 160, 160);
                    break;
                }
                case 1: {
                    if (!renderer.useThemeColor) {
                        g2d.setColor(renderer.colorRolover);
                        textColor = renderer.colorCaptionRollover;
                    } else {
                        g2d.setColor(renderer.parent.getBackground());
                        textColor = renderer.parent.getForeground();
                    }
                    Color1 = Color.WHITE;
                    Color2 = new Color(160, 160, 160);
                    break;
                }
                default: {
                    if (!renderer.useThemeColor) {
                        g2d.setColor(renderer.colorNormal);
                        textColor = renderer.colorCaptionNormal;
                    } else {
                        g2d.setColor(renderer.parent.getBackground());
                        textColor = renderer.parent.getForeground();
                    }
                    Color1 = Color.WHITE;
                    Color2 = new Color(160, 160, 160);
                }
            }
            g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height);
            g2d.setColor(Color1);
            g2d.drawLine(ButtonRect.left, ButtonRect.top, ButtonRect.right, ButtonRect.top);
            g2d.drawLine(ButtonRect.left, ButtonRect.top, ButtonRect.left, ButtonRect.Bottom);
            g2d.setColor(Color2);
            g2d.drawLine(ButtonRect.right, T2 - 1, ButtonRect.right, ButtonRect.Bottom);
            g2d.drawLine(L2, ButtonRect.Bottom, ButtonRect.right, ButtonRect.Bottom);
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
    }

    private static void paintFlat(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Rect ButtonRect = new Rect(renderer.x1, renderer.y1, renderer.x2, renderer.y2);
        Color Color1 = Color.WHITE;
        Color Color2 = new Color(160, 160, 160);
        switch (renderer.mMouseState) {
            case 8: {
                g2d.setColor(renderer.parent.getBackground());
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                textColor = Color.GRAY;
                break;
            }
            case 4: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorNormal);
                    textColor = renderer.colorCaptionPressed;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(Color2);
                g2d.drawLine(ButtonRect.left, ButtonRect.top, ButtonRect.right, ButtonRect.top);
                g2d.drawLine(ButtonRect.left, ButtonRect.top, ButtonRect.left, ButtonRect.Bottom);
                g2d.setColor(Color1);
                g2d.drawLine(ButtonRect.right - 1, ButtonRect.top, ButtonRect.right - 1, ButtonRect.Bottom);
                g2d.drawLine(ButtonRect.left, ButtonRect.Bottom - 1, ButtonRect.right, ButtonRect.Bottom - 1);
                break;
            }
            case 1: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorRolover);
                    textColor = renderer.colorCaptionRollover;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(Color1);
                g2d.drawLine(ButtonRect.left, ButtonRect.top, ButtonRect.right, ButtonRect.top);
                g2d.drawLine(ButtonRect.left, ButtonRect.top, ButtonRect.left, ButtonRect.Bottom);
                g2d.setColor(Color2);
                g2d.drawLine(ButtonRect.right - 1, ButtonRect.top, ButtonRect.right - 1, ButtonRect.Bottom);
                g2d.drawLine(ButtonRect.left, ButtonRect.Bottom - 1, ButtonRect.right, ButtonRect.Bottom - 1);
                break;
            }
            default: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorNormal);
                    textColor = renderer.colorCaptionNormal;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
            }
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
    }

    private static void paintPlain(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Rect ButtonRect = new Rect(renderer.x1, renderer.y1, renderer.x2, renderer.y2);
        Color Color1 = Color.WHITE;
        Color Color2 = new Color(160, 160, 160);
        switch (renderer.mMouseState) {
            case 8: {
                g2d.setColor(renderer.parent.getBackground());
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                textColor = Color.GRAY;
                break;
            }
            case 4: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorNormal);
                    textColor = renderer.colorCaptionPressed;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                break;
            }
            case 1: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorRolover);
                    textColor = renderer.colorCaptionRollover;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                break;
            }
            default: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorNormal);
                    textColor = renderer.colorCaptionNormal;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
            }
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
    }

    private static void paintOfficeXP(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Rect ButtonRect = new Rect(renderer.x1, renderer.y1, renderer.x2 - 1, renderer.y2 - 1);
        switch (renderer.mMouseState) {
            case 8: {
                g2d.setColor(renderer.parent.getBackground());
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                textColor = Color.GRAY;
                break;
            }
            case 4: {
                g2d.setColor(new Color(128, 187, 235));
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(new Color(0, 120, 215));
                g2d.drawRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.Bottom - 1);
                textColor = Color.black;
                break;
            }
            case 1: {
                g2d.setColor(new Color(176, 213, 242));
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(new Color(0, 120, 215));
                g2d.drawRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.Bottom - 1);
                textColor = Color.black;
                break;
            }
            default: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorNormal);
                    textColor = renderer.colorCaptionNormal;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
            }
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
    }

    private static void paintOfficeXPColored(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Rect ButtonRect = new Rect(renderer.x1, renderer.y1, renderer.x2 - 1, renderer.y2 - 1);
        switch (renderer.mMouseState) {
            case 8: {
                g2d.setColor(renderer.parent.getBackground());
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                textColor = Color.GRAY;
                break;
            }
            case 4: {
                g2d.setColor(renderer.colorPressed);
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(renderer.borderColor);
                g2d.drawRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.Bottom - 1);
                textColor = Color.black;
                break;
            }
            case 1: {
                g2d.setColor(renderer.colorRolover);
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(renderer.borderColorHot);
                g2d.drawRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.Bottom - 1);
                textColor = Color.black;
                break;
            }
            default: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorNormal);
                    textColor = renderer.colorCaptionNormal;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
            }
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
    }

    private static void paintWindows(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Rect ButtonRect = new Rect(renderer.x1, renderer.y1, renderer.x2 - 1, renderer.y2 - 1);
        switch (renderer.mMouseState) {
            case 8: {
                g2d.setColor(renderer.parent.getBackground());
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                textColor = Color.GRAY;
                break;
            }
            case 4: {
                g2d.setColor(new Color(200, 224, 243));
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(new Color(0, 120, 215));
                g2d.drawRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.Bottom - 1);
                textColor = renderer.parent.getForeground();
                break;
            }
            case 1: {
                g2d.setColor(new Color(229, 241, 251));
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
                g2d.setColor(new Color(0, 120, 215));
                g2d.drawRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.Bottom - 1);
                textColor = renderer.parent.getForeground();
                break;
            }
            default: {
                if (!renderer.useThemeColor) {
                    g2d.setColor(renderer.colorNormal);
                    textColor = renderer.colorCaptionNormal;
                } else {
                    g2d.setColor(renderer.parent.getBackground());
                    textColor = renderer.parent.getForeground();
                }
                g2d.fillRect(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.Bottom);
            }
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
    }

    private static void paintGalaxy(ButtonRenderer renderer, Graphics2D g2d) {
        Color textColor;
        Rect ButtonRect = new Rect(renderer.x1 + 1, renderer.y1 + 1, renderer.x2 - 1, renderer.y2 - 1);
        boolean BorderWidth = true;
        int EllipseWd = 8;
        g2d.setClip(new RoundRectangle2D.Double(ButtonRect.left, ButtonRect.top, ButtonRect.width, ButtonRect.height, EllipseWd, EllipseWd));
        switch (renderer.mMouseState) {
            case 8: {
                ButtonRenderer.paintGradient(g2d, Color.WHITE, new Color(240, 240, 240), ButtonRect, GradientDirection.vertical);
                textColor = Color.GRAY;
                break;
            }
            case 1: {
                ButtonRenderer.paintGradient(g2d, Color.WHITE, new Color(240, 240, 240), ButtonRect, GradientDirection.vertical);
                if (!renderer.useThemeColor) {
                    textColor = renderer.colorCaptionRollover;
                    break;
                }
                textColor = renderer.parent.getForeground();
                break;
            }
            case 4: {
                ButtonRenderer.paintGradient(g2d, new Color(240, 240, 240), Color.WHITE, ButtonRect, GradientDirection.vertical);
                if (!renderer.useThemeColor) {
                    textColor = renderer.colorCaptionPressed;
                    break;
                }
                textColor = renderer.parent.getForeground();
                break;
            }
            default: {
                ButtonRenderer.paintGradient(g2d, Color.WHITE, new Color(225, 225, 225), ButtonRect, GradientDirection.vertical);
                textColor = !renderer.useThemeColor ? renderer.colorCaptionNormal : renderer.parent.getForeground();
            }
        }
        ButtonRenderer.paintCaptionAndIcon(renderer, g2d, textColor);
        g2d.setClip(null);
        g2d.setColor(renderer.parent.hasFocus() && renderer.focusPainted ? new Color(192, 192, 192).darker() : new Color(192, 192, 192));
        g2d.setStroke(new BasicStroke((float)BorderWidth));
        g2d.drawRoundRect(ButtonRect.left, ButtonRect.top, ButtonRect.width - 1, ButtonRect.height - 1, EllipseWd, EllipseWd);
    }

    private static void paintGradient(Graphics2D g2d, Color StartColor, Color EndColor, Rect drawArea, GradientDirection gradientDirection) {
        GradientPaint drawGradient = gradientDirection.equals((Object)GradientDirection.horizontal) ? new GradientPaint(drawArea.left, drawArea.top, StartColor, drawArea.right, drawArea.top, EndColor, false) : new GradientPaint(drawArea.left, drawArea.top, StartColor, drawArea.left, drawArea.Bottom, EndColor, false);
        g2d.setPaint(drawGradient);
        g2d.fillRect(drawArea.left, drawArea.top, drawArea.width, drawArea.height);
    }

    private static void paintGradient(Graphics2D g2d, Color StartColor, Color EndColor, Rect GradientArea, Polygon drawArea, GradientDirection gradientDirection) {
        GradientPaint drawGradient = gradientDirection.equals((Object)GradientDirection.horizontal) ? new GradientPaint(GradientArea.left, GradientArea.top, StartColor, GradientArea.right, GradientArea.top, EndColor, false) : new GradientPaint(GradientArea.left, GradientArea.top, StartColor, GradientArea.left, GradientArea.Bottom, EndColor, false);
        g2d.setPaint(drawGradient);
        g2d.fillPolygon(drawArea);
    }

    private static void paintGradient(Graphics2D g2d, Color StartColor, Color EndColor, Polygon drawArea, GradientDirection gradientDirection) {
        Rectangle GradientArea = drawArea.getBounds();
        GradientPaint drawGradient = gradientDirection.equals((Object)GradientDirection.horizontal) ? new GradientPaint(GradientArea.x, GradientArea.y, StartColor, GradientArea.width + GradientArea.x, GradientArea.y, EndColor, false) : new GradientPaint(GradientArea.x, GradientArea.y, StartColor, GradientArea.x, GradientArea.height + GradientArea.y, EndColor, false);
        g2d.setPaint(drawGradient);
        g2d.fillPolygon(drawArea);
    }

    public String getText() {
        if (this.caption == null) {
            return "";
        }
        return this.caption;
    }

    public void setText(String text) {
        this.caption = text;
    }

    private static void paintCaptionAndIcon(ButtonRenderer renderer, Graphics2D g2d, Color textColor) {
        int CaptionY;
        int IconY;
        int CaptionX;
        int IconX;
        boolean noText;
        boolean noIcon = !renderer.icon.hasIcon(renderer.mMouseState);
        boolean bl = noText = renderer.caption.length() == 0;
        if (noText && noIcon) {
            return;
        }
        if (noText) {
            ButtonRenderer.paintIcon(renderer, g2d);
            return;
        }
        if (noIcon) {
            ButtonRenderer.paintCaption(renderer, g2d, textColor);
            return;
        }
        if (!renderer.captionAlign.mAlignment.equals((Object)renderer.iconAlign.mAlignment)) {
            ButtonRenderer.paintCaption(renderer, g2d, textColor);
            ButtonRenderer.paintIcon(renderer, g2d);
            return;
        }
        g2d.setFont(renderer.parent.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        int cWd = fm.stringWidth(renderer.caption);
        int cHt = fm.getAscent();
        int iWd = renderer.icon.getIconWidth();
        int iHt = renderer.icon.getIconHeight();
        int HtMax = Math.max(cHt, iHt);
        int tWd = cWd + iWd + renderer.iconMargins.right;
        int tHt = cHt + iHt + renderer.iconMargins.top;
        Dimension d = renderer.parent.getSize();
        if (renderer.captionAlign.mAlignment.equals((Object)Alignment.Center)) {
            IconX = (d.width - iWd) / 2;
            CaptionX = renderer.deltaX + (d.width - cWd) / 2;
            IconY = (d.height - tHt) / 2;
            CaptionY = renderer.deltaY + IconY + iHt + cHt + renderer.iconMargins.bottom;
        } else {
            switch (renderer.captionAlign.h_Align) {
                case left: {
                    IconX = renderer.buttonMargins.left;
                    CaptionX = renderer.deltaX + IconX + iWd + renderer.iconMargins.right;
                    break;
                }
                case right: {
                    IconX = renderer.lW - renderer.buttonMargins.left - iWd;
                    CaptionX = renderer.deltaX + IconX - renderer.buttonMargins.left - cWd;
                    break;
                }
                default: {
                    IconX = (d.width - tWd) / 2;
                    CaptionX = renderer.deltaX + IconX + renderer.iconMargins.right;
                }
            }
            switch (renderer.captionAlign.v_Align) {
                case top: {
                    IconY = renderer.buttonMargins.top + (HtMax - iHt) / 2;
                    CaptionY = renderer.deltaY + renderer.iconMargins.bottom + cHt + (HtMax - cHt) / 2;
                    break;
                }
                case bottom: {
                    IconY = renderer.lH - renderer.buttonMargins.bottom - iHt + (HtMax - iHt) / 2;
                    CaptionY = renderer.deltaY + (renderer.lH - renderer.buttonMargins.bottom) - (HtMax - cHt) / 2;
                    break;
                }
                default: {
                    IconY = (d.height - iHt) / 2 + (HtMax - iHt) / 2;
                    CaptionY = renderer.deltaY + (d.height + iHt) / 2 - (HtMax - cHt) / 2;
                }
            }
        }
        g2d.setColor(textColor);
        if (renderer.shiftOnPress && renderer.mMouseState == 4) {
            ++CaptionX;
            ++CaptionY;
            ++IconX;
            ++IconY;
        }
        g2d.drawString(renderer.caption, CaptionX, CaptionY);
        renderer.icon.paintIcon(renderer.parent, g2d, IconX, IconY);
    }

    private static void paintCaption(ButtonRenderer renderer, Graphics2D g2d, Color textColor) {
        int CaptionY;
        int CaptionX;
        g2d.setFont(renderer.parent.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        int Wd = fm.stringWidth(renderer.caption);
        int Ht = fm.getMaxAscent() - fm.getMaxDescent();
        switch (renderer.captionAlign.h_Align) {
            case left: {
                CaptionX = renderer.deltaX + renderer.buttonMargins.left;
                break;
            }
            case right: {
                CaptionX = renderer.deltaX + (renderer.lW - renderer.buttonMargins.left - Wd);
                break;
            }
            default: {
                CaptionX = renderer.deltaX + (renderer.lW - Wd) / 2;
            }
        }
        switch (renderer.captionAlign.v_Align) {
            case top: {
                CaptionY = renderer.deltaY + renderer.buttonMargins.top + Ht;
                break;
            }
            case bottom: {
                CaptionY = renderer.deltaY + (renderer.lH - renderer.buttonMargins.bottom);
                break;
            }
            default: {
                CaptionY = renderer.deltaY + (renderer.lH + Ht) / 2;
            }
        }
        g2d.setColor(textColor);
        if (renderer.shiftOnPress && renderer.mMouseState == 4) {
            ++CaptionX;
            ++CaptionY;
        }
        g2d.drawString(renderer.caption, CaptionX, CaptionY);
    }

    private static void paintIcon(ButtonRenderer renderer, Graphics2D g2d) {
        int iconY;
        int iconX;
        if (!renderer.icon.hasIcon(renderer.mMouseState)) {
            return;
        }
        int wd = renderer.icon.getIconWidth();
        int ht = renderer.icon.getIconHeight();
        Dimension d = renderer.parent.getSize();
        switch (renderer.iconAlign.h_Align) {
            case left: {
                iconX = renderer.buttonMargins.left;
                break;
            }
            case right: {
                iconX = renderer.lW - renderer.buttonMargins.left - wd;
                break;
            }
            default: {
                iconX = (d.width - wd) / 2;
            }
        }
        switch (renderer.iconAlign.v_Align) {
            case top: {
                iconY = renderer.buttonMargins.top;
                break;
            }
            case bottom: {
                iconY = renderer.lH - renderer.buttonMargins.bottom - ht;
                break;
            }
            default: {
                iconY = (d.height - ht) / 2;
            }
        }
        if (renderer.shiftOnPress && renderer.mMouseState == 4) {
            ++iconX;
            ++iconY;
        }
        renderer.icon.paintIcon(renderer.parent, g2d, iconX, iconY);
    }

    protected void paintBorder(Graphics g) {
    }

    private static Color ShiftColor(Color color, float shift) {
        int R = (int)((float)color.getRed() + shift * 255.0f);
        int G = (int)((float)color.getGreen() + shift * 255.0f);
        int B = (int)((float)color.getBlue() + shift * 255.0f);
        if (shift > 0.0f) {
            if (R > 255) {
                R = 255;
            }
            if (G > 255) {
                G = 255;
            }
            if (B > 255) {
                B = 255;
            }
        } else {
            if (R < 0) {
                R = 0;
            }
            if (G < 0) {
                G = 0;
            }
            if (B < 0) {
                B = 0;
            }
        }
        return new Color(R, G, B);
    }

    public ButtonRenderer(JComponent c) {
        this.parent = c;
    }

    public static enum eButtonType {
        CommandButton,
        CheckButton;

    }

    public static enum ButtonStyle {
        Flat,
        Galaxy,
        GelButton,
        GlossyButton,
        GradientButton,
        OfficeXP,
        OfficeXPColored,
        Plain,
        ShineyButton,
        ShineyButtonColored,
        Soft,
        VistaAero,
        VistaAeroColored,
        WindowsXP;

    }

    private class Alignments {
        private Alignment mAlignment = Alignment.Center;
        private vAlign v_Align = vAlign.center;
        private hAlign h_Align = hAlign.center;

        public vAlign V() {
            return this.v_Align;
        }

        public hAlign H() {
            return this.h_Align;
        }

        public Alignments() {
        }

        public Alignments(Alignment alignment) {
            this.setAlignment(alignment);
        }

        public Alignment alignment() {
            return this.mAlignment;
        }

        public void setAlignment(Alignment alignment) {
            this.mAlignment = alignment;
            switch (this.mAlignment) {
                case LeftCenter: {
                    this.h_Align = hAlign.left;
                    this.v_Align = vAlign.center;
                    break;
                }
                case LeftTop: {
                    this.h_Align = hAlign.left;
                    this.v_Align = vAlign.top;
                    break;
                }
                case LeftBottom: {
                    this.h_Align = hAlign.left;
                    this.v_Align = vAlign.bottom;
                    break;
                }
                case RightCenter: {
                    this.h_Align = hAlign.right;
                    this.v_Align = vAlign.center;
                    break;
                }
                case RightTop: {
                    this.h_Align = hAlign.right;
                    this.v_Align = vAlign.top;
                    break;
                }
                case RightBottom: {
                    this.h_Align = hAlign.right;
                    this.v_Align = vAlign.bottom;
                    break;
                }
                case CenterTop: {
                    this.h_Align = hAlign.center;
                    this.v_Align = vAlign.top;
                    break;
                }
                case CenterBottom: {
                    this.h_Align = hAlign.center;
                    this.v_Align = vAlign.bottom;
                    break;
                }
                default: {
                    this.h_Align = hAlign.center;
                    this.v_Align = vAlign.center;
                }
            }
        }
    }

    public static enum Alignment {
        Center,
        LeftCenter,
        RightCenter,
        CenterTop,
        CenterBottom,
        LeftTop,
        RightTop,
        LeftBottom,
        RightBottom;

    }

    private static class Rect {
        int top = 0;
        int Bottom = 0;
        int left = 0;
        int right = 0;
        int width = 0;
        int height = 0;
        int MidX = 0;
        int MidY = 0;

        public Rect() {
        }

        public Rect(int x1, int y1, int x2, int y2) {
            this.top = y1;
            this.Bottom = y2;
            this.left = x1;
            this.right = x2;
            this.calcWH();
        }

        public Rect(Point TL, Point BR) {
            this.top = TL.Y;
            this.Bottom = BR.Y;
            this.left = TL.X;
            this.right = BR.X;
            this.calcWH();
        }

        public void setRect(int x1, int y1, int x2, int y2) {
            this.top = y1;
            this.Bottom = y2;
            this.left = x1;
            this.right = x2;
            this.calcWH();
        }

        public void setRect(Rect srcRect) {
            this.top = srcRect.top;
            this.Bottom = srcRect.Bottom;
            this.left = srcRect.left;
            this.right = srcRect.right;
            this.calcWH();
        }

        public void Adjust(int dLeft, int dTop, int dRight, int dBottom) {
            this.top += dTop;
            this.Bottom += dBottom;
            this.left += dLeft;
            this.right += dRight;
            this.calcWH();
        }

        public int getHeight() {
            this.height = this.Bottom - this.top + 1;
            return this.height;
        }

        public int getWidth() {
            this.width = this.right - this.left + 1;
            return this.width;
        }

        private void calcWH() {
            this.width = this.right - this.left + 1;
            this.height = this.Bottom - this.top + 1;
            this.MidX = this.width / 2;
            this.MidY = this.height / 2;
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.left, this.top, this.width, this.height);
        }
    }

    private static enum GradientDirection {
        horizontal,
        vertical;

    }

    private static class Point {
        int X = 0;
        int Y = 0;

        public Point() {
        }

        public Point(int X, int Y) {
            this.X = X;
            this.Y = Y;
        }
    }

    private class margin {
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;

        public margin() {
        }

        public margin(int top, int bottom, int left, int right) {
            this.top = top;
            this.bottom = bottom;
            this.left = left;
            this.right = right;
        }

        public void setMargins(int top, int bottom, int left, int right) {
            this.top = top;
            this.bottom = bottom;
            this.left = left;
            this.right = right;
        }
    }

    private static enum hAlign {
        left,
        center,
        right;

    }

    private static enum vAlign {
        top,
        center,
        bottom;

    }

    public static enum DrawType {
        dStandard,
        dHorizontalGradient,
        dVerticalGradient,
        dHorizontalGradient2,
        dVerticalGradient2,
        dSolidColor;

    }
}

