/*
 * Decompiled with CFR 0.152.
 */
package Buttons;

import Buttons.Constants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

class LongPressProperties {
    int menuX = 0;
    int menuY = 0;
    int arrowWd = 8;
    int arrowHt = 8;
    int arrowMidWd = this.arrowWd / 2;
    int arrowMidHt = this.arrowHt / 2;
    int arrowSpacer = 8;
    Constants.PopupLocation menuPos = Constants.PopupLocation.BELOW_RIGHT;
    Constants.PopupLocation arrowPos = Constants.PopupLocation.BELOW_RIGHT;
    boolean showArrow = false;
    Color arrowFillColor = Color.BLACK;
    Color arrowLineColor = Color.RED;
    int menuOnButton = 1;
    JPopupMenu menu;
    int delay = 500;
    Timer timer = null;

    LongPressProperties() {
    }

    public void setArrowHeight(int value) {
        if (value > 0) {
            this.arrowHt = value;
            this.arrowMidWd = this.arrowWd / 2;
        }
    }

    public void setArrowWidth(int value) {
        if (value > 0) {
            this.arrowWd = value;
            this.arrowMidWd = this.arrowWd / 2;
        }
    }

    public void setArrowInset(int value) {
        if (value > 0) {
            this.arrowSpacer = value;
        }
    }

    public void setArrowColor(Color color) {
        if (color != null) {
            this.arrowFillColor = color;
        }
    }

    public void setArrowLineColor(Color color) {
        if (color != null) {
            this.arrowLineColor = color;
        }
    }

    public void setMenuPopUpLocation(Constants.PopupLocation pos) {
        if (pos != null) {
            this.menuPos = pos;
        }
    }

    public void setArrowLocation(Constants.PopupLocation pos) {
        if (pos != null) {
            this.arrowPos = pos;
        }
    }

    public void paint(Graphics g, int compWd, int compHt, boolean enabled) {
        Graphics2D g2d = (Graphics2D)g;
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        switch (this.arrowPos) {
            case ABOVE_LEFT: {
                y1 = this.arrowSpacer;
                y3 = y2 = y1 + this.arrowHt;
                x2 = this.arrowSpacer;
                x1 = x2 + this.arrowMidWd;
                x3 = x2 + this.arrowWd;
                break;
            }
            case ABOVE_RIGHT: {
                y1 = this.arrowSpacer;
                y3 = y2 = y1 + this.arrowHt;
                x2 = compWd - this.arrowSpacer;
                x1 = x2 - this.arrowMidWd;
                x3 = x2 - this.arrowWd;
                break;
            }
            case BELOW_LEFT: {
                y1 = compHt - this.arrowSpacer;
                y3 = y2 = y1 - this.arrowHt;
                x2 = this.arrowSpacer;
                x1 = x2 + this.arrowMidWd;
                x3 = x2 + this.arrowWd;
                break;
            }
            case BELOW_RIGHT: {
                y1 = compHt - this.arrowSpacer;
                y3 = y2 = y1 - this.arrowHt;
                x2 = compWd - this.arrowSpacer;
                x1 = x2 - this.arrowMidWd;
                x3 = x2 - this.arrowWd;
                break;
            }
            case LEFT_TOP: {
                y2 = this.arrowSpacer;
                y3 = y2 + this.arrowHt;
                y1 = y2 + this.arrowMidWd;
                x1 = this.arrowSpacer;
                x3 = x2 = x1 + this.arrowWd;
                break;
            }
            case RIGHT_TOP: {
                y2 = this.arrowSpacer;
                y3 = y2 + this.arrowHt;
                y1 = y2 + this.arrowMidHt;
                x1 = compWd - this.arrowSpacer;
                x3 = x2 = x1 - this.arrowWd;
                break;
            }
            case LEFT_BOTTOM: {
                y2 = compHt - this.arrowSpacer;
                y3 = y2 - this.arrowHt;
                y1 = y2 - this.arrowMidHt;
                x1 = this.arrowSpacer;
                x3 = x2 = x1 + this.arrowWd;
                break;
            }
            case RIGHT_BOTTOM: {
                y2 = compHt - this.arrowSpacer;
                y3 = y2 - this.arrowHt;
                y1 = y2 - this.arrowMidHt;
                x1 = compWd - this.arrowSpacer;
                x3 = x2 = x1 - this.arrowWd;
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        Polygon s = new Polygon(new int[]{x1, x2, x3, x1}, new int[]{y1, y2, y3, y1}, 4);
        g2d.setColor(enabled ? this.arrowFillColor : Color.LIGHT_GRAY);
        g2d.fill(s);
        g2d.setColor(enabled ? this.arrowLineColor : Color.LIGHT_GRAY);
        g2d.draw(s);
    }

    public void startTimer(Component c) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.menu == null) {
            return;
        }
        switch (this.menuPos) {
            case ABOVE_LEFT: 
            case BELOW_LEFT: {
                this.menuX = 0;
                break;
            }
            case LEFT_TOP: 
            case LEFT_BOTTOM: {
                this.menuX = -this.menu.getPreferredSize().width;
                break;
            }
            case ABOVE_RIGHT: 
            case BELOW_RIGHT: {
                this.menuX = c.getWidth() - this.menu.getPreferredSize().width;
                break;
            }
            case RIGHT_TOP: 
            case RIGHT_BOTTOM: {
                this.menuX = c.getWidth();
            }
        }
        switch (this.menuPos) {
            case ABOVE_LEFT: 
            case ABOVE_RIGHT: {
                this.menuY = -this.menu.getPreferredSize().height;
                break;
            }
            case BELOW_LEFT: 
            case BELOW_RIGHT: {
                this.menuY = c.getHeight();
                break;
            }
            case LEFT_TOP: 
            case RIGHT_TOP: {
                this.menuY = 0;
                break;
            }
            case LEFT_BOTTOM: 
            case RIGHT_BOTTOM: {
                this.menuY = c.getHeight() - this.menu.getPreferredSize().height;
            }
        }
        if (this.delay > 0) {
            this.timer = new Timer(this.delay, e -> {
                this.timer.stop();
                this.timer = null;
                this.menu.show(c, this.menuX, this.menuY);
            });
            this.timer.start();
        } else {
            this.menu.show(c, this.menuX, this.menuY);
        }
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    JPopupMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
        }
        return this.menu;
    }
}

