/*
 * Decompiled with CFR 0.152.
 */
package CloneManagerFileReader;

import CloneManagerFileReader.TOCFeature;
import CloneManagerFileReader.TOCPrimer;
import GenbankFileReader.GenBankFile;
import GenbankFileReader.Qualifier;
import SequenceEditorPanels.ExtensibleArray;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.Random;

public class CloneManagerReader {
    static final int p_Sequence = 2049;
    static final int p_AnnealInfo = 2053;
    static final int p_Direction = 2309;
    static final int t_Name = 3072;
    static final int t_Comment = 3073;
    static final int t_TOC_BLOCK_END = 4;
    static final int t_TOC_End = 65535;
    static final int t_Primer = 1029;
    static final int t_Feature = 1032;
    static final int t_Sequence = 2048;
    static final int t_RE_Table = 2056;
    static final int f_Graphic = -2816;
    static final int f_Start = 2305;
    static final int f_Stop = 2306;
    static final int f_orient = 2307;
    static final int t_LinearCirc = 2304;
    static final int f_GBType = 2048;
    static final int f_Qualifiers = 2049;
    static final int f_Type = 2304;
    static final int f_Style = 2320;
    static final int LOADED_TYPE_LINE = 0;
    static final int LOADED_TYPE_BOX = 1;
    static final int LOADED_TYPE_ARROW = 2;
    static final int LOADED_TYPE_TICKMARK = 3;
    static final int LOADED_TYPE_BRACKET = 4;
    static final int LOADED_TYPE_NONE = 5;
    static final int LOADED_TYPE_HARROW = 6;
    static final int LOADED_TYPE_LARROW = 7;
    private static int cIndex = 0;
    private static byte[] fileData;
    private static String lastError;
    private static final char[] header;

    private static boolean isHeaderValid(byte[] fileData) {
        if (fileData == null || fileData.length < header.length) {
            return false;
        }
        for (int index = 0; index < header.length; ++index) {
            if (header[index] == fileData[index]) continue;
            lastError = "Error opening file.  File is not a supported SnapGene file.";
            return false;
        }
        return true;
    }

    private static int byteToInt2(byte ... value) {
        if (value != null) {
            switch (value.length) {
                case 1: {
                    return ByteBuffer.wrap(new byte[]{0, 0, 0, value[0]}).getInt();
                }
                case 2: {
                    return ByteBuffer.wrap(new byte[]{0, 0, value[1], value[0]}).getInt();
                }
                case 3: {
                    return ByteBuffer.wrap(new byte[]{0, value[0], value[2], value[1]}).getInt();
                }
                case 4: {
                    return ByteBuffer.wrap(new byte[]{value[1], value[0], value[3], value[2]}).getInt();
                }
            }
        }
        throw new IllegalArgumentException("You cannot create an int with more than 4 bytes.");
    }

    public static char[] getFileChars(File file) {
        lastError = "";
        if (!file.isFile()) {
            lastError = "Specified path is not a file.";
            return null;
        }
        if (!file.exists()) {
            lastError = "Specified file does not exist.";
            return null;
        }
        if (!file.canRead()) {
            lastError = "Specified file does not have read access.";
            return null;
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            char[] chars = new char[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                chars[i] = (char)(bytes[i] & 0xFF);
            }
            return chars;
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
    }

    static short bytesToShort(byte byte1, byte byte2) {
        int b0 = 0xFF & byte1;
        int b1 = 0xFF & byte2;
        return (short)(b1 << 8 | b0);
    }

    public static GenBankFile loadCM5File(File file) {
        fileData = null;
        try {
            fileData = Files.readAllBytes(Paths.get(file.getCanonicalPath(), new String[0]));
        }
        catch (IOException ex) {
            lastError = ex instanceof NoSuchFileException ? "File could not be found." : ex.getLocalizedMessage();
            return null;
        }
        if (fileData == null) {
            return null;
        }
        if (!CloneManagerReader.isHeaderValid(fileData)) {
            lastError = "Error opening file.  File is not a supported SnapGene file.";
            return null;
        }
        GenBankFile outFile = new GenBankFile();
        ExtensibleArray<Qualifier> headerQuals = new ExtensibleArray<Qualifier>(Qualifier.class);
        int ToC_Count = CloneManagerReader.byteToInt2(fileData[10], fileData[11]);
        int ToCSize = ToC_Count * 8;
        int dataOffset = 12 + ToCSize;
        cIndex = 12;
        String[] reStrings = null;
        String charNull = String.valueOf('\u0000');
        for (int tocIndex = 0; tocIndex < ToC_Count; ++tocIndex) {
            int entryType = CloneManagerReader.byteToInt2(fileData[cIndex], fileData[cIndex + 1]);
            int entryLen = CloneManagerReader.byteToInt2(fileData[cIndex + 2], fileData[cIndex + 3], fileData[cIndex + 4], fileData[cIndex + 5]);
            switch (entryType) {
                case 2048: {
                    outFile.sequence = CloneManagerReader.extractString(fileData, dataOffset, entryLen);
                    break;
                }
                case 3072: {
                    outFile.header.name = CloneManagerReader.extractString(fileData, dataOffset, entryLen - 1);
                    break;
                }
                case 2056: {
                    int reNamesLen = CloneManagerReader.byteToInt2(fileData[dataOffset + 2], fileData[dataOffset + 3]);
                    String reString = CloneManagerReader.extractString(fileData, dataOffset + 4, reNamesLen);
                    reStrings = reString.split(charNull);
                    break;
                }
                case 3073: {
                    outFile.header.notes = CloneManagerReader.extractString(fileData, dataOffset, entryLen);
                    break;
                }
                case 2304: {
                    String topString = CloneManagerReader.extractString(fileData, dataOffset, 1);
                    outFile.header.circular = !topString.equals("1");
                    break;
                }
                case 1029: {
                    TOCPrimer pTOC = new TOCPrimer();
                    pTOC.entryType = entryType;
                    pTOC.entryLen = entryLen;
                    pTOC.fileOffset = dataOffset;
                    pTOC.content = new byte[entryLen];
                    System.arraycopy(fileData, pTOC.fileOffset, pTOC.content, 0, entryLen);
                    outFile.features.add(pTOC.parse());
                    break;
                }
                case 1032: {
                    TOCFeature fTOC = new TOCFeature();
                    fTOC.entryType = entryType;
                    fTOC.entryLen = entryLen;
                    fTOC.fileOffset = dataOffset;
                    fTOC.content = new byte[entryLen];
                    System.arraycopy(fileData, fTOC.fileOffset, fTOC.content, 0, entryLen);
                    outFile.features.add(fTOC.parse());
                    break;
                }
            }
            cIndex += 8;
            if ((dataOffset += entryLen) == fileData.length) break;
        }
        if (reStrings != null) {
            for (int x = 0; x < reStrings.length; ++x) {
                if (reStrings[x] == null || reStrings[x].length() <= 0) continue;
                headerQuals.add(new Qualifier("ENZYME", (String)reStrings[x]));
            }
            if (headerQuals.size() > 0) {
                outFile.header.qualifiers = headerQuals.toArray();
            }
        }
        outFile.setFile(file);
        return outFile;
    }

    static String extractString(byte[] src, int offsetStart, int dataLen) {
        byte[] data = new byte[dataLen];
        for (int x = 0; x < dataLen; ++x) {
            data[x] = src[x + offsetStart];
        }
        return new String(data);
    }

    static Color CM5ToColor(int CM5Col) {
        Color color;
        switch (CM5Col) {
            case 0: {
                color = Color.black;
                break;
            }
            case 1: {
                color = Color.blue;
                break;
            }
            case 2: {
                color = Color.green;
                break;
            }
            case 3: {
                color = Color.cyan;
                break;
            }
            case 4: {
                color = Color.red;
                break;
            }
            case 5: {
                color = Color.magenta;
                break;
            }
            case 6: {
                color = new Color(0x404080);
                break;
            }
            case 7: {
                color = Color.white;
                break;
            }
            case 8: {
                color = Color.gray;
                break;
            }
            case 9: {
                color = new Color(0xFF8000);
                break;
            }
            case 10: {
                color = new Color(0x80FF80);
                break;
            }
            case 11: {
                color = new Color(0xFFFF80);
                break;
            }
            case 12: {
                color = new Color(0x8080FF);
                break;
            }
            case 13: {
                color = new Color(0xFF0080);
                break;
            }
            case 14: {
                color = Color.yellow;
                break;
            }
            case 15: {
                color = new Color(32896);
                break;
            }
            default: {
                Random rand = new Random();
                color = new Color(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
            }
        }
        return color;
    }

    static {
        lastError = "";
        header = new char[]{'\u001a', 'S', 'E', 'S', '\u0004'};
    }
}

