/*
 * Decompiled with CFR 0.152.
 */
package CloneManagerFileReader;

import CloneManagerFileReader.CloneManagerReader;
import CloneManagerFileReader.TOCEntry;
import Defaults.DefaultValues;
import Defaults.GenbankType;
import GenbankFileReader.Annotation;
import GenbankFileReader.Qualifier;
import SequenceEditorPanels.ExtensibleArray;
import java.awt.Color;

public class TOCFeature
extends TOCEntry {
    private static final int CM_GENE = 0;
    private static final int CM_MARKER = 1;
    private static final int CM_REGION = 2;
    private static final int CM_LABEL = 5;
    private static final int CM_INFO = 6;
    private int fType = 0;
    private String name = "";
    private Color backColor = null;
    private String comment = "";
    private String gbType = "";
    private int start = 0;
    private int stop = 0;
    private boolean antisense = false;
    private String qualString = "";

    private Annotation toAnnotation() {
        Annotation annotation = new Annotation();
        ExtensibleArray<Qualifier> quals = new ExtensibleArray<Qualifier>(Qualifier.class);
        switch (this.fType) {
            case 1: {
                this.stop = this.start;
            }
            case 5: 
            case 6: {
                quals.add(new Qualifier("plot_ftype", String.valueOf(3)));
                break;
            }
            case 2: {
                quals.add(new Qualifier("plot_ftype", String.valueOf(1)));
                break;
            }
            case 0: {
                quals.add(new Qualifier("plot_ftype", String.valueOf(2)));
                break;
            }
            default: {
                GenbankType defType = DefaultValues.GBTYPES.get(this.gbType);
                if (defType == null) break;
                if (this.backColor == null) {
                    this.backColor = defType.color;
                }
                quals.add(new Qualifier("plot_ftype", String.valueOf(defType.loadedGraphicIndex)));
            }
        }
        if (!this.antisense) {
            annotation.set(this.start, this.stop, this.antisense);
        } else {
            annotation.set(this.stop, this.start, this.antisense);
        }
        annotation.setGBType(this.gbType);
        if (this.name != null && this.name.length() > 0) {
            annotation.setName(this.name);
            quals.add(new Qualifier("label", this.name));
        }
        if (this.comment != null && this.comment.length() > 0) {
            if (this.name == null || this.name.length() == 0) {
                quals.add(new Qualifier("label", this.comment));
                annotation.setName(this.comment);
            }
            quals.add(new Qualifier("note", this.comment));
        }
        if (this.backColor != null) {
            quals.add(new Qualifier("plot_color", TOCFeature.colorToIntString(this.backColor)));
        }
        if (this.qualString != null && this.qualString.length() > 0) {
            String[] qualsStrings;
            for (String qualString : qualsStrings = this.qualString.split("\r\n")) {
                Qualifier q;
                if (qualString == null || qualString.length() <= 0) continue;
                if (qualString.startsWith("/")) {
                    qualString = qualString.substring(1);
                }
                if ((q = Qualifier.generate(qualString.split("="))) == null) continue;
                quals.add(q);
            }
        }
        if (!quals.isEmpty()) {
            annotation.qualifiers = quals.toArray();
        }
        return annotation;
    }

    public Annotation parse() {
        short b01 = CloneManagerReader.bytesToShort(this.content[0], this.content[1]);
        short stCount = CloneManagerReader.bytesToShort(this.content[2], this.content[3]);
        int tLen = stCount * 8;
        int cstIndex = tLen + 4;
        int stIndex = 0;
        block18: for (stIndex = 4; stIndex < tLen - 8; stIndex += 8) {
            short stType = CloneManagerReader.bytesToShort(this.content[stIndex], this.content[stIndex + 1]);
            short stLen = CloneManagerReader.bytesToShort(this.content[stIndex + 4], this.content[stIndex + 5]);
            switch (stType) {
                case 3072: {
                    this.name = CloneManagerReader.extractString(this.content, cstIndex, stLen - 1);
                    cstIndex += stLen;
                    continue block18;
                }
                case 3073: {
                    this.comment = CloneManagerReader.extractString(this.content, cstIndex, stLen - 1);
                    cstIndex += stLen;
                    continue block18;
                }
                case 2305: {
                    this.start = CloneManagerReader.bytesToShort(this.content[cstIndex], this.content[cstIndex + 1]);
                    cstIndex += stLen;
                    continue block18;
                }
                case 2306: {
                    this.stop = CloneManagerReader.bytesToShort(this.content[cstIndex], this.content[cstIndex + 1]);
                    cstIndex += stLen;
                    continue block18;
                }
                case 2307: {
                    this.antisense = this.content[cstIndex] == 1;
                    cstIndex += 4;
                    continue block18;
                }
                case 2048: {
                    this.gbType = CloneManagerReader.extractString(this.content, cstIndex, stLen - 1);
                    cstIndex += stLen;
                    continue block18;
                }
                case 2049: {
                    this.qualString = CloneManagerReader.extractString(this.content, cstIndex, stLen - 1);
                    cstIndex += stLen;
                    continue block18;
                }
                case 2308: {
                    this.backColor = CloneManagerReader.CM5ToColor(this.content[cstIndex]);
                    cstIndex += stLen;
                    continue block18;
                }
                case 2304: {
                    this.fType = this.content[cstIndex];
                    cstIndex += stLen;
                    continue block18;
                }
                case 2320: {
                    byte style = this.content[cstIndex];
                    switch (style) {
                        case 0: {
                            this.fType = 0;
                            this.backColor = Color.red;
                            break;
                        }
                        case 8: {
                            this.fType = 0;
                            this.backColor = Color.cyan;
                            break;
                        }
                        case 16: {
                            this.fType = 0;
                            this.backColor = Color.blue;
                            break;
                        }
                        default: {
                            this.fType = 0;
                            this.backColor = Color.red;
                        }
                    }
                    cstIndex += stLen;
                    continue block18;
                }
                case -2816: {
                    this.backColor = CloneManagerReader.CM5ToColor(this.content[cstIndex]);
                    cstIndex += stLen;
                    continue block18;
                }
                default: {
                    cstIndex += stLen;
                    System.out.println("unhandled feature tag " + stType);
                }
            }
        }
        return this.toAnnotation();
    }

    private static void showContents(byte[] bytes, int startOffset, int endOffset, boolean asHex) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        TOCFeature.showContents(chars, startOffset, endOffset, asHex);
    }

    private static void showContents(char[] chars, int startOffset, int endOffset, boolean asHex) {
        if (startOffset < 0) {
            startOffset = 0;
        }
        endOffset = endOffset < 0 || endOffset > chars.length ? chars.length : ++endOffset;
        int counter = 0;
        int counter2 = 0;
        for (int x = startOffset; x < endOffset; ++x) {
            char intVal = chars[x];
            if (asHex) {
                String hexVal = String.format("%02x", intVal).toUpperCase();
                System.out.print(hexVal + " ");
            } else if (intVal < '\n') {
                System.out.print("00" + intVal + " ");
            } else if (intVal < 'd') {
                System.out.print("0" + intVal + " ");
            } else {
                System.out.print(intVal + " ");
            }
            ++counter2;
            if (++counter == 4) {
                System.out.print("| ");
                counter = 0;
            }
            if (counter2 != 40) continue;
            System.out.println();
            counter2 = 0;
        }
        System.out.println();
    }

    private static String colorToIntString(Color color) {
        return String.valueOf(color.getRed() + color.getGreen() * 256 + color.getBlue() * 65536);
    }
}

