/*
 * Decompiled with CFR 0.152.
 */
package CloneManagerFileReader;

import CloneManagerFileReader.CloneManagerReader;
import CloneManagerFileReader.TOCEntry;
import GenbankFileReader.Annotation;
import GenbankFileReader.Qualifier;
import SequenceEditorPanels.ExtensibleArray;

public class TOCPrimer
extends TOCEntry {
    String name = "";
    String comment = "";
    int pbsStart = 0;
    boolean antisense = false;
    String sequence = "";

    private Annotation toAnnotation() {
        Annotation annotation = new Annotation();
        annotation.set(this.pbsStart, this.pbsStart + this.sequence.length() - 1, this.antisense);
        ExtensibleArray<Qualifier> quals = new ExtensibleArray<Qualifier>(Qualifier.class);
        annotation.setGBType("primer_bind");
        quals.add(new Qualifier("label", this.name));
        quals.add(new Qualifier("note", "sequence: " + this.sequence));
        if (this.comment != null && this.comment.length() > 0) {
            quals.add(new Qualifier("note", this.comment));
        }
        if (!quals.isEmpty()) {
            annotation.qualifiers = quals.toArray();
        }
        return annotation;
    }

    public Annotation parse() {
        short b01 = CloneManagerReader.bytesToShort(this.content[0], this.content[1]);
        short stCount = CloneManagerReader.bytesToShort(this.content[2], this.content[3]);
        int tLen = stCount * 8;
        int cstIndex = tLen + 4;
        int stIndex = 0;
        block7: for (stIndex = 4; stIndex < tLen - 8; stIndex += 8) {
            short stType = CloneManagerReader.bytesToShort(this.content[stIndex], this.content[stIndex + 1]);
            short stLen = CloneManagerReader.bytesToShort(this.content[stIndex + 4], this.content[stIndex + 5]);
            switch (stType) {
                case 2049: {
                    this.sequence = CloneManagerReader.extractString(this.content, cstIndex, stLen - 1);
                    cstIndex += stLen;
                    continue block7;
                }
                case 2053: {
                    this.pbsStart = CloneManagerReader.bytesToShort(this.content[cstIndex], this.content[cstIndex + 1]);
                    cstIndex += stLen;
                    continue block7;
                }
                case 2309: {
                    this.antisense = this.content[cstIndex] == 1;
                    cstIndex += 4;
                    continue block7;
                }
                case 3072: {
                    this.name = CloneManagerReader.extractString(this.content, cstIndex, stLen - 1);
                    cstIndex += stLen;
                    continue block7;
                }
                case 3073: {
                    this.comment = CloneManagerReader.extractString(this.content, cstIndex, stLen - 1);
                    cstIndex += stLen;
                    continue block7;
                }
                default: {
                    cstIndex += stLen;
                }
            }
        }
        return this.toAnnotation();
    }
}

