/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

import DNAAnalyzer.AnalyzerResult;
import DNAAnalyzer.DNAAnalyzer;
import DNAAnalyzer.ScoringMatrix;
import ProteinTools.CodonTable;
import Sequences.DNA;

public class KozakAnalyzer
extends DNAAnalyzer {
    int minORF = 0;
    int maxORF = 0;
    String startCodon = "ATG";
    public CodonTable codonTable = new CodonTable();
    private static final int row_A = 0;
    private static final int row_T = 1;
    private static final int row_C = 2;
    private static final int row_G = 3;

    public KozakAnalyzer() {
        this.matrix = ScoringMatrix.Matrix_KOZAK;
        this.description = "Kozak signal";
    }

    public void setORFMinMax(int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max < 0) {
            max = 0;
        }
        this.minORF = min;
        this.maxORF = max;
    }

    public void setStartCodon(String codon) {
        if ((codon = DNA.filterSequence(codon).toUpperCase()).length() < 3) {
            return;
        }
        this.startCodon = codon;
    }

    @Override
    protected boolean analyzeSequence(String sequence) {
        char[] seq = sequence.toCharArray();
        this.results.clear();
        int minLength = this.matrix.minLength;
        int first = this.startIndex;
        int last = this.stopIndex;
        if (last == 0) {
            last = seq.length;
        }
        int codonIndex = Math.max(minLength, first);
        codonIndex = sequence.indexOf(this.startCodon, codonIndex);
        while (codonIndex != -1 && codonIndex < last) {
            int offset = codonIndex - minLength;
            float score = this.matrix.score(seq, codonIndex - minLength);
            if (score >= this.cutoff) {
                String translation = this.codonTable.translate(seq, codonIndex, CodonTable.LetterCode.e1_Letter_Code, true);
                if (this.minORF == 0 && this.maxORF == 0 || this.minORF > 0 && this.maxORF > 0 && translation.length() >= this.minORF && translation.length() <= this.maxORF || this.minORF > 0 && this.maxORF == 0 && translation.length() >= this.minORF || this.maxORF > 0 && this.minORF > 0 && translation.length() <= this.maxORF) {
                    AnalyzerResult result = new AnalyzerResult(this.description, score);
                    result.start = offset;
                    result.stop = codonIndex;
                    result.sequence = this.matrix.formatSequence(seq, offset) + this.startCodon.toLowerCase();
                    result.addProperty("translation", translation);
                    this.results.add(result);
                }
            }
            ++codonIndex;
            codonIndex = sequence.indexOf(this.startCodon, codonIndex);
        }
        return !this.results.isEmpty();
    }

    public float scoreKozak(String sequence) {
        char[] seq = sequence.toCharArray();
        int mIndex = this.matrix.matrix[0].length - 1;
        float score = 0.0f;
        for (int sIndex = seq.length - 1; mIndex >= 0 && sIndex >= 0; --sIndex, --mIndex) {
            char chr = seq[sIndex];
            int row = 0;
            switch (chr) {
                case 'A': 
                case 'a': {
                    row = 0;
                    break;
                }
                case 'T': 
                case 't': {
                    row = 1;
                    break;
                }
                case 'C': 
                case 'c': {
                    row = 2;
                    break;
                }
                case 'G': 
                case 'g': {
                    row = 3;
                }
            }
            score += this.matrix.matrix[row][mIndex] / this.matrix.maxScores[mIndex];
        }
        return score / (float)seq.length;
    }
}

