/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import DNAAnalyzer.KozakAnalyzer;

public class AltStartScorer {
    static final float NR = 0.0f;
    static final char[] nt = new char[]{'U', 'C', 'A', 'G'};
    static final float[][] values = new float[][]{{0.22f, 0.08f, 0.0f, 0.0f}, {0.29f, 0.13f, 0.23f, 0.0f}, {0.09f, 0.09f, 0.01f, 0.0f}, {4.17f, 0.13f, 0.0f, 0.0f}, {0.05f, 0.11f, 0.0f, 0.07f}, {0.25f, 0.16f, 0.25f, 0.42f}, {0.16f, 0.28f, 0.07f, 0.12f}, {15.44f, 0.29f, 0.51f, 0.11f}, {3.05f, 0.13f, 0.0f, 0.04f}, {2.71f, 0.42f, 0.32f, 0.18f}, {1.29f, 0.17f, 1.34f, 0.15f}, {49.76f, 3.89f, 1.0f, 0.91f}, {0.0f, 0.22f, 0.0f, 0.1f}, {0.25f, 0.49f, 0.31f, 0.39f}, {0.12f, 0.32f, 0.31f, 0.31f}, {7.17f, 0.38f, 0.44f, 0.1f}};
    static final String[][] sValues = new String[][]{{"0.22", "0.08", "NR", "NR"}, {"0.29", "0.13", "0.23", "NR"}, {"0.09", "0.09", "0.01", "NR"}, {"4.17", "0.13", "<0.01%", "NR"}, {"0.05", "0.11", "NR", "0.07"}, {"0.25", "0.16", "0.25", "0.42"}, {"0.16", "0.28", "0.07", "0.12"}, {"15.44", "0.29", "0.51", "0.11"}, {"3.05", "0.13", "NR", "0.04"}, {"2.71", "0.42", "0.32", "0.18"}, {"1.29", "0.17", "1.34", "0.15"}, {"49.76", "3.89", "1.00", "0.91"}, {"NR", "0.22", "NR", "0.10"}, {"0.25", "0.49", "0.31", "0.39"}, {"0.12", "0.32", "0.31", "0.31"}, {"7.17", "0.38", "0.44", "0.10"}};
    static final int U = 0;
    static final int T = 0;
    static final int C = 1;
    static final int A = 2;
    static final int G = 3;

    public static void showAll() {
        for (int x1 = 0; x1 < nt.length; ++x1) {
            for (int x2 = 0; x2 < nt.length; ++x2) {
                for (int x3 = 0; x3 < nt.length; ++x3) {
                    AltStartScorer.score(x1, x2, x3);
                }
            }
        }
    }

    public static void score(String seq) {
        KozakAnalyzer k = new KozakAnalyzer();
        for (int x = 0; x < seq.length() - 2; x += 3) {
            if (x < 5) {
                System.out.println(seq.substring(x, x + 3) + "\t" + AltStartScorer.sScore(seq.charAt(x), seq.charAt(x + 1), seq.charAt(x + 2)));
                continue;
            }
            System.out.print(seq.substring(x, x + 3) + "\t" + AltStartScorer.sScore(seq.charAt(x), seq.charAt(x + 1), seq.charAt(x + 2)));
            String kozakSeq = seq.substring(x - 6, x);
            System.out.print("\t" + kozakSeq);
            System.out.println("\t" + k.scoreKozak(kozakSeq));
        }
    }

    public static float score(char nt1, char nt2, char nt3) {
        int row = 0;
        int col = 0;
        switch (nt1) {
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                row = 0;
                break;
            }
            case 'C': 
            case 'c': {
                row = 4;
                break;
            }
            case 'A': 
            case 'a': {
                row = 8;
                break;
            }
            case 'G': 
            case 'g': {
                row = 12;
            }
        }
        switch (nt3) {
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                break;
            }
            case 'C': 
            case 'c': {
                ++row;
                break;
            }
            case 'A': 
            case 'a': {
                row += 2;
                break;
            }
            case 'G': 
            case 'g': {
                row += 3;
            }
        }
        switch (nt2) {
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                col = 0;
                break;
            }
            case 'C': 
            case 'c': {
                col = 1;
                break;
            }
            case 'A': 
            case 'a': {
                col = 2;
                break;
            }
            case 'G': 
            case 'g': {
                col = 3;
            }
        }
        return values[row][col];
    }

    public static String sScore(char nt1, char nt2, char nt3) {
        int row = 0;
        int col = 0;
        switch (nt1) {
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                row = 0;
                break;
            }
            case 'C': 
            case 'c': {
                row = 4;
                break;
            }
            case 'A': 
            case 'a': {
                row = 8;
                break;
            }
            case 'G': 
            case 'g': {
                row = 12;
            }
        }
        switch (nt3) {
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                break;
            }
            case 'C': 
            case 'c': {
                ++row;
                break;
            }
            case 'A': 
            case 'a': {
                row += 2;
                break;
            }
            case 'G': 
            case 'g': {
                row += 3;
            }
        }
        switch (nt2) {
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                col = 0;
                break;
            }
            case 'C': 
            case 'c': {
                col = 1;
                break;
            }
            case 'A': 
            case 'a': {
                col = 2;
                break;
            }
            case 'G': 
            case 'g': {
                col = 3;
            }
        }
        return sValues[row][col];
    }

    public static void score(int x1, int x2, int x3) {
        System.out.print("" + nt[x1] + "" + nt[x2] + "" + nt[x3] + " = ");
        int row = x1 * 4 + x3;
        int col = x2;
        System.out.println(sValues[row][col]);
    }
}

