/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import GenbankFileReader.Locus;
import ProteinTools.CodonTable;
import SequenceEditorPanels.ExtensibleArray;
import Sequences.DNA;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DegenerateFinder {
    String sequence = null;
    String aSequence = null;
    String AAFrame1S;
    String AAFrame2S;
    String AAFrame3S;
    String AAFrame1AS;
    String AAFrame2AS;
    String AAFrame3AS;
    private int refLen = 0;
    private CodonTable table = null;

    public DegenerateFinder() {
    }

    public DegenerateFinder(DNA reference) {
        this.setRef(reference.getSequence().toUpperCase(), false);
    }

    public DegenerateFinder(String reference) {
        this.setReference(reference, false);
    }

    public DegenerateFinder(DNA reference, boolean circular) {
        this.setRef(reference.getSequence().toUpperCase(), circular);
    }

    public DegenerateFinder(String reference, boolean circular) {
        this.setReference(reference, circular);
    }

    public void setCodonTable(CodonTable table) {
        this.table = table;
    }

    public void setReference(String reference) {
        this.setRef(DNA.filterSequence(reference).toUpperCase(), false);
    }

    public void setReference(String reference, boolean circular) {
        this.setRef(DNA.filterSequence(reference).toUpperCase(), circular);
    }

    private void setRef(String ref, boolean circular) {
        this.sequence = ref;
        this.refLen = this.sequence.length();
        if (circular) {
            this.sequence = this.sequence + this.sequence;
        }
        this.aSequence = null;
        this.AAFrame1S = null;
        this.AAFrame2S = null;
        this.AAFrame3S = null;
        this.AAFrame1AS = null;
        this.AAFrame2AS = null;
        this.AAFrame3AS = null;
    }

    public Locus[] findDNASequence(String qry, boolean sense, boolean aSense) {
        int stop;
        int start;
        Matcher matcher;
        if (this.sequence == null) {
            return null;
        }
        ExtensibleArray<Locus> results = new ExtensibleArray<Locus>(Locus.class);
        qry = qry.toUpperCase();
        while (qry.length() > 0 && qry.startsWith("-")) {
            qry = qry.substring(1);
        }
        while (qry.endsWith("-")) {
            qry = qry.substring(0, qry.length() - 1);
        }
        String regexQry = DNA.DNAtoRegex(qry);
        Pattern patternDNA = Pattern.compile(regexQry, 2);
        if (sense) {
            matcher = patternDNA.matcher(this.sequence);
            while (matcher.find() && matcher.start() < this.refLen) {
                start = matcher.start() + 1;
                stop = matcher.end();
                results.add(new Locus(start, stop, false, this.refLen));
            }
        }
        if (aSense) {
            if (this.aSequence == null) {
                this.aSequence = DNA.getAntisense(this.sequence);
            }
            matcher = patternDNA.matcher(this.aSequence);
            while (matcher.find() && matcher.start() < this.refLen) {
                start = this.sequence.length() - matcher.start();
                stop = this.sequence.length() - matcher.end() + 1;
                results.add(new Locus(stop, start, true, this.refLen));
            }
        }
        return results.toArray();
    }

    public Locus[] findAASequence(String qry, boolean sense, boolean aSense) {
        if (this.table == null) {
            this.table = new CodonTable();
        }
        return this.findAASequence(qry, sense, aSense, this.table);
    }

    public Locus[] findAASequence(String qry, boolean sense, boolean aSense, CodonTable table) {
        int stop;
        int start;
        Matcher matcher;
        if (this.sequence == null) {
            return null;
        }
        ExtensibleArray<Locus> results = new ExtensibleArray<Locus>(Locus.class);
        qry = qry.toUpperCase();
        while (qry.endsWith("-")) {
            qry = qry.substring(0, qry.length() - 1);
        }
        if (sense && this.AAFrame1S == null) {
            this.AAFrame1S = table.translate(this.sequence, 1, CodonTable.LetterCode.e1_Letter_Code);
            this.AAFrame2S = table.translate(this.sequence, 2, CodonTable.LetterCode.e1_Letter_Code);
            this.AAFrame3S = table.translate(this.sequence, 3, CodonTable.LetterCode.e1_Letter_Code);
        }
        if (aSense && this.AAFrame1AS == null) {
            if (this.aSequence == null) {
                this.aSequence = DNA.getAntisense(this.sequence);
            }
            this.AAFrame1AS = table.translate(this.aSequence, 1, CodonTable.LetterCode.e1_Letter_Code);
            this.AAFrame2AS = table.translate(this.aSequence, 2, CodonTable.LetterCode.e1_Letter_Code);
            this.AAFrame3AS = table.translate(this.aSequence, 3, CodonTable.LetterCode.e1_Letter_Code);
        }
        int maxAA = this.refLen / 3;
        Pattern searchAA = Pattern.compile(CodonTable.AAtoRegex(qry), 2);
        if (sense) {
            matcher = searchAA.matcher(this.AAFrame1S);
            while (matcher.find() && matcher.start() < maxAA) {
                start = matcher.start() * 3 + 1;
                stop = matcher.end() * 3;
                results.add(new Locus(start, stop, false, this.refLen));
            }
            matcher = searchAA.matcher(this.AAFrame2S);
            while (matcher.find() && matcher.start() < maxAA) {
                start = matcher.start() * 3 + 2;
                stop = matcher.end() * 3 + 1;
                results.add(new Locus(start, stop, false, this.refLen));
            }
            matcher = searchAA.matcher(this.AAFrame3S);
            while (matcher.find() && matcher.start() < maxAA) {
                start = matcher.start() * 3 + 3;
                stop = matcher.end() * 3 + 2;
                results.add(new Locus(start, stop, false, this.refLen));
            }
        }
        if (aSense) {
            matcher = searchAA.matcher(this.AAFrame1AS);
            while (matcher.find() && matcher.start() < maxAA) {
                stop = this.refLen - (matcher.start() * 3 + 1) + 1;
                start = this.refLen - matcher.end() * 3 + 1;
                if (start > this.refLen) {
                    stop -= this.refLen;
                }
                results.add(new Locus(start, stop, true, this.refLen));
            }
            matcher = searchAA.matcher(this.AAFrame2AS);
            while (matcher.find() && matcher.start() < maxAA) {
                stop = this.refLen - (matcher.start() * 3 + 2) + 1;
                start = this.refLen - matcher.end() * 3 + 2;
                if (start > this.refLen) {
                    stop -= this.refLen;
                }
                results.add(new Locus(start, stop, true, this.refLen));
            }
            matcher = searchAA.matcher(this.AAFrame3AS);
            while (matcher.find() && matcher.start() < maxAA) {
                stop = this.refLen - (matcher.start() * 3 + 3) + 1;
                start = this.refLen - matcher.end() * 3 + 3;
                if (start > this.refLen) {
                    stop -= this.refLen;
                }
                results.add(new Locus(start, stop, true, this.refLen));
            }
        }
        return results.toArray();
    }
}

