/*
 * Decompiled with CFR 0.152.
 */
package DockingPanel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class ComponentMover
extends MouseAdapter {
    private Insets dragInsets = new Insets(0, 0, 0, 0);
    private Dimension snapSize = new Dimension(1, 1);
    private Insets edgeInsets = new Insets(0, 0, 0, 0);
    private boolean changeCursor = true;
    private boolean autoLayout = false;
    private Class destinationClass;
    private Component destinationComponent;
    private Component destination;
    private Component source;
    private Point pressed;
    private Point location;
    private Cursor originalCursor;
    private boolean autoscrolls;
    private boolean potentialDrag;
    private ArrayList<Component> registeredComponents = new ArrayList();

    public ComponentMover() {
    }

    public ComponentMover(Class destinationClass, Component ... components) {
        this.destinationClass = destinationClass;
        this.registerComponent(components);
    }

    public ComponentMover(Component destinationComponent, Component ... components) {
        this.destinationComponent = destinationComponent;
        this.registerComponent(components);
    }

    public boolean isAutoLayout() {
        return this.autoLayout;
    }

    public void setAutoLayout(boolean autoLayout) {
        this.autoLayout = autoLayout;
    }

    public boolean isChangeCursor() {
        return this.changeCursor;
    }

    public void setChangeCursor(boolean changeCursor) {
        this.changeCursor = changeCursor;
    }

    public Insets getDragInsets() {
        return this.dragInsets;
    }

    public void setDragInsets(Insets dragInsets) {
        this.dragInsets = dragInsets;
    }

    public Insets getEdgeInsets() {
        return this.edgeInsets;
    }

    public void setEdgeInsets(Insets edgeInsets) {
        this.edgeInsets = edgeInsets;
    }

    public void deregisterComponent(Component ... components) {
        for (Component component : components) {
            if (!this.registeredComponents.contains(component)) continue;
            component.removeMouseListener(this);
            this.registeredComponents.remove(component);
        }
    }

    public void deregisterComponents() {
        for (Component component : this.registeredComponents) {
            component.removeMouseListener(this);
        }
        this.registeredComponents.clear();
    }

    public void registerComponent(Component ... components) {
        for (Component component : components) {
            if (this.registeredComponents.contains(component)) continue;
            component.addMouseListener(this);
            this.registeredComponents.add(component);
        }
    }

    public boolean isRegistered(Component component) {
        return this.registeredComponents.contains(component);
    }

    public Dimension getSnapSize() {
        return this.snapSize;
    }

    public void setSnapSize(Dimension snapSize) {
        if (snapSize.width < 1 || snapSize.height < 1) {
            throw new IllegalArgumentException("Snap sizes must be greater than 0");
        }
        this.snapSize = snapSize;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.source = e.getComponent();
        int width = this.source.getSize().width - this.dragInsets.left - this.dragInsets.right;
        int height = this.source.getSize().height - this.dragInsets.top - this.dragInsets.bottom;
        Rectangle r = new Rectangle(this.dragInsets.left, this.dragInsets.top, width, height);
        if (r.contains(e.getPoint())) {
            this.setupForDragging(e);
        }
    }

    private void setupForDragging(MouseEvent e) {
        this.source.addMouseMotionListener(this);
        this.potentialDrag = true;
        this.destination = this.destinationComponent != null ? this.destinationComponent : (this.destinationClass == null ? this.source : SwingUtilities.getAncestorOfClass(this.destinationClass, this.source));
        this.pressed = e.getLocationOnScreen();
        this.location = this.destination.getLocation();
        if (this.changeCursor) {
            this.originalCursor = this.source.getCursor();
            this.source.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.destination instanceof JComponent) {
            JComponent jc = (JComponent)this.destination;
            this.autoscrolls = jc.getAutoscrolls();
            jc.setAutoscrolls(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int locationY;
        int locationX;
        Point dragged = e.getLocationOnScreen();
        Point window = this.destination.getLocation();
        int newX = window.x + dragged.x - this.pressed.x;
        int newY = window.y + dragged.y - this.pressed.y;
        if (newX % this.snapSize.width == 0) {
            locationX = newX;
            this.pressed.x = dragged.x;
        } else {
            locationX = window.x;
        }
        if (newY % this.snapSize.height == 0) {
            locationY = newY;
            this.pressed.y = dragged.y;
        } else {
            locationY = window.y;
        }
        if (locationX != window.x || locationY != window.y) {
            this.destination.setLocation(locationX, locationY);
        }
        this.location.x = locationX;
        this.location.y = locationX;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.potentialDrag) {
            return;
        }
        this.source.removeMouseMotionListener(this);
        this.potentialDrag = false;
        if (this.changeCursor) {
            this.source.setCursor(this.originalCursor);
        }
        if (this.destination instanceof JComponent) {
            ((JComponent)this.destination).setAutoscrolls(this.autoscrolls);
        }
        if (this.autoLayout) {
            if (this.destination instanceof JComponent) {
                ((JComponent)this.destination).revalidate();
            } else {
                this.destination.validate();
            }
        }
    }
}

