/*
 * Decompiled with CFR 0.152.
 */
package DockingPanel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class ComponentResizer
extends MouseAdapter {
    private static final Dimension MINIMUM_SIZE = new Dimension(10, 10);
    private static final Dimension MAXIMUM_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static Map<Integer, Integer> cursors = new HashMap<Integer, Integer>();
    private Insets dragInsets;
    private Dimension snapSize;
    private int direction;
    protected static final int NORTH = 1;
    protected static final int WEST = 2;
    protected static final int SOUTH = 4;
    protected static final int EAST = 8;
    private Cursor sourceCursor;
    private boolean resizing;
    private Rectangle bounds;
    private Point pressed;
    private boolean autoscrolls;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private ArrayList<Component> registeredComponents;

    public ComponentResizer() {
        this(new Insets(5, 5, 5, 5), new Dimension(1, 1), new Component[0]);
    }

    public ComponentResizer(Component ... components) {
        this(new Insets(5, 5, 5, 5), new Dimension(1, 1), components);
    }

    public ComponentResizer(Insets dragInsets, Component ... components) {
        this(dragInsets, new Dimension(1, 1), components);
    }

    public ComponentResizer(Insets dragInsets, Dimension snapSize, Component ... components) {
        cursors.put(1, 8);
        cursors.put(2, 10);
        cursors.put(4, 9);
        cursors.put(8, 11);
        cursors.put(3, 6);
        cursors.put(9, 7);
        cursors.put(6, 4);
        cursors.put(12, 5);
        this.minimumSize = MINIMUM_SIZE;
        this.maximumSize = MAXIMUM_SIZE;
        this.registeredComponents = new ArrayList();
        this.setDragInsets(dragInsets);
        this.setSnapSize(snapSize);
        this.registerComponent(components);
    }

    public Insets getDragInsets() {
        return this.dragInsets;
    }

    public void setDragInsets(Insets dragInsets) {
        this.validateMinimumAndInsets(this.minimumSize, dragInsets);
        this.dragInsets = dragInsets;
    }

    public Dimension getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.validateMinimumAndInsets(minimumSize, this.dragInsets);
        this.minimumSize = minimumSize;
    }

    public void deregisterComponent(Component ... components) {
        for (Component component : components) {
            if (!this.registeredComponents.contains(component)) continue;
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            this.registeredComponents.remove(component);
        }
    }

    public void deregisterComponents() {
        for (Component component : this.registeredComponents) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
        }
        this.registeredComponents.clear();
    }

    public boolean isRegistered(Component component) {
        return this.registeredComponents.contains(component);
    }

    public void registerComponent(Component ... components) {
        for (Component component : components) {
            if (this.registeredComponents.contains(component)) continue;
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            this.registeredComponents.add(component);
        }
    }

    public Dimension getSnapSize() {
        return this.snapSize;
    }

    public void setSnapSize(Dimension snapSize) {
        this.snapSize = snapSize;
    }

    private void validateMinimumAndInsets(Dimension minimum, Insets drag) {
        int minimumWidth = drag.left + drag.right;
        int minimumHeight = drag.top + drag.bottom;
        if (minimum.width < minimumWidth || minimum.height < minimumHeight) {
            String message = "Minimum size cannot be less than drag insets";
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component source = e.getComponent();
        Point location = e.getPoint();
        this.direction = 0;
        if (location.x < this.dragInsets.left) {
            this.direction += 2;
        }
        if (location.x > source.getWidth() - this.dragInsets.right - 1) {
            this.direction += 8;
        }
        if (location.y < this.dragInsets.top) {
            ++this.direction;
        }
        if (location.y > source.getHeight() - this.dragInsets.bottom - 1) {
            this.direction += 4;
        }
        if (this.direction == 0) {
            source.setCursor(this.sourceCursor);
        } else {
            int cursorType = cursors.get(this.direction);
            Cursor cursor = Cursor.getPredefinedCursor(cursorType);
            source.setCursor(cursor);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.resizing) {
            Component source = e.getComponent();
            this.sourceCursor = source.getCursor();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.resizing) {
            Component source = e.getComponent();
            source.setCursor(this.sourceCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.direction == 0) {
            return;
        }
        this.resizing = true;
        Component source = e.getComponent();
        this.pressed = e.getPoint();
        SwingUtilities.convertPointToScreen(this.pressed, source);
        this.bounds = source.getBounds();
        if (source instanceof JComponent) {
            JComponent jc = (JComponent)source;
            this.autoscrolls = jc.getAutoscrolls();
            jc.setAutoscrolls(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resizing = false;
        Component source = e.getComponent();
        source.setCursor(this.sourceCursor);
        if (source instanceof JComponent) {
            ((JComponent)source).setAutoscrolls(this.autoscrolls);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.resizing) {
            return;
        }
        Component source = e.getComponent();
        Point dragged = e.getPoint();
        SwingUtilities.convertPointToScreen(dragged, source);
        this.changeBounds(source, this.direction, this.bounds, dragged);
    }

    protected void changeBounds(Component source, int direction, Rectangle bounds, Point mouse) {
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        int deltaX = mouse.x - this.pressed.x;
        int deltaY = mouse.y - this.pressed.y;
        if (deltaX != 0) {
            int newWd;
            if (2 == (direction & 2)) {
                newWd = width - deltaX;
                if (newWd % this.snapSize.width == 0 && newWd >= this.minimumSize.width && newWd <= this.maximumSize.width) {
                    width = newWd;
                    x += deltaX;
                    this.pressed.x = mouse.x;
                }
            } else if (8 == (direction & 8) && (newWd = width + deltaX) % this.snapSize.width == 0 && newWd >= this.minimumSize.width && newWd <= this.maximumSize.width) {
                width = newWd;
                this.pressed.x = mouse.x;
            }
        }
        if (deltaY != 0) {
            int newHt;
            if (1 == (direction & 1)) {
                newHt = height - deltaY;
                if (newHt % this.snapSize.height == 0 && newHt >= this.minimumSize.height && newHt <= this.maximumSize.height) {
                    height = newHt;
                    y += deltaY;
                    this.pressed.y = mouse.y;
                }
            } else if (4 == (direction & 4) && (newHt = height + deltaY) % this.snapSize.height == 0 && newHt >= this.minimumSize.height && newHt <= this.maximumSize.height) {
                height = newHt;
                this.pressed.y = mouse.y;
            }
        }
        if (width != bounds.width || height != bounds.height) {
            bounds.width = width;
            bounds.height = height;
            bounds.x = x;
            bounds.y = y;
            source.setBounds(x, y, width, height);
            source.validate();
        }
    }
}

