/*
 * Decompiled with CFR 0.152.
 */
package DockingPanel;

import DockingPanel.DockRunOnClose;
import DockingPanel.DockingWindow;
import DockingPanel.GradientBar;
import IconRenderers.AlwaysOnTopButtonIconRenderer;
import IconRenderers.CloseButtonIconRenderer;
import IconRenderers.ControlButtonRenderer;
import IconRenderers.DockIconRenderer;
import IconRenderers.MinButtonIconRenderer;
import IconRenderers.RestoreButtonIconRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanProperty;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingContainer;
import javax.swing.UIManager;
import plaf.BaseRootPaneUI;
import plaf.RenderedTitleButton;

@SwingContainer(delegate="getContentPane")
public class DockPanel
extends JPanel {
    public static String osname;
    public static String osarch;
    static boolean isMac;
    static boolean isWin;
    static boolean isLinux;
    static boolean is64Bit;
    static int javaVersion;
    private ActionOnClose closeAction = ActionOnClose.DOCK;
    boolean showClose = true;
    boolean showMax = true;
    boolean showMin = true;
    boolean showDock = true;
    boolean showUndock = true;
    boolean showToggleTop = true;
    boolean showUndockedBar = true;
    boolean showDockedBar = true;
    private int dockedHt = 0;
    private int unDockedHt = 0;
    private static final int DEFAULT_HEIGHT = 24;
    private RenderedTitleButton cmdAoT;
    private RenderedTitleButton cmdClose;
    private RenderedTitleButton cmdDock;
    private RenderedTitleButton cmdMaximize;
    private RenderedTitleButton cmdMinimize;
    public JPanel contentPanel;
    private GradientBar gradientBar;

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isMacOSX() {
        return DockPanel.isMacintosh();
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static int javaVersion() {
        return javaVersion;
    }

    public static boolean isJava2() {
        return true;
    }

    public static boolean isJava14() {
        return true;
    }

    public static boolean isJava15() {
        return true;
    }

    public static boolean isJava16() {
        return javaVersion >= 6;
    }

    public static boolean isJava17() {
        return javaVersion >= 7;
    }

    public static boolean isJava18() {
        return javaVersion >= 8;
    }

    public static boolean isJava19() {
        return javaVersion >= 9;
    }

    @BeanProperty(hidden=true)
    public RenderedTitleButton getCloseButton() {
        return this.cmdClose;
    }

    @BeanProperty(hidden=true)
    public RenderedTitleButton getMaximizeButton() {
        return this.cmdMaximize;
    }

    @BeanProperty(hidden=true)
    public RenderedTitleButton getMinimizeButton() {
        return this.cmdMinimize;
    }

    @BeanProperty(hidden=true)
    public RenderedTitleButton getAlwaysOnTopButton() {
        return this.cmdAoT;
    }

    @BeanProperty(hidden=true)
    public RenderedTitleButton getDockButton() {
        return this.cmdDock;
    }

    @BeanProperty(hidden=true)
    public Container getContentPane() {
        return this.contentPanel;
    }

    @Override
    public void setFont(Font font) {
        if (this.gradientBar != null) {
            this.gradientBar.setFont(font);
        }
        super.setFont(font);
    }

    @BeanProperty(hidden=true)
    public void setActionOnClose(ActionOnClose action) {
        this.closeAction = action;
    }

    @BeanProperty(hidden=true)
    public ActionOnClose getActionOnClose() {
        return this.closeAction;
    }

    public boolean beforeMaximize() {
        return true;
    }

    public void afterMaximized() {
    }

    public boolean beforeMinimize() {
        return true;
    }

    public void afterMinimized() {
    }

    public boolean beforeClose() {
        return true;
    }

    public void afterClosed() {
    }

    public boolean beforeDock() {
        return true;
    }

    public void afterDocked() {
    }

    public boolean beforeUndock() {
        return true;
    }

    public void afterUndocked() {
    }

    public DockPanel() {
        this.initComponents();
        this.gradientBar.setLayout(new GradientTitleBarLayout());
        this.dockedHt = UIManager.getInt("DockingFrame.titlebar.docked.height");
        if (this.dockedHt > 0) {
            this.gradientBar.setPreferredSize(new Dimension(this.gradientBar.getPreferredSize().width, this.dockedHt));
        } else {
            int titlePaneHt = UIManager.getInt("RenderedUI.TitlePane.height");
            this.dockedHt = titlePaneHt > 0 ? titlePaneHt : 24;
        }
        this.unDockedHt = UIManager.getInt("DockingFrame.titlebar.undocked.height");
        if (this.unDockedHt == 0) {
            this.unDockedHt = this.dockedHt;
        }
        this.showDockedBar = !UIManager.getBoolean("DockingFrame.titlebar.hidedocked");
        boolean bl = this.showUndockedBar = !UIManager.getBoolean("DockingFrame.titlebar.hideundocked");
        if (!this.showDockedBar) {
            this.gradientBar.setVisible(false);
        }
        this.gradientBar.setFont(this.getFont());
        Object uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.iconify.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.cmdMinimize.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.cmdMinimize.setRenderer(new MinButtonIconRenderer());
        }
        uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.maximize.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.cmdMaximize.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.cmdMaximize.setRenderer(new RestoreButtonIconRenderer());
        }
        uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.close.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.cmdClose.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.cmdClose.setRenderer(new CloseButtonIconRenderer());
        }
        uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.alwaysontop.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.cmdAoT.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.cmdAoT.setRenderer(new AlwaysOnTopButtonIconRenderer());
        }
        uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.dock.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.cmdDock.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.cmdDock.setRenderer(new DockIconRenderer());
        }
        this.cmdAoT.setToolTipText("Toggle window always on top.");
        this.cmdAoT.setButtonName("alwaysontop");
        this.cmdDock.setButtonName("Dock");
        this.setButtonVisibilities(true);
    }

    static boolean isActive(Component c) {
        Frame parent = DockPanel.getParentWindow(c);
        return parent != null ? parent.isActive() : true;
    }

    private boolean isActive() {
        Frame parent = this.getParentWindow();
        return parent != null ? parent.isActive() : true;
    }

    private boolean isActiveAoT() {
        Frame parent = DockPanel.getParentWindow(this.cmdAoT);
        return parent != null ? parent.isActive() : true;
    }

    @BeanProperty(preferred=true, description="Optional text to display on the bar.")
    public void setTitle(String text) {
        this.gradientBar.setText(text);
    }

    public String getTitle() {
        return this.gradientBar.getText();
    }

    @BeanProperty(preferred=true, description="Optional icon to display on the bar.")
    public void setIcon(Icon icon) {
        this.gradientBar.setIcon(icon);
    }

    public Icon getIcon() {
        return this.gradientBar.getIcon();
    }

    @BeanProperty(hidden=true)
    public GradientBar getGradientBar() {
        return this.gradientBar;
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.gradientBar = new GradientBar();
        this.cmdClose = new RenderedTitleButton(){

            @Override
            public boolean isWindowActive() {
                return DockPanel.this.isActive();
            }
        };
        this.cmdMinimize = new RenderedTitleButton(){

            @Override
            public boolean isWindowActive() {
                return DockPanel.this.isActive();
            }
        };
        this.cmdMaximize = new RenderedTitleButton(){

            @Override
            public boolean isWindowActive() {
                return DockPanel.this.isActive();
            }
        };
        this.cmdDock = new RenderedTitleButton(){

            @Override
            public boolean isWindowActive() {
                return DockPanel.this.isActiveAoT();
            }
        };
        this.cmdAoT = new RenderedTitleButton(){

            @Override
            public boolean isWindowActive() {
                return DockPanel.this.isActiveAoT();
            }
        };
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 379, Short.MAX_VALUE));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 263, Short.MAX_VALUE));
        this.gradientBar.setForeground(new Color(0, 0, 0));
        this.gradientBar.setText("Docking Pane");
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DockPanel.this.cmdCloseActionPerformed(evt);
            }
        });
        this.cmdMinimize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DockPanel.this.cmdMinimizeActionPerformed(evt);
            }
        });
        this.cmdMaximize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DockPanel.this.cmdMaximizeActionPerformed(evt);
            }
        });
        this.cmdDock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DockPanel.this.cmdDockActionPerformed(evt);
            }
        });
        this.cmdAoT.setToolTipText("Toggle always on top");
        this.cmdAoT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DockPanel.this.cmdAoTActionPerformed(evt);
            }
        });
        GroupLayout gradientBarLayout = new GroupLayout(this.gradientBar);
        this.gradientBar.setLayout(gradientBarLayout);
        gradientBarLayout.setHorizontalGroup(gradientBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gradientBarLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.cmdAoT, -2, 26, -2).addGap(0, 0, 0).addComponent(this.cmdDock, -2, 26, -2).addGap(0, 0, 0).addComponent(this.cmdMinimize, -2, 44, -2).addGap(0, 0, 0).addComponent(this.cmdMaximize, -2, 44, -2).addGap(0, 0, 0).addComponent(this.cmdClose, -2, 44, -2).addGap(0, 0, 0)));
        gradientBarLayout.setVerticalGroup(gradientBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdClose, GroupLayout.Alignment.TRAILING, -1, 32, Short.MAX_VALUE).addComponent(this.cmdMinimize, -1, -1, Short.MAX_VALUE).addComponent(this.cmdMaximize, -1, -1, Short.MAX_VALUE).addComponent(this.cmdDock, -1, -1, Short.MAX_VALUE).addComponent(this.cmdAoT, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE).addComponent(this.gradientBar, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.gradientBar, -2, -1, -2).addGap(0, 0, 0).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void cmdMaximizeActionPerformed(ActionEvent evt) {
        this.max();
    }

    private void cmdMinimizeActionPerformed(ActionEvent evt) {
        this.min();
    }

    private void cmdDockActionPerformed(ActionEvent evt) {
        this.toggleDocked();
    }

    private void cmdAoTActionPerformed(ActionEvent evt) {
        this.toggleAoT();
    }

    private void min() {
        if (!this.beforeMinimize()) {
            return;
        }
        DockingWindow f = DockingWindow.getUndockedWindow(this);
        if (f != null) {
            f.setState(1);
        }
        this.afterMinimized();
    }

    private void max() {
        if (!this.beforeMaximize()) {
            return;
        }
        DockingWindow f = DockingWindow.getUndockedWindow(this);
        if (f != null) {
            int currentState = f.getExtendedState();
            switch (currentState) {
                case 0: {
                    f.setExtendedState(6);
                    break;
                }
                default: {
                    f.setExtendedState(0);
                }
            }
        }
        this.afterMaximized();
    }

    private void close() {
        if (!this.beforeClose()) {
            return;
        }
        switch (this.closeAction) {
            case DOCK: {
                this.setDocked(true);
                break;
            }
            case HIDE: {
                DockingWindow f = DockingWindow.getUndockedWindow(this);
                if (f == null) break;
                f.setVisible(false);
                break;
            }
            case NOTHING: {
                break;
            }
            case DISPOSE: {
                DockingWindow f = DockingWindow.getUndockedWindow(this);
                if (f == null) break;
                f.dispose();
                break;
            }
        }
        this.afterClosed();
    }

    private void toggleDocked() {
        this.setDocked(!this.isDocked());
    }

    private void toggleAoT() {
        DockingWindow w = DockingWindow.getUndockedWindow(this);
        if (w == null) {
            return;
        }
        w.setAlwaysOnTop(!w.isAlwaysOnTop());
    }

    public boolean isDocked() {
        return DockingWindow.isDocked(this);
    }

    public void setDocked(boolean docked) {
        if (docked != this.isDocked()) {
            if (docked) {
                this.dock();
            } else {
                this.detach();
            }
            this.firePropertyChange("docked", !docked, docked);
        }
    }

    public boolean isAlwaysOnTop() {
        DockingWindow w = DockingWindow.getUndockedWindow(this);
        return w == null ? false : w.isAlwaysOnTop();
    }

    public void setAlwaysOnTop(boolean onTop) {
        DockingWindow w = DockingWindow.getUndockedWindow(this);
        if (w == null) {
            return;
        }
        w.setAlwaysOnTop(onTop);
    }

    private void dock() {
        if (!this.beforeDock()) {
            return;
        }
        if (this.getParent().isVisible()) {
            DockingWindow.dock(this);
        } else {
            this.getParent().setVisible(true);
        }
        if (this.showDockedBar) {
            this.gradientBar.setVisible(true);
            this.gradientBar.setPreferredSize(new Dimension(this.gradientBar.getWidth(), this.dockedHt));
        }
        this.gradientBar.add(this.cmdAoT);
        this.gradientBar.add(this.cmdDock);
        this.setButtonVisibilities(true);
        this.afterDocked();
    }

    private void detach() {
        DockingWindow f;
        if (!this.beforeUndock()) {
            return;
        }
        DockRunOnClose toolCloser = new DockRunOnClose(){

            @Override
            public void runOnClose() {
                DockPanel.this.toggleDocked();
            }
        };
        if (DockingWindow.unDock(this, this.gradientBar.getText(), toolCloser, (ImageIcon)this.gradientBar.getIcon()) && (f = DockingWindow.getUndockedWindow(this)) != null) {
            if (!BaseRootPaneUI.hasBaseRootPane(f) && this.showUndockedBar) {
                this.gradientBar.setVisible(true);
                f.setMoveComponent(this.gradientBar);
                this.gradientBar.setPreferredSize(new Dimension(this.gradientBar.getWidth(), this.unDockedHt));
            } else {
                if (this.showDockedBar) {
                    this.gradientBar.setVisible(false);
                }
                f.cr.deregisterComponents();
                if (BaseRootPaneUI.hasBaseRootPane(f)) {
                    BaseRootPaneUI.setTitleBarButtons((JFrame)f, this.cmdAoT, this.cmdDock);
                }
            }
        }
        this.setButtonVisibilities(false);
        this.afterUndocked();
    }

    private void setButtonVisibilities() {
        this.setButtonVisibilities(DockingWindow.isDocked(this));
    }

    private void setButtonVisibilities(boolean isDocked) {
        if (isDocked) {
            this.cmdMaximize.setVisible(false);
            this.cmdMinimize.setVisible(false);
            this.cmdClose.setVisible(false);
            this.cmdAoT.setVisible(false);
            this.cmdDock.setVisible(this.showUndock);
            this.cmdDock.setToolTipText("Undock");
        } else {
            this.cmdMaximize.setVisible(this.showMax);
            this.cmdMinimize.setVisible(this.showMin);
            this.cmdClose.setVisible(this.showClose);
            this.cmdDock.setVisible(this.showDock);
            this.cmdAoT.setVisible(this.showToggleTop);
            this.cmdDock.setToolTipText("Dock");
        }
    }

    public boolean isShowMaxButton() {
        return this.showMax;
    }

    public boolean isShowMinButton() {
        return this.showMin;
    }

    public boolean isShowCloseButton() {
        return this.showClose;
    }

    public boolean isShowDockButton() {
        return this.showDock;
    }

    public boolean isShowUndockButton() {
        return this.showDock;
    }

    public boolean isShowDockedTitleBar() {
        return this.showDockedBar;
    }

    public boolean isShowUndockedTitleBar() {
        return this.showUndockedBar;
    }

    @BeanProperty(preferred=true, description="Whether or not to show the Maximize button in the gradient bar.")
    public void setShowMaxButton(boolean show) {
        this.showMax = show;
        this.setButtonVisibilities();
    }

    @BeanProperty(preferred=true, description="Whether or not to show the title bar when docked.")
    public void setShowDockedTitleBar(boolean show) {
        this.showDockedBar = show;
        if (this.isDocked()) {
            this.gradientBar.setVisible(show);
        }
    }

    @BeanProperty(preferred=true, description="Whether or not to show the title bar when undocked.")
    public void setShowUndockedTitleBar(boolean show) {
        this.showUndockedBar = show;
        if (!this.isDocked()) {
            this.gradientBar.setVisible(show);
        }
    }

    @BeanProperty(preferred=true, description="Whether or not to show the Minimize button in the gradient bar then the panel is not docked.")
    public void setShowMinButton(boolean show) {
        this.showMin = show;
        this.setButtonVisibilities();
    }

    @BeanProperty(preferred=true, description="Whether or not to show the Maximize button in the gradient bar then the panel is not docked.")
    public void setShowCloseButton(boolean show) {
        this.showClose = show;
        this.setButtonVisibilities();
    }

    @BeanProperty(preferred=true, description="Whether or not to show the Dock button in the gradient bar then the panel is not docked.")
    public void setShowDockButton(boolean show) {
        this.showDock = show;
        this.setButtonVisibilities();
    }

    @BeanProperty(preferred=true, description="Whether or not to show the Undock button in the gradient bar then the panel is docked.")
    public void setShowUndockButton(boolean show) {
        this.showUndock = show;
        this.setButtonVisibilities();
    }

    @BeanProperty(preferred=true, description="Whether or not to show the Always On Top button in the gradient bar then the panel is not docked.")
    public void setShowAlwaysOnTop(boolean show) {
        this.showToggleTop = show;
        this.setButtonVisibilities();
    }

    public boolean isShowAlwaysOnTop() {
        return this.showToggleTop;
    }

    public Frame getParentWindow() {
        return DockPanel.getParentWindow(this);
    }

    static Frame getParentWindow(Component c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (p instanceof Frame) {
                return (Frame)p;
            }
            if (!(p instanceof Component)) continue;
            return DockPanel.getParentWindow(p);
        }
        return null;
    }

    protected boolean isLeftToRight() {
        Frame window = this.getParentWindow();
        return window == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
    }

    static {
        String osName = System.getProperty("os.name");
        boolean iswin = osName.startsWith("Windows");
        isMac = !iswin && osName.startsWith("Mac");
        isLinux = osName.startsWith("Linux");
        osname = osName;
        isWin = iswin;
        String version = System.getProperty("java.version");
        if (version == null || version.length() < 2) {
            version = "1.8";
        }
        javaVersion = version.startsWith("1.8") ? 8 : (version.charAt(0) == '1' && Character.isDigit(version.charAt(1)) ? 10 + (version.charAt(1) - 48) : (version.charAt(0) == '2' && Character.isDigit(version.charAt(1)) ? 20 + (version.charAt(1) - 48) : (version.startsWith("1.6") ? 6 : (version.startsWith("1.9") || version.startsWith("9") ? 9 : (version.startsWith("1.7") ? 7 : 8)))));
    }

    public static enum ActionOnClose {
        DOCK,
        DISPOSE,
        HIDE,
        NOTHING;

    }

    protected class GradientTitleBarLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        protected int computeHeight() {
            if (DockPanel.this.isDocked()) {
                return DockPanel.this.dockedHt;
            }
            return DockPanel.this.unDockedHt;
        }

        @Override
        public void layoutContainer(Container c) {
            this.layoutDefault(c);
        }

        public void layoutDefault(Container c) {
            int h;
            int btnHeight;
            boolean leftToRight = DockPanel.this.isLeftToRight();
            int spacing = 0;
            int w = DockPanel.this.gradientBar.getWidth();
            int btnWidth = btnHeight = (h = this.computeHeight());
            int x = leftToRight ? w : 0;
            int y = Math.max(0, (h - btnHeight) / 2 - 1);
            if (DockPanel.this.cmdClose.isVisible()) {
                DockPanel.this.cmdClose.setBounds(x += leftToRight ? -btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (DockPanel.this.cmdMaximize.isVisible() && DockPanel.this.cmdMaximize.getParent() != null && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                DockPanel.this.cmdMaximize.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (DockPanel.this.cmdMinimize.isVisible() && DockPanel.this.cmdMinimize.getParent() != null) {
                DockPanel.this.cmdMinimize.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (DockPanel.this.cmdAoT.isVisible() && DockPanel.this.cmdAoT.getParent() != null) {
                DockPanel.this.cmdAoT.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (DockPanel.this.cmdDock.isVisible() && DockPanel.this.cmdDock.getParent() != null) {
                DockPanel.this.cmdDock.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
        }
    }
}

