/*
 * Decompiled with CFR 0.152.
 */
package DocumentFilters;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public abstract class DocumentKeyFilter
extends DocumentFilter {
    public static final String FILTER_GB_NAME = "\\w\\-'";
    public static final String FILTER_AA = "[^*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy]";
    public static final String FILTER_NUMBER = "[^0123456789]";
    public static final String FILTER_LOWERCASE = "a-z";
    public static final String FILTER_UPPERCASE = "A-Z";
    public static final String FILTER_ALPHA = "a-zA-Z";
    public static final String FILTER_NUMERIC = "0-9";
    public static final String FILTER_FLOAT = "[^0123456789]\\.";
    public static final String FILTER_ALPHANUMERIC = "a-zA-Z0-9";
    public static final DocumentKeyFilter NumberFilter = new DocumentKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(DocumentKeyFilter.FILTER_NUMBER, "");
        }
    };
    public static final DocumentKeyFilter GenbankNameFilter = new DocumentKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(DocumentKeyFilter.FILTER_GB_NAME, "");
        }
    };

    public abstract String filterText(String var1);

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        String fString = this.filterText(text);
        if (fString != null && fString.length() > 0) {
            super.insertString(fb, offset, fString, attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        String fString = this.filterText(text);
        if (fString != null && fString.length() > 0) {
            super.replace(fb, offset, length, fString, attrs);
        }
    }
}

