/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.ComponentCellEditor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class CellEditorComboBox
extends ComponentCellEditor {
    JComboBox cEditor;
    boolean settingInitialValue = false;

    public CellEditorComboBox() {
        this(new JComboBox());
    }

    public CellEditorComboBox(JComboBox editor) {
        super(editor);
    }

    public CellEditorComboBox(Object[] items) {
        this(new JComboBox<Object>(items));
    }

    @Override
    public Object getEnteredValue() {
        return String.valueOf(this.cEditor.getSelectedItem());
    }

    @Override
    public void setStartingValue(Object value) {
        super.setStartingValue(value);
        this.settingInitialValue = true;
        this.cEditor.setSelectedItem(value);
        this.settingInitialValue = false;
    }

    @Override
    public void init() {
        super.init();
        this.cEditor = (JComboBox)this.getEditor();
        this.cEditor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                CellEditorComboBox.this.cEditor.setPopupVisible(true);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        this.cEditor.addItemListener(e -> {
            if (!this.settingInitialValue && this.isEditing) {
                this.applyEdit();
            }
        });
    }

    @Override
    public boolean beforeEdit() {
        if (!super.beforeEdit()) {
            return false;
        }
        JTextField e = (JTextField)this.cEditor.getEditor().getEditorComponent();
        switch (this.table.getColumnCellAlignment(this.colIndex)) {
            case 0: {
                e.setHorizontalAlignment(0);
                break;
            }
            case 4: {
                e.setHorizontalAlignment(4);
                break;
            }
            case 2: {
                e.setHorizontalAlignment(2);
                break;
            }
        }
        this.settingInitialValue = true;
        this.cEditor.getModel().setSelectedItem(String.valueOf(this.table.getModel().getValue(this.colIndex, this.rowIndex)));
        this.settingInitialValue = false;
        return true;
    }
}

