/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.CellEditor;
import EditorTable.DataTable;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class CellEditorFile
extends CellEditor {
    String title = "Select file";
    File file = null;
    JFileChooser dlg;
    FileView fv = new FileView(){

        @Override
        public Icon getIcon(File f) {
            return FileSystemView.getFileSystemView().getSystemIcon(f);
        }
    };

    public CellEditorFile() {
        this(new JFileChooser());
    }

    public CellEditorFile(JFileChooser dlg) {
        this.dlg = dlg;
    }

    @Override
    public void init() {
    }

    @Override
    public void startEdit(DataTable table, int colIndex, int rowIndex, int x, int y, int width, int height) {
        super.startEdit(table, colIndex, rowIndex, x, y, width, height);
        this.file = null;
        if (this.getStartingValue() instanceof String) {
            if (this.dlg.showOpenDialog(table) != 0) {
                this.cancelEdit();
            } else {
                this.file = this.dlg.getSelectedFile();
                this.setEnteredValue(this.file.getAbsolutePath());
                this.applyEdit();
                table.repaint();
            }
        }
    }

    @Override
    public Object getEnteredValue() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void cancelEdit() {
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public boolean beforeEdit() {
        return true;
    }
}

