/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.DataTable;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public abstract class CellRenderer {
    BufferedImage canvas = null;
    Graphics2D gCanvas = null;
    int width = 0;
    int height = 0;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Graphics2D getGraphicsBuffer(int width, int height) {
        if (this.gCanvas == null || this.width != width || this.height != height) {
            this.regenBuffer(width, height);
        }
        return this.gCanvas;
    }

    public BufferedImage getImage() {
        return this.canvas;
    }

    public BufferedImage getImageBuffer(int width, int height) {
        if (this.canvas == null || this.width != width || this.height != height) {
            this.regenBuffer(width, height);
        }
        return this.canvas;
    }

    public void clear() {
        this.regenBuffer(this.width, this.height);
    }

    void regenBuffer(int width, int height) {
        if (this.gCanvas != null) {
            this.gCanvas.dispose();
        }
        this.height = Math.max(1, height);
        this.width = Math.max(1, width);
        this.canvas = new BufferedImage(this.width, this.height, 2);
        this.gCanvas = (Graphics2D)this.canvas.getGraphics();
    }

    public abstract void draw(DataTable var1, int var2, int var3, boolean var4);

    public abstract void setFont(Font var1);
}

