/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.CellRenderer;
import EditorTable.DataTable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class ColorCellRenderer
extends CellRenderer {
    final JLabel label = new JLabel();

    public ColorCellRenderer() {
        this.label.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.label.setOpaque(false);
    }

    @Override
    public void draw(DataTable table, int colIndex, int rowIndex, boolean selected) {
        Object value = table.getModel().getValue(colIndex, rowIndex);
        if (!(value instanceof Color)) {
            return;
        }
        this.width = table.getColumnWidth(colIndex) + 1;
        this.height = table.getRowHeight() + 1;
        switch (table.getColumnCellAlignment(colIndex)) {
            case 4: {
                this.label.setHorizontalAlignment(4);
                break;
            }
            case 0: {
                this.label.setHorizontalAlignment(0);
                break;
            }
            default: {
                this.label.setHorizontalAlignment(2);
            }
        }
        this.clear();
        Graphics2D g = this.getGraphicsBuffer(this.width, this.height);
        this.label.setIcon(ColorCellRenderer.genIcon((Color)value));
        if (selected) {
            g.setColor(table.selectedBackcolor);
            g.fillRect(0, 0, this.width, this.height);
        }
        this.label.setSize(this.width, this.height);
        this.label.paint(g);
        if (selected) {
            g.setColor(table.selectedBordercolor);
            if (colIndex == table.getSelectionColStart()) {
                g.drawLine(0, 0, 0, this.height);
            }
            if (colIndex == table.getSelectionColEnd()) {
                g.drawLine(this.width - 1, 0, this.width - 1, this.height);
            }
            if (rowIndex == table.getSelectionRowStart()) {
                g.drawLine(0, 0, this.width, 0);
            }
            if (rowIndex == table.getSelectionRowEnd()) {
                g.drawLine(0, this.height - 1, this.width, this.height - 1);
            }
        }
    }

    static ImageIcon genIcon(Color color) {
        int iconWidth = 15;
        BufferedImage icon = new BufferedImage(iconWidth, iconWidth, 2);
        Graphics2D g2d = icon.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(color);
        g2d.fillRect(0, 0, iconWidth, iconWidth);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, iconWidth - 1, iconWidth - 1);
        return new ImageIcon(icon);
    }

    @Override
    public void setFont(Font font) {
    }
}

