/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.CellRenderer;
import EditorTable.Column;
import EditorTable.DataTable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class ColumnHeaderRenderer
extends CellRenderer {
    final JLabel label = new JLabel();

    public JComponent getRenderer() {
        return this.label;
    }

    public ColumnHeaderRenderer() {
        this.label.setBorder(new EmptyBorder(0, 5, 0, 0));
    }

    public void setBackground(Color color) {
        this.label.setBackground(color);
    }

    public void setForeground(Color color) {
        this.label.setForeground(color);
    }

    @Override
    public void draw(DataTable editor, int colIndex, int rowIndex, boolean selected) {
        Column colHeader = editor.getColumnHeader(colIndex);
        if (colHeader == null) {
            return;
        }
        this.width = colHeader.width;
        this.height = editor.getRowHeight();
        switch (colHeader.getHeaderAlignment()) {
            case 4: {
                this.label.setHorizontalAlignment(4);
                break;
            }
            case 0: {
                this.label.setHorizontalAlignment(0);
                break;
            }
            default: {
                this.label.setHorizontalAlignment(2);
            }
        }
        this.clear();
        this.label.setFont(editor.getFont());
        this.label.setText(String.valueOf(editor.getModel().getColumn(colIndex)));
        this.label.setForeground(editor.columnHeaderForeColor);
        this.label.setBackground(editor.columnHeaderBackColor);
        this.label.setSize(this.width, this.height);
        Graphics2D g2d = this.getGraphicsBuffer(this.width, this.height);
        this.label.paint(g2d);
    }

    @Override
    public void setFont(Font font) {
    }
}

