/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.CellRenderer;
import EditorTable.Column;
import EditorTable.DataTable;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

public abstract class ComponentCellRenderer
extends CellRenderer {
    JComponent renderer;

    public JComponent getRenderer() {
        return this.renderer;
    }

    public ComponentCellRenderer(JComponent comp) {
        this.renderer = comp;
        this.renderer.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    @Override
    public void draw(DataTable table, int colIndex, int rowIndex, boolean selected) {
        Object value = table.getModel().getValue(colIndex, rowIndex);
        if (value == null) {
            return;
        }
        Column colHeader = table.getColumn(colIndex);
        if (colHeader == null) {
            return;
        }
        this.width = table.getColumnWidth(colIndex) + 1;
        this.height = table.getRowHeight() + 1;
        this.clear();
        Graphics2D g = this.getGraphicsBuffer(this.width, this.height);
        this.renderer.setSize(this.width, this.height);
        this.renderer.setFont(table.getFont());
        this.setValue(value, table, colIndex, rowIndex, selected);
        if (selected) {
            this.renderer.setForeground(table.selectedForecolor);
            this.renderer.setBackground(table.selectedBackcolor);
            g.setColor(table.selectedBackcolor);
        } else {
            this.renderer.setForeground(table.forecolor);
            this.renderer.setBackground(table.backcolor);
            g.setColor(table.backcolor);
        }
        g.fillRect(0, 0, this.width, this.height);
        this.renderer.paint(g);
        if (selected) {
            g.setColor(table.selectedBordercolor);
            if (colIndex == table.getSelectionColStart()) {
                g.drawLine(0, 0, 0, this.height);
            }
            if (colIndex == table.getSelectionColEnd()) {
                g.drawLine(this.width - 1, 0, this.width - 1, this.height);
            }
            if (rowIndex == table.getSelectionRowStart()) {
                g.drawLine(0, 0, this.width, 0);
            }
            if (rowIndex == table.getSelectionRowEnd()) {
                g.drawLine(0, this.height - 1, this.width, this.height - 1);
            }
        }
    }

    public abstract void setValue(Object var1, DataTable var2, int var3, int var4, boolean var5);

    @Override
    public void setFont(Font font) {
        this.renderer.setFont(font);
    }
}

