/*
 * Decompiled with CFR 0.152.
 */
package Encoders;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class Ascii85 {
    private static boolean m_UseHeaderFooter = true;
    private static boolean m_UseExtendedCompression = true;
    private static final int ASCII_SHIFT = 33;
    private static final int EIGHT4 = 52200625;
    private static final int EIGHT3 = 614125;
    private static final int EIGHT2 = 7225;
    private static final int[] BASE85_POW = new int[]{1, 85, 7225, 614125, 52200625};
    private static final Pattern REMOVE_WHITESPACE = Pattern.compile("\\s+");
    private static int adjustLen = 0;
    private static int removeLen = 0;

    public static boolean getAddHeaderFooter() {
        return m_UseHeaderFooter;
    }

    public static void setAddHeaderFooter(boolean AddHeaderFooter) {
        m_UseHeaderFooter = AddHeaderFooter;
    }

    public static boolean getUseExtendedCompression() {
        return m_UseExtendedCompression;
    }

    public static void setUseExtendedCompression(boolean UseExtendedCompression) {
        m_UseExtendedCompression = UseExtendedCompression;
    }

    public static String encode(String payload) {
        return Ascii85.encode(payload.getBytes());
    }

    public static String encode(byte[] payload) {
        if (payload == null) {
            return null;
        }
        StringBuilder stringBuff = new StringBuilder(payload.length * 5 / 4);
        byte[] chunk = new byte[4];
        int chunkIndex = 0;
        for (int i = 0; i < payload.length; ++i) {
            byte currByte = payload[i];
            chunk[chunkIndex++] = currByte;
            if (chunkIndex != 4) continue;
            int value = Ascii85.byteToInt(chunk);
            if (value == 0) {
                stringBuff.append('z');
            } else {
                stringBuff.append(Ascii85.encodeChunk(value));
            }
            Arrays.fill(chunk, (byte)0);
            chunkIndex = 0;
        }
        if (chunkIndex > 0) {
            int numPadded = chunk.length - chunkIndex;
            Arrays.fill(chunk, chunkIndex, chunk.length, (byte)0);
            int value = Ascii85.byteToInt(chunk);
            char[] encodedChunk = Ascii85.encodeChunk(value);
            for (int i = 0; i < encodedChunk.length - numPadded; ++i) {
                stringBuff.append(encodedChunk[i]);
            }
        }
        String outString = stringBuff.toString();
        if (m_UseExtendedCompression) {
            outString = Ascii85.compressString(outString);
        }
        if (m_UseHeaderFooter) {
            return "<~" + outString + "~>";
        }
        return outString;
    }

    static String compressString(String inString) {
        inString = inString.replaceAll("!!!!!!!!!!!!!!!!!!!!!!!!!", "v");
        inString = inString.replaceAll("!!!!!", "z");
        inString = inString.replaceAll("!!", "w");
        return inString;
    }

    static String decompressString(String inString) {
        inString = inString.replaceAll("v", "!!!!!!!!!!!!!!!!!!!!!!!!!");
        inString = inString.replaceAll("w", "!!");
        inString = inString.replaceAll("z", "!!!!!");
        return inString;
    }

    private static char[] encodeChunk(int value) {
        long longValue = (long)value & 0xFFFFFFFFL;
        char[] encodedChunk = new char[5];
        for (int i = 0; i < encodedChunk.length; ++i) {
            encodedChunk[i] = (char)(longValue / (long)BASE85_POW[4 - i] + 33L);
            longValue %= (long)BASE85_POW[4 - i];
        }
        return encodedChunk;
    }

    public static byte[] decodeToBytes(byte[] data) {
        return Ascii85.decodeToBytes(new String(data));
    }

    public static byte[] decodeToBytes(String string) {
        String chars = Ascii85.prepString(string);
        if (chars == null) {
            return null;
        }
        int OutLen = chars.length() * 4 / 5;
        byte[] OutBytes = new byte[OutLen];
        int OutIndex = 0;
        byte[] payload = chars.getBytes();
        byte[] chunk = new byte[5];
        byte[] outbytes = new byte[3];
        for (int i = 0; i <= payload.length - 5; i += 5) {
            chunk[0] = payload[i];
            chunk[1] = payload[i + 1];
            chunk[2] = payload[i + 2];
            chunk[3] = payload[i + 3];
            chunk[4] = payload[i + 4];
            outbytes = Ascii85.intToByte((chunk[0] - 33) * 52200625 + (chunk[1] - 33) * 614125 + (chunk[2] - 33) * 7225 + (chunk[3] - 33) * 85 + (chunk[4] - 33));
            OutBytes[OutIndex] = outbytes[0];
            OutBytes[OutIndex + 1] = outbytes[1];
            OutBytes[OutIndex + 2] = outbytes[2];
            OutBytes[OutIndex + 3] = outbytes[3];
            chunk[0] = 0;
            chunk[1] = 0;
            chunk[2] = 0;
            chunk[3] = 0;
            chunk[4] = 0;
            OutIndex += 4;
        }
        return OutBytes;
    }

    public static String decode(byte[] bytes) {
        return Ascii85.decode(new String(bytes, StandardCharsets.UTF_8));
    }

    public static String decode(String string) {
        String chars = Ascii85.prepString(string);
        if (chars == null) {
            return null;
        }
        int OutLen = chars.length() * 4 / 5;
        StringBuilder stringBuff = new StringBuilder(OutLen);
        byte[] payload = chars.getBytes();
        byte[] chunk = new byte[5];
        for (int i = 0; i <= payload.length - 5; i += 5) {
            chunk[0] = payload[i];
            chunk[1] = payload[i + 1];
            chunk[2] = payload[i + 2];
            chunk[3] = payload[i + 3];
            chunk[4] = payload[i + 4];
            byte[] outbytes = Ascii85.intToByte((chunk[0] - 33) * 52200625 + (chunk[1] - 33) * 614125 + (chunk[2] - 33) * 7225 + (chunk[3] - 33) * 85 + (chunk[4] - 33));
            stringBuff.append((char)outbytes[0]);
            stringBuff.append((char)outbytes[1]);
            stringBuff.append((char)outbytes[2]);
            stringBuff.append((char)outbytes[3]);
            chunk[0] = 0;
            chunk[1] = 0;
            chunk[2] = 0;
            chunk[3] = 0;
            chunk[4] = 0;
        }
        return stringBuff.substring(0, OutLen - adjustLen);
    }

    public static String prepString(String chars) {
        if (chars == null) {
            return null;
        }
        chars = REMOVE_WHITESPACE.matcher(chars).replaceAll("");
        boolean bHeader = chars.startsWith("<~");
        boolean bFooter = chars.endsWith("~>");
        if (bHeader && bFooter) {
            if (chars.length() < 5) {
                return null;
            }
            chars = chars.substring(2, chars.length() - 2);
        } else if (bHeader) {
            if (chars.length() < 3) {
                return null;
            }
            chars = chars.substring(2);
        } else if (bFooter) {
            if (chars.length() < 3) {
                return null;
            }
            chars = chars.substring(0, chars.length() - 2);
        }
        chars = Ascii85.decompressString(chars);
        adjustLen = 0;
        int mod = 5 - chars.length() % 5;
        switch (mod) {
            case 1: {
                chars = chars + "u";
                adjustLen = 1;
                break;
            }
            case 2: {
                chars = chars + "uu";
                adjustLen = 2;
                break;
            }
            case 3: {
                chars = chars + "uuu";
                adjustLen = 3;
                break;
            }
            case 4: {
                chars = chars + "uuuu";
                adjustLen = 4;
                break;
            }
            case 0: 
            case 5: {
                removeLen = 0;
            }
        }
        return chars;
    }

    public static short[] decodeToShort(String string) {
        String chars = Ascii85.prepString(string);
        if (chars == null) {
            return null;
        }
        int outLen = chars.length() * 4 / 5 / 2;
        if (adjustLen == 2) {
            --outLen;
        }
        short[] shortBuff = new short[outLen];
        byte[] payload = chars.getBytes();
        byte[] chunk = new byte[5];
        int outIndex = 0;
        for (int i = 0; i <= payload.length - 5; i += 5) {
            chunk[0] = payload[i];
            chunk[1] = payload[i + 1];
            chunk[2] = payload[i + 2];
            chunk[3] = payload[i + 3];
            chunk[4] = payload[i + 4];
            byte[] outbytes = Ascii85.intToByte((chunk[0] - 33) * 52200625 + (chunk[1] - 33) * 614125 + (chunk[2] - 33) * 7225 + (chunk[3] - 33) * 85 + (chunk[4] - 33));
            int b0 = 0xFF & outbytes[0];
            int b1 = 0xFF & outbytes[1];
            int b2 = 0xFF & outbytes[2];
            int b3 = 0xFF & outbytes[3];
            shortBuff[outIndex] = (short)(256 * b0 + b1);
            if (outIndex + 1 < outLen) {
                shortBuff[outIndex + 1] = (short)(256 * b2 + b3);
            }
            chunk[0] = 0;
            chunk[1] = 0;
            chunk[2] = 0;
            chunk[3] = 0;
            chunk[4] = 0;
            outIndex += 2;
        }
        return shortBuff;
    }

    static int byteToInt(byte[] value) {
        if (value == null || value.length != 4) {
            throw new IllegalArgumentException("You cannot create an int without exactly 4 bytes.");
        }
        return ByteBuffer.wrap(value).getInt();
    }

    static byte[] intToByte(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }
}

