/*
 * Decompiled with CFR 0.152.
 */
package Encoders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.PriorityQueue;

public class JHuffman {
    private static final int R = 256;
    private static final char PARENT = '\u0000';
    private static final char EMPTY = '\u0001';
    private static final int UNDEFINED = -1;

    public static String compressString(String s) {
        return Arrays.toString(JHuffman.compress(s));
    }

    public static byte[] compress(String s) {
        HuffmanOut binaryOut = new HuffmanOut();
        char[] input = s.toCharArray();
        int[] freq = new int[256];
        char[] cArray = input;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char anInput1;
            char c = anInput1 = cArray[i];
            freq[c] = freq[c] + 1;
        }
        Node root = JHuffman.buildTrie(freq);
        String[] st = new String[256];
        JHuffman.buildCode(st, root, "");
        JHuffman.writeTrie(root, binaryOut);
        binaryOut.write(input.length);
        for (char anInput : input) {
            String code = st[anInput];
            for (char ch : code.toCharArray()) {
                binaryOut.writeBit(ch == '1');
            }
        }
        return binaryOut.value();
    }

    private static Node buildTrie(int[] freq) {
        PriorityQueue<Node> pq2 = new PriorityQueue<Node>();
        for (char i = '\u0000'; i < '\u0100'; i = (char)((char)(i + 1))) {
            if (freq[i] <= 0) continue;
            pq2.add(new Node(i, freq[i], null, null));
        }
        if (pq2.size() == 1) {
            if (freq[0] == 0) {
                pq2.add(new Node('\u0000', 0, null, null));
            } else {
                pq2.add(new Node('\u0001', 0, null, null));
            }
        } else {
            while (pq2.size() > 1) {
                Node left = (Node)pq2.poll();
                Node right = (Node)pq2.poll();
                Node parent = new Node('\u0000', left.freq + right.freq, left, right);
                pq2.add(parent);
            }
        }
        return (Node)pq2.poll();
    }

    private static void writeTrie(Node x, HuffmanOut binaryOut) {
        if (x.isLeaf()) {
            binaryOut.writeBit(true);
            binaryOut.writeByte(x.ch);
        } else {
            binaryOut.writeBit(false);
            JHuffman.writeTrie(x.left, binaryOut);
            JHuffman.writeTrie(x.right, binaryOut);
        }
    }

    private static void buildCode(String[] st, Node x, String s) {
        if (!x.isLeaf()) {
            JHuffman.buildCode(st, x.left, s + '0');
            JHuffman.buildCode(st, x.right, s + '1');
        } else {
            st[((Node)x).ch] = s;
        }
    }

    public static String decompress(String codedString) {
        return JHuffman.decompress(codedString.getBytes());
    }

    public static String decompress(byte[] value) {
        HuffmanIn binaryIn;
        System.err.println(value[0] + "," + value[1] + "," + value[2] + "," + value[3] + "," + value[4] + "," + value[5] + "," + value[6] + "," + value[7]);
        if (value[0] == 72 & value[1] == 69 & value[2] == 51 & value[3] == 13) {
            byte[] newValue = new byte[value.length - 4];
            System.arraycopy(value, 4, newValue, 0, value.length - 4);
            binaryIn = new HuffmanIn(newValue);
        } else {
            binaryIn = new HuffmanIn(value);
        }
        StringBuilder out = new StringBuilder();
        Node root = JHuffman.readTrie(binaryIn);
        int length = binaryIn.readInt();
        for (int i = 0; i < length; ++i) {
            Node x = root;
            while (!x.isLeaf()) {
                boolean bit = binaryIn.readBoolean();
                if (bit) {
                    x = x.right;
                    continue;
                }
                x = x.left;
            }
            out.append(x.ch);
        }
        return out.toString();
    }

    private static Node readTrie(HuffmanIn binaryIn) {
        boolean isLeaf = binaryIn.readBoolean();
        if (isLeaf) {
            char ch = binaryIn.readChar();
            return new Node(ch, -1, null, null);
        }
        return new Node('\u0000', -1, JHuffman.readTrie(binaryIn), JHuffman.readTrie(binaryIn));
    }

    private static class HuffmanOut {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private int buffer;
        private byte n;

        private HuffmanOut() {
        }

        public byte[] value() {
            this.clearBuffer();
            return this.out.toByteArray();
        }

        void writeBit(boolean bit) {
            this.buffer <<= 1;
            this.buffer |= bit ? 1 : 0;
            this.n = (byte)(this.n + 1);
            if (this.n == 8) {
                this.clearBuffer();
            }
        }

        void writeByte(int x) {
            for (int i = 0; i < 8; ++i) {
                this.writeBit((x >>> 8 - i - 1 & 1) == 1);
            }
        }

        void clearBuffer() {
            if (this.n != 0) {
                this.out.write(this.buffer <<= 8 - this.n);
                this.n = 0;
                this.buffer = 0;
            }
        }

        void write(int x) {
            for (int i = 3; i >= 0; --i) {
                this.writeByte(x >>> i * 8 & 0xFF);
            }
        }
    }

    private static class Node
    implements Comparable<Node> {
        private final char ch;
        private final int freq;
        private final Node left;
        private final Node right;

        Node(char ch, int freq, Node left, Node right) {
            this.ch = ch;
            this.freq = freq;
            this.left = left;
            this.right = right;
        }

        private boolean isLeaf() {
            return this.left == null && this.right == null;
        }

        @Override
        public int compareTo(Node that) {
            return this.freq - that.freq;
        }
    }

    private static class HuffmanIn {
        private final ByteArrayInputStream in;
        private int buffer;
        private byte n;

        HuffmanIn(byte[] input) {
            this.in = new ByteArrayInputStream(input);
            this.fillBuffer();
        }

        private void fillBuffer() {
            this.buffer = this.in.read();
            this.n = (byte)8;
        }

        boolean readBoolean() {
            boolean bit;
            this.n = (byte)(this.n - 1);
            boolean bl = bit = (this.buffer >> this.n & 1) == 1;
            if (this.n == 0) {
                this.fillBuffer();
            }
            return bit;
        }

        char readChar() {
            int x = this.buffer <<= 8 - this.n;
            if (this.n == 8) {
                this.fillBuffer();
            } else {
                byte oldN = this.n;
                this.fillBuffer();
                this.n = oldN;
                x |= this.buffer >>> this.n;
            }
            return (char)(x & 0xFF);
        }

        int readInt() {
            int x = 0;
            for (int i = 0; i < 4; ++i) {
                char c = this.readChar();
                x <<= 8;
                x |= c;
            }
            return x;
        }
    }
}

