/*
 * Decompiled with CFR 0.152.
 */
package Encoders;

import BitString.BitString;
import Encoders.ProgressListener;
import MiscTools.FileTools;
import java.io.File;
import java.nio.charset.StandardCharsets;

public class mHuffman {
    private static ProgressListener listener = null;
    private static boolean success = false;
    private static final int DEFNODECOUNT = 256;
    private static int treeHeaderLen = 0;
    private static byte CheckSum = 0;
    private static int inLength = 0;
    private static Node RootNode = new Node();
    private static int LastNodeIndex;
    private static short LeafCount;
    private static Node[] Nodes;
    private static Node[] readNodes;
    private static int EncodedBits;
    private static int EncodedBytes;
    private static char[] dataChars;
    private static BitString bitString;
    private static BitString OutBuffer;
    private static String mError;
    static float length;
    static float value;
    private static int prog;

    public static String getError() {
        return mError;
    }

    public static void setListener(ProgressListener huffmanListener) {
        listener = huffmanListener;
    }

    public static byte[] encode(String data) {
        mHuffman.Reset();
        dataChars = data.toCharArray();
        byte[] outVal = mHuffman.encodeString();
        if (listener != null) {
            listener.encodeCompleted(success);
        }
        return outVal;
    }

    public static byte[] encode(char[] data) {
        mHuffman.Reset();
        dataChars = data;
        byte[] outVal = mHuffman.encodeString();
        if (listener != null) {
            listener.encodeCompleted(success);
        }
        return outVal;
    }

    public static byte[] encode(File file) {
        char[] chars = FileTools.getFileChars(file);
        if (chars == null) {
            mError = FileTools.getError();
            if (listener != null) {
                listener.encodeCompleted(false);
            }
            return null;
        }
        byte[] outVal = mHuffman.encode(chars);
        return outVal;
    }

    public static String encodeToString(String data) {
        byte[] outBytes = mHuffman.encode(data);
        return new String(outBytes, StandardCharsets.UTF_8);
    }

    public static String encodeToString(char[] data) {
        byte[] outBytes = mHuffman.encode(data);
        return new String(outBytes, StandardCharsets.UTF_8);
    }

    public static String encodeToString(File file) {
        byte[] outBytes = mHuffman.encode(file);
        return new String(outBytes, StandardCharsets.UTF_8);
    }

    public static String decodeToString(byte[] data) {
        byte[] outBytes = mHuffman.decode(data);
        return new String(outBytes, StandardCharsets.UTF_8);
    }

    public static String decodeToString(String data) {
        byte[] outBytes = mHuffman.decode(data);
        return new String(outBytes, StandardCharsets.UTF_8);
    }

    public static byte[] decode(String data) {
        byte[] outVal;
        mHuffman.Reset();
        bitString = new BitString(data);
        if (listener != null) {
            outVal = mHuffman.decodeStringWithListener();
            listener.decodeCompleted(success);
        } else {
            outVal = mHuffman.decodeString();
        }
        return outVal;
    }

    public static byte[] decode(byte[] data) {
        byte[] outVal;
        mHuffman.Reset();
        bitString = new BitString(data);
        if (listener != null) {
            outVal = mHuffman.decodeStringWithListener();
            listener.decodeCompleted(success);
        } else {
            outVal = mHuffman.decodeString();
        }
        return outVal;
    }

    private static void Reset() {
        dataChars = null;
        treeHeaderLen = 0;
        EncodedBits = 0;
        EncodedBytes = 0;
        OutBuffer = new BitString();
        LastNodeIndex = 255;
        Nodes = new Node[256];
        readNodes = new Node[256];
        RootNode = new Node();
        mHuffman.RootNode.root = true;
    }

    private static void WriteHeader() {
        OutBuffer.setChar('H');
        OutBuffer.setChar('E');
        OutBuffer.setChar('3');
        OutBuffer.setByte((byte)13);
        OutBuffer.setByte(CheckSum);
        OutBuffer.setInt(inLength);
        OutBuffer.setShort(LeafCount);
        for (int x = 0; x < 256; ++x) {
            if (mHuffman.readNodes[x].freq <= 0) continue;
            OutBuffer.setChar(mHuffman.readNodes[x].Char);
            OutBuffer.setChar((char)mHuffman.readNodes[x].Prefix.length);
        }
    }

    private static void WriteTree() {
        for (int x = 0; x < readNodes.length; ++x) {
            if (mHuffman.readNodes[x].freq <= 0) continue;
            for (int y = 0; y < mHuffman.readNodes[x].Prefix.length; ++y) {
                OutBuffer.setBit(mHuffman.readNodes[x].Prefix[y]);
            }
        }
        if (OutBuffer.bitIndex() != 0) {
            OutBuffer.goToNextByte();
        }
    }

    private static void WriteData() {
        if (listener == null) {
            for (int x = 0; x < dataChars.length; ++x) {
                for (int y = 0; y < mHuffman.readNodes[mHuffman.dataChars[x]].Prefix.length; ++y) {
                    OutBuffer.setBit(mHuffman.readNodes[mHuffman.dataChars[x]].Prefix[y]);
                }
            }
        } else {
            for (int x = 0; x < dataChars.length; ++x) {
                for (int y = 0; y < mHuffman.readNodes[mHuffman.dataChars[x]].Prefix.length; ++y) {
                    OutBuffer.setBit(mHuffman.readNodes[mHuffman.dataChars[x]].Prefix[y]);
                }
                mHuffman.valueChanged(x);
            }
        }
    }

    private static void lengthChanged(int newValue) {
        prog = 0;
        value = 0.0f;
        length = newValue;
        listener.lengthChanged(newValue);
    }

    private static void valueChanged(int newValue) {
        value = newValue;
        int progress = (int)(value / length * 100.0f);
        if (progress != prog) {
            prog = progress;
            listener.valueChanged(prog);
        }
    }

    private static byte[] decodeStringWithListener() {
        Node newNode;
        listener.decodeStarted();
        inLength = bitString.length();
        if (inLength < 11) {
            return new byte[0];
        }
        if (bitString.getChar() != 'H' | bitString.getChar() != 'E' | bitString.getChar() != '3' | bitString.getChar() != '\r') {
            return new byte[0];
        }
        CheckSum = bitString.getByte();
        EncodedBytes = bitString.getInt();
        LeafCount = bitString.getShort();
        if (LeafCount == 0) {
            return new byte[0];
        }
        Nodes = new Node[LeafCount];
        int bitCount = 0;
        int byteCount = 0;
        for (int x = 0; x < LeafCount; ++x) {
            char inChar = bitString.getChar();
            char pLen = bitString.getChar();
            bitCount += pLen;
            mHuffman.Nodes[x] = newNode = new Node();
            mHuffman.Nodes[x].Char = inChar;
            mHuffman.Nodes[x].Prefix = new byte[pLen];
            mHuffman.Nodes[x].leaf = true;
            mHuffman.readNodes[inChar] = newNode;
        }
        byteCount = bitCount % 8 == 0 ? bitCount / 8 : bitCount / 8 + 1;
        for (int x = 0; x < LeafCount; ++x) {
            Node curNode = RootNode;
            for (int y = 0; y < mHuffman.Nodes[x].Prefix.length; ++y) {
                mHuffman.Nodes[x].Prefix[y] = bitString.getBit();
                if (y == mHuffman.Nodes[x].Prefix.length - 1) {
                    if (mHuffman.Nodes[x].Prefix[y] == 0) {
                        curNode.left = Nodes[x];
                        continue;
                    }
                    curNode.right = Nodes[x];
                    continue;
                }
                if (mHuffman.Nodes[x].Prefix[y] == 0) {
                    if (curNode.left == null) {
                        curNode.left = newNode = new Node();
                    }
                    curNode = curNode.left;
                    continue;
                }
                if (curNode.right == null) {
                    curNode.right = newNode = new Node();
                }
                curNode = curNode.right;
            }
        }
        Node curNode = RootNode;
        int ResultLen = 0;
        BitString OutString = new BitString();
        if (bitString.bitIndex() != 0) {
            bitString.goToNextByte();
        }
        while (ResultLen < EncodedBytes) {
            byte newBit = bitString.getBit();
            curNode = newBit == 0 ? curNode.left : curNode.right;
            if (curNode == null) {
                return new byte[0];
            }
            if (!curNode.leaf) continue;
            OutString.setChar(curNode.Char);
            mHuffman.valueChanged(++ResultLen);
            curNode = RootNode;
        }
        success = true;
        return OutString.getBytes(0, EncodedBytes);
    }

    private static byte[] decodeString() {
        Node newNode;
        inLength = bitString.length();
        if (inLength < 11) {
            return new byte[0];
        }
        if (bitString.getChar() != 'H' | bitString.getChar() != 'E' | bitString.getChar() != '3' | bitString.getChar() != '\r') {
            return new byte[0];
        }
        CheckSum = bitString.getByte();
        EncodedBytes = bitString.getInt();
        LeafCount = bitString.getShort();
        if (LeafCount == 0) {
            return new byte[0];
        }
        Nodes = new Node[LeafCount];
        int bitCount = 0;
        int byteCount = 0;
        for (int x = 0; x < LeafCount; ++x) {
            char inChar = bitString.getChar();
            char pLen = bitString.getChar();
            bitCount += pLen;
            mHuffman.Nodes[x] = newNode = new Node();
            mHuffman.Nodes[x].Char = inChar;
            mHuffman.Nodes[x].Prefix = new byte[pLen];
            mHuffman.Nodes[x].leaf = true;
            mHuffman.readNodes[inChar] = newNode;
        }
        byteCount = bitCount % 8 == 0 ? bitCount / 8 : bitCount / 8 + 1;
        for (int x = 0; x < LeafCount; ++x) {
            Node curNode = RootNode;
            for (int y = 0; y < mHuffman.Nodes[x].Prefix.length; ++y) {
                mHuffman.Nodes[x].Prefix[y] = bitString.getBit();
                if (y == mHuffman.Nodes[x].Prefix.length - 1) {
                    if (mHuffman.Nodes[x].Prefix[y] == 0) {
                        curNode.left = Nodes[x];
                        continue;
                    }
                    curNode.right = Nodes[x];
                    continue;
                }
                if (mHuffman.Nodes[x].Prefix[y] == 0) {
                    if (curNode.left == null) {
                        curNode.left = newNode = new Node();
                    }
                    curNode = curNode.left;
                    continue;
                }
                if (curNode.right == null) {
                    curNode.right = newNode = new Node();
                }
                curNode = curNode.right;
            }
        }
        Node curNode = RootNode;
        int ResultLen = 0;
        BitString OutString = new BitString();
        if (bitString.bitIndex() != 0) {
            bitString.goToNextByte();
        }
        while (ResultLen < EncodedBytes) {
            byte newBit = bitString.getBit();
            Node node = curNode = newBit == 0 ? curNode.left : curNode.right;
            if (curNode == null) {
                return new byte[0];
            }
            if (!curNode.leaf) continue;
            OutString.setChar(curNode.Char);
            ++ResultLen;
            curNode = RootNode;
        }
        success = true;
        return OutString.getBytes(0, EncodedBytes);
    }

    private static byte[] encodeString() {
        int x;
        success = false;
        inLength = dataChars.length;
        if (inLength == 0) {
            return new byte[0];
        }
        if (listener != null) {
            listener.encodeStarted();
            mHuffman.lengthChanged(inLength);
        }
        for (x = 0; x < 256; ++x) {
            Node newNode;
            mHuffman.Nodes[x] = newNode = new Node();
            mHuffman.readNodes[x] = newNode;
            mHuffman.Nodes[x].Char = (char)x;
            mHuffman.Nodes[x].leaf = true;
        }
        for (x = 0; x < inLength; ++x) {
            try {
                ++mHuffman.Nodes[mHuffman.dataChars[x]].freq;
                continue;
            }
            catch (Exception e) {
                mError = e.getMessage();
                return null;
            }
        }
        mHuffman.SortNodes();
        LastNodeIndex = -1;
        for (x = 0; x < 256 && mHuffman.Nodes[x].freq != 0; ++x) {
            ++LastNodeIndex;
        }
        if (LastNodeIndex == -1) {
            return new byte[0];
        }
        Node[] tmpNodes = new Node[LastNodeIndex + 1];
        System.arraycopy(Nodes, 0, tmpNodes, 0, LastNodeIndex + 1);
        Nodes = tmpNodes;
        tmpNodes = null;
        LeafCount = (short)(LastNodeIndex + 1);
        while (LastNodeIndex > 1) {
            mHuffman.SortNodes();
            Node tmpNode = new Node();
            tmpNode.left = Nodes[LastNodeIndex - 1];
            tmpNode.right = Nodes[LastNodeIndex];
            tmpNode.freq = tmpNode.left.freq + tmpNode.right.freq;
            mHuffman.Nodes[mHuffman.LastNodeIndex - 1] = tmpNode;
            mHuffman.Nodes[mHuffman.LastNodeIndex] = null;
            --LastNodeIndex;
        }
        mHuffman.SortNodes();
        mHuffman.RootNode.left = Nodes[0];
        mHuffman.RootNode.right = Nodes[1];
        mHuffman.RootNode.freq = mHuffman.RootNode.left.freq + mHuffman.RootNode.right.freq;
        mHuffman.AnnotateChildren(RootNode);
        EncodedBytes = EncodedBits % 8 == 0 ? EncodedBits / 8 : EncodedBits / 8 + 1;
        CheckSum = mHuffman.getCheckSum(dataChars);
        OutBuffer = new BitString(inLength);
        mHuffman.WriteHeader();
        mHuffman.WriteTree();
        mHuffman.WriteData();
        success = true;
        return OutBuffer.getBytes();
    }

    private static byte getCheckSum(char[] ByteArray) {
        byte cs = 0;
        for (int x = 0; x < ByteArray.length; ++x) {
            cs = (byte)(cs ^ ByteArray[x]);
        }
        return cs;
    }

    private static void SortNodes() {
        for (int x = 0; x <= LastNodeIndex - 1; ++x) {
            int highestIndex = x;
            for (int y = x + 1; y <= LastNodeIndex; ++y) {
                if (mHuffman.Nodes[y].freq <= mHuffman.Nodes[highestIndex].freq) continue;
                highestIndex = y;
            }
            if (highestIndex == x) continue;
            Node tmpNode = Nodes[x];
            mHuffman.Nodes[x] = Nodes[highestIndex];
            mHuffman.Nodes[highestIndex] = tmpNode;
        }
    }

    static void AnnotateChildren(Node node) {
        if (!node.leaf & !node.root) {
            if (node.left != null) {
                node.left.Prefix = new byte[node.Prefix.length + 1];
                System.arraycopy(node.Prefix, 0, node.left.Prefix, 0, node.Prefix.length);
                mHuffman.AnnotateChildren(node.left);
            }
            if (node.right != null) {
                node.right.Prefix = new byte[node.Prefix.length + 1];
                System.arraycopy(node.Prefix, 0, node.right.Prefix, 0, node.Prefix.length);
                node.right.Prefix[node.Prefix.length] = 1;
                mHuffman.AnnotateChildren(node.right);
            }
        } else if (node.leaf) {
            EncodedBits += node.Prefix.length * node.freq;
            treeHeaderLen += node.Prefix.length;
        } else if (node.root) {
            if (node.left != null) {
                node.left.Prefix = new byte[1];
                mHuffman.AnnotateChildren(node.left);
            }
            if (node.right != null) {
                node.right.Prefix = new byte[1];
                node.right.Prefix[0] = 1;
                mHuffman.AnnotateChildren(node.right);
            }
        }
    }

    static {
        LeafCount = 0;
        EncodedBits = 0;
        EncodedBytes = 0;
        mError = "";
        length = 0.0f;
        value = 0.0f;
        prog = 0;
    }

    private static class Node {
        public byte[] Prefix;
        public Node left;
        public Node right;
        public char Char;
        public boolean leaf = false;
        public boolean root = false;
        public int freq;
    }
}

