/*
 * Decompiled with CFR 0.152.
 */
package FastQReader;

import FastQReader.FastQBaseData;
import Sequences.DNA;

public class FastQEntry
extends FastQBaseData {
    protected transient String instrumentName = null;
    protected transient String runID = null;
    protected transient String flowcellID = null;
    protected transient int pairNumber = 0;
    protected transient boolean filtered = false;
    protected transient boolean controlBitsOn = false;
    protected transient String indexSequence = null;

    public String getInstrumentName() {
        return this.instrumentName;
    }

    public void setInstrumentName(String instrumentName) {
        this.instrumentName = instrumentName;
    }

    public String getRunID() {
        return this.runID;
    }

    public String getFlowcellID() {
        return this.flowcellID;
    }

    public int getPairNumber() {
        return this.pairNumber;
    }

    public void setPairNumber(int pairNumber) {
        this.pairNumber = pairNumber;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isControlbitson() {
        return this.controlBitsOn;
    }

    public void setControlbitson(boolean controlbitson) {
        this.controlBitsOn = controlbitson;
    }

    public String getIndexSequence() {
        return this.indexSequence;
    }

    public void setIndexSequence(String indexSequence) {
        this.indexSequence = indexSequence;
    }

    public FastQEntry(int tileID, int x, int y) {
        super(tileID, x, y);
    }

    public FastQEntry(String infoLine, String sequenceLine, String scoreLine) {
        this.sequence = sequenceLine;
        this.quality = scoreLine;
        FastQEntry.parseEntryDescriptor(this, infoLine);
    }

    public FastQEntry() {
    }

    public String getFilteredSequence(int qCutoff) {
        return FastQEntry.getFilteredSequence(this, qCutoff);
    }

    public void complement() {
        FastQEntry.pComplementEntry(this);
    }

    private static String getFilteredSequence(FastQEntry entry, int qCutoff) {
        int x;
        int firstGood = -1;
        int lastGood = -1;
        qCutoff += 32;
        for (x = 0; x < entry.sequence.length(); ++x) {
            if (entry.quality.charAt(x) <= qCutoff) continue;
            firstGood = x;
            break;
        }
        for (x = entry.sequence.length() - 1; x >= 0; --x) {
            if (entry.quality.charAt(x) <= qCutoff) continue;
            lastGood = x;
            break;
        }
        if (firstGood >= lastGood) {
            return "";
        }
        return entry.sequence.substring(firstGood, lastGood + 1);
    }

    private static void parseEntryDescriptor(FastQEntry entry, String descriptor) {
        if (descriptor == null || descriptor.length() == 0) {
            return;
        }
        String[] headerParts = descriptor.split(":");
        if (headerParts.length > 0) {
            entry.instrumentName = headerParts[0];
            if (headerParts.length > 1) {
                entry.runID = headerParts[1];
                if (headerParts.length > 2) {
                    entry.flowcellID = headerParts[2];
                    if (headerParts.length > 4) {
                        String tileNumber = headerParts[4];
                        entry.tileID = Integer.parseInt(tileNumber);
                        if (headerParts.length > 5) {
                            String x_coordinate = headerParts[5];
                            entry.x = Integer.parseInt(x_coordinate);
                        }
                        if (headerParts.length > 6) {
                            String y_coordinate = "";
                            if (headerParts[6].endsWith(" 1")) {
                                y_coordinate = headerParts[6].substring(0, headerParts[6].length() - 2);
                                entry.pairNumber = 1;
                            } else if (headerParts[6].endsWith(" 2")) {
                                y_coordinate = headerParts[6].substring(0, headerParts[6].length() - 2);
                                entry.pairNumber = 2;
                            } else {
                                y_coordinate = headerParts[6];
                                entry.pairNumber = 0;
                            }
                            entry.y = Integer.parseInt(y_coordinate);
                            if (headerParts.length > 7) {
                                entry.filtered = headerParts[7].equals("Y");
                                if (headerParts.length > 8) {
                                    entry.controlBitsOn = headerParts[8].equals("0");
                                    if (headerParts.length > 9) {
                                        entry.indexSequence = headerParts[9];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void pComplementEntry(FastQEntry entry) {
        entry.quality = FastQEntry.reverseString(entry.quality);
        entry.sequence = DNA.getAntisense(entry.sequence);
    }

    private static String reverseString(String sequence) {
        char[] tmp = sequence.toCharArray();
        int right = tmp.length - 1;
        for (int left = 0; left <= right; ++left, --right) {
            char tempChar = tmp[left];
            tmp[left] = tmp[right];
            tmp[right] = tempChar;
        }
        return new String(tmp);
    }
}

