/*
 * Decompiled with CFR 0.152.
 */
package FastQReader;

import FastQReader.FastQEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FastQFileReader
implements Iterable<FastQEntry> {
    Scanner scanner;
    private long bytesRead = 0L;
    private long fileLen = 0L;

    public void close() {
        if (this.scanner != null) {
            this.scanner.close();
        }
    }

    public FastQFileReader(File file) {
        try {
            this.scanner = new Scanner(file);
            this.fileLen = file.length();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FastQFileReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public int getPercentRead() {
        return (int)((double)this.bytesRead / (double)this.fileLen * 100.0);
    }

    public FastQEntry getNext() {
        if (!this.scanner.hasNextLine()) {
            return null;
        }
        String infoLine = this.scanner.nextLine();
        if (infoLine == null || !infoLine.startsWith("@") || !this.scanner.hasNextLine()) {
            return null;
        }
        this.bytesRead += (long)infoLine.length();
        String sequenceLine = this.scanner.nextLine();
        if (sequenceLine == null || !this.scanner.hasNextLine()) {
            return null;
        }
        this.bytesRead += (long)sequenceLine.length();
        String plusLine = this.scanner.nextLine();
        if (plusLine == null || !plusLine.equals("+") || !this.scanner.hasNextLine()) {
            return null;
        }
        this.bytesRead += (long)plusLine.length();
        String scoreLine = this.scanner.nextLine();
        if (scoreLine == null) {
            return null;
        }
        this.bytesRead += (long)scoreLine.length();
        return new FastQEntry(infoLine, sequenceLine, scoreLine);
    }

    public boolean hasNext() {
        return this.scanner != null && this.scanner.hasNextLine();
    }

    @Override
    public Iterator<FastQEntry> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<FastQEntry> {
        @Override
        public boolean hasNext() {
            return this.hasNext();
        }

        @Override
        public FastQEntry next() {
            return FastQFileReader.this.getNext();
        }

        @Override
        public void remove() {
        }

        @Override
        public void forEachRemaining(Consumer<? super FastQEntry> action) {
            Objects.requireNonNull(action);
            FastQEntry entry = FastQFileReader.this.getNext();
            while (entry != null) {
                action.accept(entry);
            }
        }
    }
}

