/*
 * Decompiled with CFR 0.152.
 */
package FileChooserDialogs;

import java.io.File;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;

class FileTableModel
extends AbstractTableModel {
    private File[] files;
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private String[] columns = new String[]{"Icon", "File", "Path/name", "Size", "Last Modified", "R", "W", "E", "D", "F"};

    FileTableModel() {
        this(new File[0]);
    }

    FileTableModel(File[] files) {
        this.files = files;
    }

    @Override
    public Object getValueAt(int row, int column) {
        File file = this.files[row];
        switch (column) {
            case 0: {
                return this.fileSystemView.getSystemIcon(file);
            }
            case 1: {
                return this.fileSystemView.getSystemDisplayName(file);
            }
            case 2: {
                return file.getPath();
            }
            case 3: {
                return file.length();
            }
            case 4: {
                return file.lastModified();
            }
            case 5: {
                return file.canRead();
            }
            case 6: {
                return file.canWrite();
            }
            case 7: {
                return file.canExecute();
            }
            case 8: {
                return file.isDirectory();
            }
            case 9: {
                return file.isFile();
            }
        }
        System.err.println("Logic Error");
        return "";
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return ImageIcon.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return Date.class;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public int getRowCount() {
        return this.files.length;
    }

    public File getFile(int row) {
        return this.files[row];
    }

    public void setFiles(File[] files) {
        this.files = files;
        this.fireTableDataChanged();
    }
}

