/*
 * Decompiled with CFR 0.152.
 */
package FileMaker;

import FileMaker.FileMakerItem;
import FileMaker.TOCHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileMaker {
    public static final short VBBYTE = 17;
    public static final short VBINTEGER = 2;
    public static final short VBLONG = 3;
    public static final short VBSINGLE = 4;
    public static final short VBSTRING = 8;
    private FileMakerItem SelectedItem;
    private static final String FILEMMAKER2ID = "\u0000Fmkr\u0000";
    public static final int TOCTAG = -1;
    public static final int HEADERSIZE = 22;
    private RandomAccessFile inStream;
    private OutputStream outStream;
    private boolean inOpened = false;
    private boolean outOpened = false;
    private String mFileID = "FMKr";
    private int FileMakerVer = 0;
    private TOCHeader TOC = new TOCHeader();
    private String mError = "";

    public String getError() {
        return this.mError;
    }

    public void setFileID(String fileID) {
        this.mFileID = fileID;
    }

    public String getFileID() {
        return this.mFileID;
    }

    public int getFileVersion() {
        return this.FileMakerVer;
    }

    public FileMaker() {
    }

    public FileMaker(String appHeader) {
        this.mFileID = appHeader;
    }

    private void clear() {
        this.close();
        this.mError = "";
    }

    public boolean LoadFile(File file) {
        this.clear();
        if (!file.isFile() || !file.exists()) {
            this.mError = "Invalid file selected";
            return false;
        }
        try {
            this.inStream = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ex) {
            this.mError = "Error opening file stream.";
            return false;
        }
        try {
            byte[] headerbytes = FILEMMAKER2ID.getBytes();
            this.inStream.read(headerbytes);
            String fHeader = new String(headerbytes);
            if (FILEMMAKER2ID.equals(fHeader)) {
                this.FileMakerVer = 2;
                short fileIDLen = Short.reverseBytes(this.inStream.readShort());
                if (fileIDLen != this.mFileID.length() + 1) {
                    this.mError = "App header length not what was expected.  Got " + this.mFileID.length() + ", expected " + fileIDLen;
                    return false;
                }
                headerbytes = this.mFileID.getBytes();
                this.inStream.read(headerbytes);
                String appHeader = new String(headerbytes);
                if (!appHeader.equals(this.mFileID)) {
                    this.mError = "Unexpected header or invalid file format";
                    return false;
                }
            } else {
                this.inStream.seek(0L);
                headerbytes = this.mFileID.getBytes();
                this.inStream.read(headerbytes);
                fHeader = new String(headerbytes);
                if (!this.mFileID.equals(fHeader)) {
                    this.mError = "App header not found.  Found: " + fHeader + "(" + headerbytes.length + "), Expected: " + this.mFileID + "(" + this.mFileID.length() + ")";
                    return false;
                }
                this.FileMakerVer = 1;
            }
        }
        catch (IOException ex) {
            this.mError = "IOException: " + ex.getMessage();
            this.close();
            return false;
        }
        try {
            this.inStream.readByte();
            this.TOC.TagName = Integer.reverseBytes(this.inStream.readInt());
            if (this.TOC.TagName != -1) {
                this.mError = "Inconsistent header";
                return false;
            }
            this.TOC.Version = Short.reverseBytes(this.inStream.readShort());
            this.TOC.EntrySize = Integer.reverseBytes(this.inStream.readInt());
            this.TOC.Counts = Integer.reverseBytes(this.inStream.readInt());
            this.TOC.DataOffset = Integer.reverseBytes(this.inStream.readInt());
            this.inStream.seek(this.TOC.DataOffset - 1);
            for (int x = 0; x < this.TOC.Counts; ++x) {
                FileMakerItem newItem = new FileMakerItem();
                newItem.tagName = Integer.reverseBytes(this.inStream.readInt());
                newItem.tagNum = Integer.reverseBytes(this.inStream.readInt());
                newItem.version = Short.reverseBytes(this.inStream.readShort());
                newItem.counts = Integer.reverseBytes(this.inStream.readInt());
                newItem.userDef = Integer.reverseBytes(this.inStream.readInt());
                newItem.dataOffset = Integer.reverseBytes(this.inStream.readInt());
                this.TOC.Items.add(newItem);
            }
            for (int x = 0; x < this.TOC.Counts; ++x) {
                FileMakerItem currentItem = this.TOC.Items.get(x);
                if (currentItem.counts <= 0) continue;
                block15: for (int tmpCounts = currentItem.counts; tmpCounts > 0; --tmpCounts) {
                    long curPos = this.inStream.getFilePointer();
                    short vType = Short.reverseBytes(this.inStream.readShort());
                    int byteCount = Integer.reverseBytes(this.inStream.readInt());
                    switch (vType) {
                        case 17: {
                            if (byteCount <= 0) continue block15;
                            currentItem.bytes = new byte[byteCount];
                            this.inStream.read(currentItem.bytes);
                            continue block15;
                        }
                        case 2: {
                            int intCount = byteCount / 2;
                            if (intCount <= -1) continue block15;
                            currentItem.integers = new short[intCount];
                            for (int intEntry = 0; intEntry < intCount; ++intEntry) {
                                currentItem.integers[intEntry] = Short.reverseBytes(this.inStream.readShort());
                            }
                            continue block15;
                        }
                        case 3: {
                            int longCount = byteCount / 4;
                            if (longCount <= -1) continue block15;
                            currentItem.longs = new int[longCount];
                            for (int intEntry = 0; intEntry < longCount; ++intEntry) {
                                currentItem.longs[intEntry] = Integer.reverseBytes(this.inStream.readInt());
                            }
                            continue block15;
                        }
                        case 4: {
                            int singleCount = byteCount / 4;
                            if (singleCount <= -1) continue block15;
                            currentItem.singles = new float[singleCount];
                            for (int intEntry = 0; intEntry < singleCount; ++intEntry) {
                                currentItem.singles[intEntry] = Integer.reverseBytes(this.inStream.readInt());
                            }
                            continue block15;
                        }
                        case 8: {
                            if (byteCount <= 0) continue block15;
                            byte[] b = new byte[byteCount];
                            this.inStream.read(b);
                            currentItem.strings.add(b);
                            continue block15;
                        }
                        default: {
                            this.mError = "Unrecognized data type: " + vType + " at position " + curPos;
                            System.err.println(this.mError);
                            this.close();
                            return false;
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FileMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.close();
        return true;
    }

    public int EntryCount() {
        return this.TOC.Items.size();
    }

    public FileMakerItem getEntry(int EntryIndex) {
        if (EntryIndex >= this.TOC.Items.size() | EntryIndex < 0) {
            return null;
        }
        return this.TOC.Items.get(EntryIndex);
    }

    public int addEntry(int TagName) {
        this.SelectedItem = new FileMakerItem(TagName);
        this.TOC.Items.add(this.SelectedItem);
        return this.TOC.Items.size() - 1;
    }

    public boolean setEntryIndex(int EntryIndex) {
        if (EntryIndex < 0 | EntryIndex >= this.TOC.Items.size()) {
            return false;
        }
        this.SelectedItem = this.TOC.Items.get(EntryIndex);
        return true;
    }

    public void close() {
        if (this.inStream != null && this.inOpened) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inStream = null;
        } else if (this.outStream != null && this.outOpened) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outStream = null;
        }
    }

    public boolean appendData(byte data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addByte(data);
        return true;
    }

    public boolean appendData(byte[] data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addByte(data);
        return true;
    }

    public boolean appendData(int data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addLong(data);
        return true;
    }

    public boolean appendData(int[] data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addLong(data);
        return true;
    }

    public boolean appendData(short data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addInt(data);
        return true;
    }

    public boolean appendData(short[] data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addInt(data);
        return true;
    }

    public boolean appendData(float data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addSingle(data);
        return true;
    }

    public boolean appendData(float[] data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addSingle(data);
        return true;
    }

    public boolean appendData(String data) {
        if (this.SelectedItem == null) {
            return false;
        }
        this.SelectedItem.addString(data);
        return true;
    }

    public boolean writeFile(File file) {
        return true;
    }
}

