/*
 * Decompiled with CFR 0.152.
 */
package FileReaders;

import AppHistory.History;
import FileReaders.FileWatcher;
import FileReaders.LoadedLibrary;
import FileReaders.TextFileWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class ExternalLibrary
extends LoadedLibrary
implements FileWatcher.FileChangeListener {
    FileWatcher watcher = null;
    boolean changed = false;
    String historyKey = "";
    String saveExtension = "";
    String[] openExtensions;
    String defaultSaveName;
    History history;

    public void setChanged(boolean b) {
        if (this.changed != b) {
            this.changed = b;
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setHistory(History history) {
        this.history = history;
        if (history != null && this.historyKey != null && this.historyKey.length() > 0) {
            this.defaultSaveName = history.getUserPref().get(this.historyKey, "");
        }
    }

    public ExternalLibrary() {
        this.init();
    }

    public ExternalLibrary(String filepath) {
        super(filepath);
        this.init();
    }

    public ExternalLibrary(String filepath, String historyKey) {
        super(filepath);
        this.init();
        this.historyKey = historyKey;
    }

    public String getHistoryValue() {
        if (this.haveHistoryKey()) {
            return this.history.getUserPref().get(this.historyKey, "");
        }
        return "";
    }

    @Override
    public final boolean isExternal() {
        return true;
    }

    @Override
    public String[] getFileData(String fileName) {
        File file = new File(fileName);
        if (!(file.exists() && file.canRead() && file.isFile())) {
            return null;
        }
        try {
            String fileContent = new String(Files.readAllBytes(Paths.get(file.getCanonicalPath(), new String[0])));
            if (fileContent.contains("\r\n")) {
                return fileContent.split("\r\n");
            }
            return fileContent.split("\n");
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void open(String filePath) {
        if (filePath == null || filePath.length() == 0 || this.loadedFilePath.equalsIgnoreCase(filePath)) {
            return;
        }
        if (this.watcher != null) {
            this.watcher.stop();
        }
        super.open(filePath);
        this.watcher = new FileWatcher(Path.of(filePath, new String[0]), this, 500L);
        this.watcher.start();
        if (this.haveHistoryKey()) {
            this.history.getUserPref().put(this.historyKey, this.getLoadedFilePath());
        }
    }

    public void setHistoryKey(String key) {
        this.historyKey = (key = key.trim()) != null && key.length() > 0 ? key : "";
    }

    public String getHistoryKey() {
        return this.historyKey;
    }

    private boolean haveHistoryKey() {
        return this.history != null && this.historyKey != null && this.historyKey.length() > 0;
    }

    public abstract void clear();

    public void resetModificationTag() {
        this.lastModTime = this.getFileLastModTime();
    }

    public void setOpenExtension(String openExtensions) {
        this.setOpenExtensions(new String[]{openExtensions});
    }

    public void setOpenExtensions(String[] openExtensions) {
        if (openExtensions != null && openExtensions.length > 0) {
            for (int x = 0; x < openExtensions.length; ++x) {
                if (openExtensions[x].startsWith(".")) continue;
                openExtensions[x] = "." + openExtensions[x];
            }
            this.openExtensions = openExtensions;
        }
    }

    public void setDefaultSaveName(String filename) {
        this.defaultSaveName = filename;
    }

    public String getDefaultSaveName() {
        return this.defaultSaveName;
    }

    public void setSaveExtension(String extension) {
        if (extension == null) {
            return;
        }
        if (!(extension = extension.trim()).startsWith(".")) {
            extension = "." + extension;
        }
        if (extension.trim().length() < 2) {
            return;
        }
        this.saveExtension = extension;
    }

    private File verifySaveFileExtension(File file) {
        if (file.getName().toLowerCase().endsWith(this.saveExtension)) {
            return file;
        }
        return new File(file.getAbsolutePath() + this.saveExtension);
    }

    public boolean openFile() {
        JFileChooser dlg = new JFileChooser();
        if (this.loadedFilePath != null && this.loadedFilePath.length() > 0) {
            dlg.setSelectedFile(new File(this.loadedFilePath));
        } else if (this.defaultSaveName != null && this.defaultSaveName.length() > 0) {
            dlg.setSelectedFile(new File(this.defaultSaveName));
        }
        dlg.setFileFilter(ExternalLibrary.generateFilter("database files", this.openExtensions));
        if (dlg.showOpenDialog(null) == 0) {
            return this.loadFileContents(dlg.getSelectedFile().getAbsolutePath());
        }
        return false;
    }

    public boolean saveAs() {
        return this.saveAs(false);
    }

    public boolean saveAs(boolean promptOverwrite) {
        JFileChooser dlg = new JFileChooser();
        if (this.loadedFilePath != null && this.loadedFilePath.length() > 0) {
            dlg.setSelectedFile(new File(this.loadedFilePath));
        } else if (this.defaultSaveName != null && this.defaultSaveName.length() > 0) {
            dlg.setSelectedFile(new File(this.defaultSaveName));
        }
        if (this.saveExtension != null && this.saveExtension.length() > 0) {
            dlg.setFileFilter(ExternalLibrary.generateFilter(this.title, this.saveExtension));
        }
        if (dlg.showSaveDialog(null) == 0) {
            File file = this.verifySaveFileExtension(dlg.getSelectedFile());
            if (file.exists()) {
                int val;
                if (!file.isFile()) {
                    JOptionPane.showMessageDialog(null, "File save failed.  Path is not a file.", "File save failed", 0);
                    return false;
                }
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(null, "File save failed.  File does not have write access.", "File save failed", 0);
                    return false;
                }
                if (promptOverwrite && (val = JOptionPane.showConfirmDialog(null, "The specified file alread exists.  Overwrite?", "Confirm overwrite.", 0)) != 0) {
                    return false;
                }
            }
            return this.save(file.getAbsolutePath());
        }
        return false;
    }

    public boolean save() {
        if (this.loadedFilePath == null || this.loadedFilePath.length() == 0) {
            return this.saveAs();
        }
        return this.save(this.loadedFilePath);
    }

    public boolean save(String filePath) {
        TextFileWriter writer;
        if (this.watcher != null) {
            this.watcher.stop();
        }
        if (!(writer = new TextFileWriter(filePath)).isOpen()) {
            JOptionPane.showMessageDialog(null, "File " + filePath + " could not be opened.", "File save failed", 0);
            return false;
        }
        if (this.saveContents(writer)) {
            writer.close();
            if (!this.loadedFilePath.equalsIgnoreCase(filePath)) {
                this.watcher = new FileWatcher(Path.of(filePath, new String[0]), this, 500L);
            }
            this.loadedFilePath = filePath;
            this.lastModTime = this.getFileLastModTime();
            if (this.haveHistoryKey()) {
                this.history.getUserPref().put(this.historyKey, this.getLoadedFilePath());
            }
            this.watcher.start();
            return true;
        }
        writer.close();
        JOptionPane.showMessageDialog(null, "An error occurred while trying to save.", "File save failed", 0);
        this.watcher.start();
        return false;
    }

    @Override
    public void onFileChange(Path filePath) {
        if (JOptionPane.showConfirmDialog(null, "The " + this.getTitle() + " database has been externally modified.\nReload it now?", "Update database?", 1, 3) == 0) {
            this.update();
        }
    }

    public abstract boolean saveContents(TextFileWriter var1);
}

