/*
 * Decompiled with CFR 0.152.
 */
package FileReaders;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public class TextFileReader {
    private String error = "";
    private boolean hasError = false;
    private Scanner scanner;
    private File m_File;
    private boolean m_isOpen = false;

    public TextFileReader() {
    }

    public TextFileReader(File FileName) {
        this.OpenFile(FileName);
    }

    public TextFileReader(String FileName) {
        this.OpenFile(FileName);
    }

    public String getError() {
        return this.error;
    }

    public long getFileSize() {
        this.m_isOpen = false;
        if (false) {
            return 0L;
        }
        return this.m_File.length();
    }

    public String getFilePath() {
        this.m_isOpen = false;
        if (false) {
            return "";
        }
        return this.m_File.getPath();
    }

    public String getFileName() {
        this.m_isOpen = false;
        if (false) {
            return "";
        }
        return this.m_File.getName();
    }

    public String getFileTitle() {
        this.m_isOpen = false;
        if (false) {
            return "";
        }
        return this.m_File.getName();
    }

    public boolean isOpen() {
        return this.m_isOpen;
    }

    public boolean OpenFile(File FileName) {
        return this.OpenFile(FileName.getAbsolutePath());
    }

    public boolean OpenFile(String FileName) {
        this.Close();
        try {
            this.m_File = new File(FileName);
            if (!(this.m_File.exists() && this.m_File.isFile() && this.m_File.canRead())) {
                if (!this.m_File.exists()) {
                    this.error = "File does not exist.";
                } else if (!this.m_File.isFile()) {
                    this.error = "Item is not a file.";
                } else if (!this.m_File.canRead()) {
                    this.error = "File does not have read access.";
                }
                this.Close();
                return false;
            }
            this.scanner = new Scanner(this.m_File);
        }
        catch (FileNotFoundException e) {
            this.error = "File not found.";
            this.hasError = true;
            this.Close();
            return false;
        }
        this.m_isOpen = true;
        return true;
    }

    public String GetLine() {
        if (this.scanner.hasNextLine()) {
            return this.scanner.nextLine();
        }
        return "";
    }

    public boolean EOF() {
        if (this.scanner != null) {
            return !this.scanner.hasNextLine();
        }
        return true;
    }

    public boolean hasNextLine() {
        if (this.scanner != null) {
            return this.scanner.hasNextLine();
        }
        return false;
    }

    public void Close() {
        if (this.scanner != null) {
            this.scanner.close();
            this.scanner = null;
        }
        if (this.m_File != null) {
            this.m_File = null;
        }
        this.m_isOpen = false;
    }
}

