/*
 * Decompiled with CFR 0.152.
 */
package GenbankFileReader;

import GenbankFileReader.GenBankFile;
import GenbankFileReader.Locus;
import GenbankFileReader.Qualifier;
import java.io.Serializable;
import java.util.Arrays;

public class Annotation
extends Locus
implements Serializable {
    public static final String[] GBTYPES = new String[]{"-10_signal", "-35_signal", "3 'UTR", "5 'UTR", "attenuator", "C_region", "CAAT_signal", "cds", "centromere", "D_segment", "D-loop", "enhancer", "exon", "GC_signal", "gene", "iDNA", "intron", "J_segment", "LTR", "mat_peptide", "misc_binding", "misc_difference", "misc_feature", "misc_recomb", "misc_RNA", "misc_signal", "misc_structure", "mobile_element", "modified_base", "mRNA", "mult_cloning_site", "N_region", "ncRNA", "operon", "oriT", "polyA_signal", "polyA_site", "precursor_RNA", "prim_transcript", "primer_bind", "promoter", "protein_bind", "RBS", "rep_origin", "repeat_region", "rRNA", "S_region", "sig_peptide", "source", "stem_loop", "STS", "TATA_signal", "telomere", "terminator", "tmRNA", "transit_peptide", "tRNA", "unsure", "V_region", "V_segment"};
    private static final long serialVersionUID = 1L;
    protected String name = "";
    protected String gbType = "misc_feature";
    public Qualifier[] qualifiers;
    public static final String FEATURESPACER = "     ";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public boolean hasQualifiers() {
        return this.qualifiers != null && this.qualifiers.length > 0;
    }

    public Annotation() {
    }

    public Annotation(String gbType, int Start2, int Stop, boolean antisense) {
        this.setGBType(gbType);
        this.start = Start2;
        this.stop = Stop;
        this.antisense = antisense;
    }

    public void setEnd(int end) {
        this.stop = end;
    }

    public String getGBType() {
        return this.gbType;
    }

    public final void setGBType(String gbType) {
        this.gbType = GenBankFile.formatGBTypeName(gbType);
    }

    public int qualifierCount() {
        if (this.qualifiers != null) {
            return this.qualifiers.length;
        }
        return 0;
    }

    @Override
    public String toGBString() {
        StringBuilder outString = new StringBuilder(FEATURESPACER + this.gbType + Annotation.repeat(' ', 17 - this.gbType.length()) + super.toGBString());
        if (this.qualifiers != null && this.qualifiers.length > 0) {
            for (Qualifier qual : this.qualifiers) {
                if (qual == null) continue;
                outString.append("\n").append(qual.toGBString());
            }
        }
        return outString.toString();
    }

    protected static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }
}

