/*
 * Decompiled with CFR 0.152.
 */
package GenbankFileReader;

import Sequences.DNA;
import java.util.ArrayList;

public class FASTA {
    public String name = null;
    public DNA sequence = null;

    public static ArrayList<FASTA> splitFASTA(String ref) {
        ArrayList<FASTA> outList = new ArrayList<FASTA>();
        String[] lines = ref.split("\n");
        FASTA current = null;
        for (String line : lines) {
            String tLine = line.trim();
            if (tLine.startsWith(">")) {
                if (current != null && current.isValid()) {
                    outList.add(current);
                }
                current = new FASTA();
                if (tLine.length() > 1) {
                    current.name = tLine.substring(1);
                    continue;
                }
                current.name = "Entry_" + outList.size();
                continue;
            }
            if (current == null || current.name == null) continue;
            if (current.sequence == null) {
                current.sequence = new DNA();
            }
            current.sequence.append(tLine);
        }
        if (current != null && current.isValid()) {
            outList.add(current);
        }
        return outList;
    }

    public boolean isValid() {
        return this.name != null && this.name.length() > 0 && this.sequence != null && this.sequence.length() > 0;
    }

    public static boolean isFASTA(String text) {
        return text.contains(">") && text.contains("\n");
    }
}

