/*
 * Decompiled with CFR 0.152.
 */
package GhostTextControls;

import GhostTextControls.Constants;
import GhostTextControls.SelectionCaret;
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.BeanProperty;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class GhostJEditor
extends JEditorPane {
    final SelectionCaret focusCaret = new SelectionCaret(this);
    private boolean selectionOnFocus = false;
    private String emptyText;
    private Color ghostTextColor = Color.LIGHT_GRAY;
    Constants.HorizontalAlignment horizontalAlignment = Constants.HorizontalAlignment.CENTER;
    Constants.VerticalAlignment verticalAlignment = Constants.VerticalAlignment.CENTER;
    Icon backIcon;
    Color permaColor;

    public boolean isHighlightFocus() {
        return this.focusCaret.selectionVisibleWhenFocusedOnly;
    }

    @BeanProperty(preferred=true, description="Set whether selected text is only highlighted when the control has focus.  If false, selection highlight is always on.")
    public void setHighlightFocus(boolean highlight) {
        this.focusCaret.selectionVisibleWhenFocusedOnly = highlight;
        this.focusCaret.setSelectionVisible(true);
    }

    public boolean isSelectionOnFocus() {
        return this.selectionOnFocus;
    }

    @BeanProperty(preferred=true, description="Set whether the text in the control is automatically selected when the control gets focus.")
    public void setSelectionOnFocus(boolean SelectionOnFocus) {
        this.selectionOnFocus = SelectionOnFocus;
    }

    public Color getBlankTextColor() {
        return this.ghostTextColor;
    }

    @BeanProperty(preferred=true, description="Set the color of the text displayed when the textbox is empty.")
    public void setBlankTextColor(Color color) {
        this.ghostTextColor = color;
    }

    @BeanProperty(preferred=true, description="Set the text displayed when the textbox is empty.")
    public void setBlankText(String BlankText) {
        this.emptyText = BlankText;
    }

    public String getBlankText() {
        return this.emptyText == null ? "" : this.emptyText;
    }

    public int getTextLength() {
        return this.getDocument().getLength();
    }

    public void setColorFocused(Color NewColor) {
        this.focusCaret.setColorFocused(NewColor);
    }

    public void setColorUnfocused(Color NewColor) {
        this.focusCaret.setColorUnfocused(NewColor);
    }

    public Color getColorFocused() {
        return this.focusCaret.getColorFocused();
    }

    public Color getColorUnfocused() {
        return this.focusCaret.getColorUnfocused();
    }

    public void setDocumentFilter(DocumentFilter listener) {
        Document doc = this.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(listener);
        }
    }

    public GhostJEditor() {
        this.setCaret(this.focusCaret);
        this.focusCaret.setColorFocused(this.getSelectionColor());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GhostJEditor.this.focusCaret.setSelectionVisible(true);
                if (GhostJEditor.this.selectionOnFocus) {
                    GhostJEditor.this.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                GhostJEditor.this.focusCaret.setSelectionVisible(true);
            }
        });
    }

    public void setHorizontalIconAlignment(Constants.HorizontalAlignment alignment) {
        if (alignment.equals((Object)this.horizontalAlignment)) {
            return;
        }
        this.horizontalAlignment = alignment;
        this.repaint();
    }

    public void setVerticalIconAlignment(Constants.VerticalAlignment alignment) {
        if (alignment == this.verticalAlignment) {
            return;
        }
        this.verticalAlignment = alignment;
        this.repaint();
    }

    public Constants.HorizontalAlignment getHorizontalIconAlignment() {
        return this.horizontalAlignment;
    }

    public Constants.VerticalAlignment getVerticalIconAlignment() {
        return this.verticalAlignment;
    }

    public void setIcon(String iconPath) {
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource(iconPath));
            this.setIcon(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIcon(Icon icon) {
        this.backIcon = icon;
        if (this.backIcon != null) {
            this.setOpaque(false);
            this.setBackground(new Color(0, true));
        } else if (this.backIcon == null) {
            this.setOpaque(true);
        }
    }

    public Icon getIcon() {
        return this.backIcon;
    }

    public Color getBackcolor() {
        return this.permaColor;
    }

    public void setBackcolor(Color color) {
        this.permaColor = color;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        if (this.permaColor != null) {
            gfx.setColor(this.permaColor);
            gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.backIcon != null) {
            int x = 0;
            int y = 0;
            int x2 = 0;
            int y2 = 0;
            int wd = this.backIcon.getIconWidth();
            int ht = this.backIcon.getIconHeight();
            Container parent = SwingUtilities.getUnwrappedParent(this);
            if (parent instanceof JViewport) {
                Rectangle parentRect = parent.getBounds();
                y = parentRect.y - this.getBounds().y;
                x = parentRect.x - this.getBounds().x;
                switch (this.horizontalAlignment) {
                    case CENTER: {
                        x2 = x += (parentRect.width - wd) / 2;
                        break;
                    }
                    case RIGHT: {
                        x2 = x += parentRect.width - wd;
                        break;
                    }
                    case TILED: {
                        x2 = x + parentRect.width;
                    }
                }
                switch (this.verticalAlignment) {
                    case BOTTOM: {
                        y2 = y += parentRect.height - ht;
                        break;
                    }
                    case CENTER: {
                        y2 = y += (parentRect.height - ht) / 2;
                        break;
                    }
                    case TILED: {
                        y2 = y + parentRect.height;
                    }
                }
            } else {
                switch (this.horizontalAlignment) {
                    case CENTER: {
                        x = (this.getWidth() - wd) / 2;
                        x2 = 2;
                        break;
                    }
                    case RIGHT: {
                        x = this.getWidth() - wd;
                        x2 = 2;
                        break;
                    }
                    case TILED: {
                        x2 = this.getWidth();
                    }
                }
                switch (this.verticalAlignment) {
                    case BOTTOM: {
                        y2 = y = this.getHeight() - ht;
                        break;
                    }
                    case CENTER: {
                        y2 = y = (this.getHeight() - ht) / 2;
                        break;
                    }
                    case TILED: {
                        y2 = this.getHeight();
                    }
                }
            }
            for (int w = x; w <= x2; w += wd) {
                for (int z = y; z <= y2; z += ht) {
                    this.backIcon.paintIcon(this, gfx, w, z);
                }
            }
        }
        super.paintComponent(gfx);
        if (this.getText().length() == 0 && this.emptyText != null) {
            FontMetrics metrics = gfx.getFontMetrics(gfx.getFont());
            int hgt = metrics.getHeight();
            gfx.setColor(this.ghostTextColor);
            gfx.drawString(this.emptyText, 5, hgt);
        }
    }
}

