/*
 * Decompiled with CFR 0.152.
 */
package GhostTextControls;

import GhostTextControls.Constants;
import GhostTextControls.SelectionCaret;
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.BeanProperty;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GhostTextPane
extends JTextPane {
    private Color ghostTextColor = Color.LIGHT_GRAY;
    private boolean SelectionOnFocus = false;
    private String emptyText;
    private boolean wordWrap = true;
    final SelectionCaret focusCaret = new SelectionCaret(this);
    private Color permaColor = Color.white;
    private BackGroundUIExtender m_UI = new BackGroundUIExtender();
    Icon backIcon;
    Constants.HorizontalAlignment horizontalAlignment = Constants.HorizontalAlignment.CENTER;
    Constants.VerticalAlignment verticalAlignment = Constants.VerticalAlignment.CENTER;
    private static final String LINE_BREAK_ATTRIBUTE_NAME = "line_break_attribute";

    public boolean isHighlightFocus() {
        return this.focusCaret.selectionVisibleWhenFocusedOnly;
    }

    @BeanProperty(preferred=true, description="Set whether selected text is only highlighted when the control has focus.  If false, selection highlight is always on.")
    public void setHighlightFocus(boolean highlight) {
        this.focusCaret.selectionVisibleWhenFocusedOnly = highlight;
        this.focusCaret.setSelectionVisible(true);
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    public Color getBlankTextColor() {
        return this.ghostTextColor;
    }

    @BeanProperty(preferred=true, description="Set the color of the text displayed when the textbox is empty.")
    public void setBlankTextColor(Color color) {
        this.ghostTextColor = color;
    }

    public boolean isSelectionOnFocus() {
        return this.SelectionOnFocus;
    }

    @BeanProperty(preferred=true, description="Set whether the text in the control is automatically selected when the control gets focus.")
    public void setSelectionOnFocus(boolean SelectionOnFocus) {
        this.SelectionOnFocus = SelectionOnFocus;
    }

    @BeanProperty(preferred=true, description="Set the text displayed when the textbox is empty.")
    public void setBlankText(String BlankText) {
        this.emptyText = BlankText;
    }

    public String getBlankText() {
        return this.emptyText == null ? "" : this.emptyText;
    }

    public void setColorFocused(Color color) {
        this.focusCaret.setColorFocused(color);
    }

    public void setColorUnfocused(Color color) {
        this.focusCaret.setColorUnfocused(color);
    }

    public Color getColorFocused() {
        return this.focusCaret.getColorFocused();
    }

    public Color getColorUnfocused() {
        return this.focusCaret.getColorUnfocused();
    }

    public void setDocumentFilter(DocumentFilter listener) {
        Document doc = this.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(listener);
        }
    }

    public Color getBackcolor() {
        return this.permaColor;
    }

    public void setBackcolor(Color color) {
        this.permaColor = color;
    }

    public GhostTextPane() {
        Border c;
        this.setUI(this.m_UI);
        this.setCaret(this.focusCaret);
        Color color = UIManager.getColor("GhostTextPane.background");
        if (color != null) {
            this.permaColor = color;
        }
        if ((color = UIManager.getColor("GhostTextPane.foreground")) != null) {
            this.setForeground(color);
        }
        if ((color = UIManager.getColor("GhostTextPane.selectionBackground")) != null) {
            this.setSelectionColor(color);
        }
        Border borderOut = (c = UIManager.getBorder("TextPane.border")) == null ? new LineBorder(Color.black, 1, false) : c;
        EmptyBorder borderIn = new EmptyBorder(2, 5, 2, 5);
        CompoundBorder border = new CompoundBorder(borderOut, borderIn);
        this.setBorder(border);
        this.focusCaret.setColorFocused(this.getSelectionColor());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GhostTextPane.this.focusCaret.setSelectionVisible(true);
                if (GhostTextPane.this.SelectionOnFocus) {
                    GhostTextPane.this.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                GhostTextPane.this.focusCaret.setSelectionVisible(true);
            }
        });
    }

    public int getTextLength() {
        return this.getDocument().getLength();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.wordWrap) {
            return super.getScrollableTracksViewportWidth();
        }
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    public void setIcon(String iconPath) {
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource(iconPath));
            if (icon != null) {
                this.setIcon(icon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIcon(Icon icon) {
        this.backIcon = icon;
        if (this.backIcon != null) {
            this.setOpaque(false);
            this.setBackground(new Color(0, true));
        } else if (this.backIcon == null) {
            this.setOpaque(true);
        }
    }

    public void setHorizontalIconAlignment(Constants.HorizontalAlignment alignment) {
        if (alignment.equals((Object)this.horizontalAlignment)) {
            return;
        }
        this.horizontalAlignment = alignment;
        this.repaint();
    }

    public void setVerticalIconAlignment(Constants.VerticalAlignment alignment) {
        if (alignment == this.verticalAlignment) {
            return;
        }
        this.verticalAlignment = alignment;
        this.repaint();
    }

    public Constants.HorizontalAlignment getHorizontalIconAlignment() {
        return this.horizontalAlignment;
    }

    public Constants.VerticalAlignment getVerticalIconAlignment() {
        return this.verticalAlignment;
    }

    public Icon getIcon() {
        return this.backIcon;
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        if (this.permaColor != null) {
            gfx.setColor(this.permaColor);
            gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.backIcon != null) {
            int x = 0;
            int y = 0;
            int x2 = 0;
            int y2 = 0;
            int wd = this.backIcon.getIconWidth();
            int ht = this.backIcon.getIconHeight();
            Container parent = SwingUtilities.getUnwrappedParent(this);
            if (parent instanceof JViewport) {
                Rectangle parentRect = parent.getBounds();
                y = parentRect.y - this.getBounds().y;
                x = parentRect.x - this.getBounds().x;
                switch (this.horizontalAlignment) {
                    case CENTER: {
                        x2 = x += (parentRect.width - wd) / 2;
                        break;
                    }
                    case RIGHT: {
                        x2 = x += parentRect.width - wd;
                        break;
                    }
                    case TILED: {
                        x2 = x + parentRect.width;
                    }
                }
                switch (this.verticalAlignment) {
                    case BOTTOM: {
                        y2 = y += parentRect.height - ht;
                        break;
                    }
                    case CENTER: {
                        y2 = y += (parentRect.height - ht) / 2;
                        break;
                    }
                    case TILED: {
                        y2 = y + parentRect.height;
                    }
                }
            } else {
                switch (this.horizontalAlignment) {
                    case CENTER: {
                        x = (this.getWidth() - wd) / 2;
                        x2 = 2;
                        break;
                    }
                    case RIGHT: {
                        x = this.getWidth() - wd;
                        x2 = 2;
                        break;
                    }
                    case TILED: {
                        x2 = this.getWidth();
                    }
                }
                switch (this.verticalAlignment) {
                    case BOTTOM: {
                        y2 = y = this.getHeight() - ht;
                        break;
                    }
                    case CENTER: {
                        y2 = y = (this.getHeight() - ht) / 2;
                        break;
                    }
                    case TILED: {
                        y2 = this.getHeight();
                    }
                }
            }
            for (int w = x; w <= x2; w += wd) {
                for (int z = y; z <= y2; z += ht) {
                    this.backIcon.paintIcon(this, gfx, w, z);
                }
            }
        }
        super.paintComponent(gfx);
        if (this.getText().length() == 0 && this.emptyText != null) {
            FontMetrics metrics = gfx.getFontMetrics(gfx.getFont());
            int hgt = metrics.getHeight();
            gfx.setColor(this.ghostTextColor);
            gfx.drawString(this.emptyText, 5, hgt);
        }
    }

    private class BackGroundUIExtender
    extends BasicTextPaneUI {
        private BackGroundUIExtender() {
        }

        @Override
        protected void paintBackground(Graphics g) {
            g.setColor(GhostTextPane.this.permaColor);
            g.fillRect(0, 0, GhostTextPane.this.getWidth(), GhostTextPane.this.getHeight());
        }
    }

    class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new NoWrapParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory;

        WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }

        @Override
        public MutableAttributeSet getInputAttributes() {
            MutableAttributeSet mAttrs = super.getInputAttributes();
            mAttrs.removeAttribute(GhostTextPane.LINE_BREAK_ATTRIBUTE_NAME);
            return mAttrs;
        }
    }

    public class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public int getBreakWeight(int axis, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p0 = this.getStartOffset();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                if (p1 == p0) {
                    return 0;
                }
                try {
                    if (this.getDocument().getText(p0, p1 - p0).indexOf("\r") >= 0) {
                        return 3000;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return super.getBreakWeight(axis, pos, len);
        }

        @Override
        public View breakView(int axis, int p0, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                try {
                    int index = this.getDocument().getText(p0, p1 - p0).indexOf("\r");
                    if (index >= 0) {
                        GlyphView v = (GlyphView)this.createFragment(p0, p0 + index + 1);
                        return v;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return super.breakView(axis, p0, pos, len);
        }
    }

    public class NoWrapParagraphView
    extends ParagraphView {
        public NoWrapParagraphView(Element elem) {
            super(elem);
        }

        @Override
        public void layout(int width, int height) {
            super.layout(Short.MAX_VALUE, height);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return super.getPreferredSpan(axis);
        }
    }
}

