/*
 * Decompiled with CFR 0.152.
 */
package GraphicTreeClass;

import GraphicTreeClass.GraphicTreeNode;
import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class GraphicTreeModel
extends DefaultTreeModel {
    private ArrayList<TreeModelListener> treeModelListeners = new ArrayList();
    private GraphicTreeNode rootNode;

    public GraphicTreeModel(GraphicTreeNode root) {
        super(root);
        this.rootNode = root;
    }

    protected void fireTreeStructureChanged(GraphicTreeNode oldRoot) {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        this.treeModelListeners.forEach(tml -> tml.treeStructureChanged(e));
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public void nodeChanged(GraphicTreeNode node) {
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        GraphicTreeNode p;
        GraphicTreeNode c = (GraphicTreeNode)node;
        if (c != null && (p = (GraphicTreeNode)c.getParent()) != null) {
            p.remove(c);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        GraphicTreeNode p = (GraphicTreeNode)parent;
        return p.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        GraphicTreeNode p = (GraphicTreeNode)parent;
        return p.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((GraphicTreeNode)parent).getIndex((GraphicTreeNode)child);
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        GraphicTreeNode p = (GraphicTreeNode)node;
        return p.isLeaf();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        GraphicTreeNode ChangedNode = (GraphicTreeNode)path.getLastPathComponent();
        ChangedNode.setText(newValue.toString());
        ChangedNode.setChanged(true);
        super.valueForPathChanged(path, newValue);
    }

    public void insertNodeInto(GraphicTreeNode node, GraphicTreeNode parent, int i) {
        parent.insert(node, i);
    }
}

