/*
 * Decompiled with CFR 0.152.
 */
package GraphicTreeClass;

import java.awt.Color;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class GraphicTreeNode
extends DefaultMutableTreeNode {
    public static final DataFlavor graphicTreeNodeFlavor = new DataFlavor(GraphicTreeNode.class, "GraphicTreeNode");
    private String iconName = "";
    public boolean forcedLeaf = false;
    public boolean editable = true;
    public boolean expanded = false;
    private boolean locked = false;
    private String text = "New Item";
    public String toolTip = "";
    private Color textBackColor = null;
    public Color textForeColor = null;
    public Color selectedTextBackColor = null;
    public Color selectedTextForeColor = null;
    public boolean textBold;
    public boolean textItalics;
    public ImageIcon iconDefault;
    public ImageIcon iconOpened;
    public ImageIcon iconClosed;
    public ImageIcon iconLeaf;
    protected String treeKey = "";
    public String imagePath = "";
    private boolean m_Changed = false;
    public boolean mAcceptDrop = true;
    public boolean mMovable = true;

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setTreeKey(String key) {
        this.treeKey = key;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getTreeKey() {
        if (this.treeKey != null && this.treeKey.length() > 0) {
            return this.treeKey;
        }
        return this.toString();
    }

    @Override
    public GraphicTreeNode clone() {
        GraphicTreeNode outNode = (GraphicTreeNode)super.clone();
        outNode.editable = this.editable;
        outNode.expanded = this.expanded;
        outNode.text = this.text;
        outNode.toolTip = this.toolTip;
        outNode.setTextBackColor(this.getTextBackColor());
        outNode.textForeColor = this.textForeColor;
        outNode.textBold = this.textBold;
        outNode.textItalics = this.textItalics;
        outNode.iconDefault = this.iconDefault;
        outNode.iconOpened = this.iconOpened;
        outNode.iconClosed = this.iconClosed;
        outNode.iconLeaf = this.iconLeaf;
        outNode.treeKey = "";
        outNode.imagePath = this.imagePath;
        outNode.m_Changed = false;
        return outNode;
    }

    public void setMovable(boolean movable) {
        this.mMovable = movable;
    }

    public boolean Movable() {
        return this.mMovable;
    }

    public void setAcceptsDrop(boolean acceptDrop) {
        this.mAcceptDrop = acceptDrop;
    }

    public abstract boolean acceptsDrop(TransferHandler.TransferSupport var1);

    public void setChanged(boolean changed) {
        this.m_Changed = changed;
    }

    public abstract void initNode();

    public boolean isChanged() {
        return this.m_Changed;
    }

    public Color getTextForeColor() {
        return this.textForeColor;
    }

    public Color getTextBackColor() {
        return this.textBackColor;
    }

    public void setTextForeColor(Color newcolor) {
        this.textForeColor = newcolor;
    }

    public void setTextBackColor(Color color) {
        this.textBackColor = color;
    }

    public void setImagePath(String path) {
        this.imagePath = path.length() == 0 ? "" : (!path.endsWith("/") ? path + "/" : path);
    }

    public GraphicTreeNode() {
        this.text = "New Item";
    }

    public GraphicTreeNode(String caption) {
        this.text = caption;
    }

    public GraphicTreeNode(String caption, String iconDefPath) {
        this.setText(caption);
        this.setIcon(iconDefPath);
    }

    public GraphicTreeNode(String caption, String iconDefPath, String iconOpenedPath) {
        this.setText(caption);
        this.setIcon(iconDefPath);
        this.setIconOpened(iconOpenedPath);
        this.setIconClosed(iconOpenedPath);
    }

    public GraphicTreeNode(String caption, String iconDefPath, String iconOpenedPath, String iconClosedPath) {
        this.setText(caption);
        this.setIcon(iconDefPath);
        this.setIconOpened(iconOpenedPath);
        this.setIconClosed(iconClosedPath);
    }

    public GraphicTreeNode(String caption, ImageIcon iconDef) {
        this.setText(caption);
        this.setIcon(iconDef);
    }

    public GraphicTreeNode(String caption, ImageIcon iconDef, ImageIcon iconOpenedPath) {
        this.setText(caption);
        this.setIcon(iconDef);
        this.setIconOpened(iconOpenedPath);
        this.setIconClosed(iconOpenedPath);
    }

    public GraphicTreeNode(String caption, ImageIcon iconDef, ImageIcon iconOpened, ImageIcon iconClosed) {
        this.setText(caption);
        this.setIcon(iconDef);
        this.setIconOpened(iconOpened);
        this.setIconClosed(iconClosed);
    }

    public GraphicTreeNode(String caption, Image iconDef) {
        this.setText(caption);
        this.setIcon(iconDef);
    }

    public GraphicTreeNode(String caption, Image iconDef, Image iconOpenedPath) {
        this.setText(caption);
        this.setIcon(iconDef);
        this.setIconOpened(iconOpenedPath);
        this.setIconClosed(iconOpenedPath);
    }

    public GraphicTreeNode(String caption, Image iconDef, Image iconOpened, Image iconClosed) {
        this.setText(caption);
        this.setIcon(iconDef);
        this.setIconOpened(iconOpened);
        this.setIconClosed(iconClosed);
    }

    public void setIcon(Image newIcon) {
        this.iconDefault = new ImageIcon(newIcon);
    }

    public void setIcon(ImageIcon newIcon) {
        this.iconDefault = newIcon;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public String getIconName(String iconName) {
        return this.iconName;
    }

    public void setIcon(String iconName) {
        this.iconName = iconName;
        if (!iconName.endsWith(".png")) {
            iconName = iconName + ".png";
        }
        this.iconDefault = iconName.contains("/") ? new ImageIcon(this.getClass().getResource(iconName)) : new ImageIcon(this.getClass().getResource(this.imagePath + iconName));
    }

    public void setIconOpened(Image newIcon) {
        this.iconOpened = new ImageIcon(newIcon);
    }

    public void setIconOpened(ImageIcon newIcon) {
        this.iconOpened = newIcon;
    }

    public void setIconOpened(String iconName) {
        if (!iconName.endsWith(".png")) {
            iconName = iconName + ".png";
        }
        this.iconOpened = iconName.contains("/") ? new ImageIcon(this.getClass().getResource(iconName)) : new ImageIcon(this.getClass().getResource(this.imagePath + iconName));
    }

    public void setIconClosed(Image newIcon) {
        this.iconClosed = new ImageIcon(newIcon);
    }

    public void setIconClosed(ImageIcon newIcon) {
        this.iconClosed = newIcon;
    }

    public void setIconClosed(String iconName) {
        if (!iconName.endsWith(".png")) {
            iconName = iconName + ".png";
        }
        this.iconClosed = iconName.contains("/") ? new ImageIcon(this.getClass().getResource(iconName)) : new ImageIcon(this.getClass().getResource(this.imagePath + iconName));
    }

    public ImageIcon getIcon() {
        if (super.isLeaf()) {
            return this.iconDefault;
        }
        if (this.expanded & this.iconOpened != null) {
            return this.iconOpened;
        }
        if (!this.expanded & this.iconClosed != null) {
            return this.iconClosed;
        }
        return this.iconDefault;
    }

    public ImageIcon getIconDefault() {
        return this.iconDefault;
    }

    public ImageIcon getIconClosed() {
        return this.iconClosed;
    }

    public ImageIcon getIconOpened() {
        return this.iconOpened;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String caption) {
        this.text = caption;
    }

    @Override
    public String toString() {
        return this.text;
    }

    public Color getSelectedTextForeColor() {
        return this.selectedTextForeColor;
    }

    public Color getSelectedTextBackColor() {
        return this.selectedTextBackColor;
    }

    public int getDecendentCount() {
        int cCount = this.getChildCount();
        for (int x = 0; x < this.getChildCount(); ++x) {
            cCount += ((GraphicTreeNode)this.getChildAt(x)).getDecendentCount();
        }
        return cCount;
    }

    public int getChildNodeCount(Class ... nodeClasses) {
        return GraphicTreeNode.getChildNodesCountOf(this, nodeClasses);
    }

    public ArrayList<GraphicTreeNode> getDescendentNodes(Class ... nodeClasses) {
        ArrayList<GraphicTreeNode> foundNodes = new ArrayList<GraphicTreeNode>();
        GraphicTreeNode.getDescendantNodesOf(this, foundNodes, nodeClasses);
        return foundNodes;
    }

    public static ArrayList<GraphicTreeNode> getChildNodes(GraphicTreeNode parentNode, Class ... nodeClasses) {
        ArrayList<GraphicTreeNode> foundNodes = new ArrayList<GraphicTreeNode>();
        GraphicTreeNode.getChildNodesOf(parentNode, foundNodes, nodeClasses);
        return foundNodes;
    }

    public static void getChildNodesOf(GraphicTreeNode node, ArrayList<GraphicTreeNode> dest, Class ... nodeClasses) {
        if (node.children == null || node.children.isEmpty()) {
            return;
        }
        block0: for (TreeNode child : node.children) {
            for (Class nodeClass : nodeClasses) {
                if (!child.getClass().equals(nodeClass)) continue;
                dest.add((GraphicTreeNode)child);
                continue block0;
            }
        }
    }

    public static int getChildNodesCountOf(GraphicTreeNode node, Class ... nodeClasses) {
        if (node.children == null || node.children.isEmpty()) {
            return 0;
        }
        int count = 0;
        block0: for (TreeNode child : node.children) {
            for (Class nodeClass : nodeClasses) {
                if (!child.getClass().equals(nodeClass)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static int getDescendantNodesCountOf(GraphicTreeNode node, Class ... nodeClasses) {
        if (node.children == null || node.children.isEmpty()) {
            return 0;
        }
        int count = 0;
        block0: for (TreeNode child : node.children) {
            for (Class nodeClass : nodeClasses) {
                count += GraphicTreeNode.getDescendantNodesCountOf((GraphicTreeNode)child, nodeClasses);
                if (!child.getClass().equals(nodeClass)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static void getDescendantNodesOf(GraphicTreeNode node, ArrayList<GraphicTreeNode> dest, Class ... nodeClasses) {
        if (node.children == null || node.children.isEmpty()) {
            return;
        }
        block0: for (TreeNode child : node.children) {
            for (Class nodeClass : nodeClasses) {
                GraphicTreeNode.getDescendantNodesOf((GraphicTreeNode)child, dest, nodeClasses);
                if (!child.getClass().equals(nodeClass)) continue;
                dest.add((GraphicTreeNode)child);
                continue block0;
            }
        }
    }
}

