/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import IconRenderers.ControlButtonRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class CloseButtonIconRenderer
extends ControlButtonRenderer {
    private static final int XLEN = 5;
    private static final Color CLOSE_OVER_RED = new Color(232, 17, 35);
    private static final Color CLOSE_PRESSED_RED = new Color(241, 112, 122);

    public CloseButtonIconRenderer() {
        this.loadUIColors("close");
        this.drawborder = false;
    }

    @Override
    protected void initDefaultColors() {
        this.colors.setColor(1, 5, CLOSE_OVER_RED);
        this.colors.setColor(1, 6, CLOSE_PRESSED_RED);
        this.colors.setColor(1, 1, CLOSE_PRESSED_RED);
        this.colors.setColor(1, 3, CLOSE_PRESSED_RED);
        this.colors.setColor(2, 1, Color.WHITE);
        this.colors.setColor(2, 0, Color.GRAY);
        this.colors.setColor(2, 5, Color.WHITE);
        this.colors.setColor(4, 5, CLOSE_OVER_RED);
        this.colors.setColor(4, 6, CLOSE_PRESSED_RED);
        this.colors.setColor(4, 1, CLOSE_PRESSED_RED);
        this.colors.setColor(4, 3, CLOSE_PRESSED_RED);
        this.colors.setColor(5, 1, Color.WHITE);
        this.colors.setColor(5, 0, Color.GRAY);
        this.colors.setColor(5, 5, Color.WHITE);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Rectangle rect, int state) {
        if (!this.isWindows) {
            return;
        }
        Color fillCol = this.colors.getActiveColor(1);
        if (fillCol != null) {
            g.setColor(fillCol);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    @Override
    public void paintIcon(Graphics g, Component c, int direction, Rectangle rect, int state) {
        int bot;
        int right;
        int top;
        int left;
        if (rect != null) {
            left = rect.x;
            top = rect.y;
            right = rect.x + rect.width;
            bot = rect.y + rect.height;
        } else {
            int ht = c.getHeight();
            int wd = c.getWidth();
            int midX = wd / 2;
            int midY = ht / 2;
            left = midX - 5;
            right = midX + 5;
            top = midY - 5;
            bot = midY + 5;
        }
        Color lineColor = this.colors.getActiveColor(2);
        if (lineColor == null) {
            lineColor = this.lineNoFocus;
        }
        g.setColor(lineColor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawLine(left, top, right, bot);
        g.drawLine(left, bot, right, top);
    }
}

