/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import IconRenderers.CloseButtonIconRenderer;
import IconRenderers.ControlButtonColors;
import IconRenderers.IconRenderer;
import IconRenderers.MinButtonIconRenderer;
import IconRenderers.RestoreButtonIconRenderer;
import Tools.UITools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Arc2D;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import plaf.BaseRootPaneUI;

public abstract class ControlButtonRenderer
extends IconRenderer {
    public static final CloseButtonIconRenderer defaultCloseIconRenderer = new CloseButtonIconRenderer();
    public static final MinButtonIconRenderer defaultMinIconRenderer = new MinButtonIconRenderer();
    public static final RestoreButtonIconRenderer defaultRestoreIconRenderer = new RestoreButtonIconRenderer();
    private static final int XLEN = 5;
    public static final int TYPE_FORECOLOR_INACTIVE = 3;
    public static final int TYPE_BACKCOLOR_INACTIVE = 4;
    public static final int TYPE_LINECOLOR_INACTIVE = 5;
    public static final int RESTORE = 0;
    public static final int MAXIMIZE = 1;
    boolean drawborder = false;
    protected Color lineNoFocus = Color.lightGray;
    private String buttonName = "button";

    public String toString() {
        return this.buttonName;
    }

    boolean frameIsNormal(Window parentFrame) {
        if (parentFrame instanceof JFrame) {
            return ((JFrame)parentFrame).getExtendedState() != 0;
        }
        if (parentFrame instanceof JDialog) {
            return BaseRootPaneUI.getDialogState((JDialog)parentFrame) != 0;
        }
        return false;
    }

    protected boolean isOwnerFrameActive(Component c) {
        Window parentFrame = this.getParentFrame(c);
        return parentFrame != null ? parentFrame.isActive() : true;
    }

    public void setDrawBorder(boolean draw) {
        this.drawborder = draw;
    }

    protected Window getParentFrame(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JFrame || c instanceof JDialog) {
            return (Window)c;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        return this.getParentFrame(parent);
    }

    public ControlButtonRenderer() {
        this.colors = new ControlButtonColors();
        this.initDefaultColors();
    }

    public void paint(Graphics g, Component c, boolean isActive) {
        int state = UITools.getState(c);
        if (this.colors instanceof ControlButtonColors) {
            ((ControlButtonColors)this.colors).setActiveColors(state, isActive);
        } else {
            this.colors.setActiveColors(c);
        }
        this.paintBackground(g, c, null, state);
        this.paintIcon(g, c, 0, null, state);
        if (this.drawborder) {
            this.paintBorder(g, c, null, state);
        }
    }

    public void paintBackground(Graphics g, Component c, Rectangle rect, int state) {
        Color fillCol = this.colors.getActiveColor(1);
        if (fillCol != null) {
            g.setColor(fillCol);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public void paintBorder(Graphics g, Component c, Rectangle rect, int state) {
        Color lineColor = this.colors.getActiveColor(2);
        if (lineColor != null) {
            g.setColor(lineColor);
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        }
    }

    protected abstract void initDefaultColors();

    protected void loadUIColors(String buttonName) {
        this.buttonName = buttonName;
        Object uiColors = UIManager.get("RenderedUI.TitlePaneButton." + buttonName + ".colors");
        if (uiColors instanceof ControlButtonColors) {
            this.colors = (ControlButtonColors)uiColors;
            return;
        }
        Color color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".rolloverbackground");
        if (color != null) {
            this.colors.setColor(1, 5, color);
            this.colors.setColor(1, 6, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.rolloverbackground");
            if (color != null) {
                this.colors.setColor(1, 5, color);
                this.colors.setColor(1, 6, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".pressedbackground");
        if (color != null) {
            this.colors.setColor(1, 1, color);
            this.colors.setColor(1, 3, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.pressedbackground");
            if (color != null) {
                this.colors.setColor(1, 1, color);
                this.colors.setColor(1, 3, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".defaultbackground");
        if (color != null) {
            this.colors.setColor(1, 0, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.defaultbackground");
            if (color != null) {
                this.colors.setColor(1, 0, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".defaultforeground");
        if (color != null) {
            this.colors.setColor(0, 0, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.defaultforeground");
            if (color != null) {
                this.colors.setColor(0, 0, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".rolloverforeground");
        if (color != null) {
            this.colors.setColor(0, 5, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.rolloverforeground");
            if (color != null) {
                this.colors.setColor(0, 5, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".pressedforeground");
        if (color != null) {
            this.colors.setColor(0, 1, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.pressedforeground");
            if (color != null) {
                this.colors.setColor(0, 1, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".defaultline");
        if (color != null) {
            this.colors.setColor(2, 0, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.defaultline");
            if (color != null) {
                this.colors.setColor(2, 0, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".rolloverline");
        if (color != null) {
            this.colors.setColor(2, 5, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.rolloverline");
            if (color != null) {
                this.colors.setColor(2, 5, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".pressedline");
        if (color != null) {
            this.colors.setColor(2, 1, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.pressedline");
            if (color != null) {
                this.colors.setColor(2, 1, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".defaultborder");
        if (color != null) {
            this.colors.setColor(2, 0, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.defaultborder");
            if (color != null) {
                this.colors.setColor(2, 0, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".rolloverborder");
        if (color != null) {
            this.colors.setColor(2, 5, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.rolloverborder");
            if (color != null) {
                this.colors.setColor(2, 5, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".pressedborder");
        if (color != null) {
            this.colors.setColor(2, 1, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.pressedborder");
            if (color != null) {
                this.colors.setColor(2, 1, color);
            }
        }
        buttonName = buttonName + ".inactive";
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".rolloverbackground");
        if (color != null) {
            this.colors.setColor(4, 5, color);
            this.colors.setColor(4, 6, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.rolloverbackground");
            if (color != null) {
                this.colors.setColor(4, 5, color);
                this.colors.setColor(4, 6, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".pressedbackground");
        if (color != null) {
            this.colors.setColor(4, 1, color);
            this.colors.setColor(4, 3, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.pressedbackground");
            if (color != null) {
                this.colors.setColor(4, 1, color);
                this.colors.setColor(4, 3, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".defaultbackground");
        if (color != null) {
            this.colors.setColor(4, 0, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.defaultbackground");
            if (color != null) {
                this.colors.setColor(4, 0, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".defaultforeground");
        if (color != null) {
            this.colors.setColor(3, 0, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.defaultforeground");
            if (color != null) {
                this.colors.setColor(3, 0, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".rolloverforeground");
        if (color != null) {
            this.colors.setColor(3, 5, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.rolloverforeground");
            if (color != null) {
                this.colors.setColor(3, 5, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".pressedforeground");
        if (color != null) {
            this.colors.setColor(3, 1, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.pressedforeground");
            if (color != null) {
                this.colors.setColor(3, 1, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".defaultborder");
        if (color != null) {
            this.colors.setColor(5, 0, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.defaultborder");
            if (color != null) {
                this.colors.setColor(5, 0, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".rolloverborder");
        if (color != null) {
            this.colors.setColor(5, 5, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.rolloverborder");
            if (color != null) {
                this.colors.setColor(5, 5, color);
            }
        }
        color = UIManager.getColor("RenderedUI.TitlePaneButton." + buttonName + ".pressedborder");
        if (color != null) {
            this.colors.setColor(5, 1, color);
        } else {
            color = UIManager.getColor("RenderedUI.TitlePaneButtons.inactive.pressedborder");
            if (color != null) {
                this.colors.setColor(5, 1, color);
            }
        }
    }

    public Shape genCircleIconShape(Graphics g, Component c, Rectangle rect, int state, Color baseColor) {
        int bot;
        int right;
        int top;
        int left;
        int wd;
        int ht;
        if (rect != null) {
            ht = rect.height;
            wd = rect.width;
            left = rect.x;
            top = rect.y;
            right = rect.x + rect.width;
            bot = rect.y + rect.height;
        } else {
            ht = c.getHeight();
            wd = c.getWidth();
            int wdHalf = wd / 2;
            int htHalf = ht / 2;
            left = wdHalf - 5;
            right = wdHalf + 5;
            top = htHalf - 5;
            bot = htHalf + 5;
        }
        int midX = (left + right) / 2;
        int midY = (top + bot) / 2;
        int dotSize = Math.min(wd, ht) / 4;
        Arc2D.Double circleIcon = new Arc2D.Double();
        circleIcon.x = midX - dotSize;
        circleIcon.y = midY - dotSize;
        circleIcon.width = dotSize * 2 + 1;
        circleIcon.height = dotSize * 2 + 1;
        circleIcon.start = 0.0;
        circleIcon.extent = 360.0;
        Graphics2D g2d = (Graphics2D)g;
        if (!this.isOwnerFrameActive(c)) {
            g2d.setColor(Color.lightGray);
            g2d.fill(circleIcon);
            g2d.setColor(Color.darkGray);
            g2d.draw(circleIcon);
        } else {
            switch (state) {
                case 0: {
                    g2d.setColor(baseColor);
                    break;
                }
                case 5: {
                    g2d.setColor(baseColor.darker());
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    g2d.setColor(baseColor.darker().darker());
                }
            }
            g2d.fill(circleIcon);
            g2d.setColor(Color.black);
            g2d.draw(circleIcon);
        }
        return circleIcon;
    }
}

