/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import IconRenderers.IconRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;

public class TriangleArrowRenderer
extends IconRenderer {
    @Override
    public void paintIcon(Graphics g, Component c, int direction, Rectangle rect, int state) {
        double y;
        double x;
        int size;
        if (rect != null) {
            int h = rect.height;
            int w = rect.width;
            size = Math.max(Math.min((h - 4) / 3, (w - 4) / 3), 2);
            x = rect.x + (w - size) / 2;
            y = rect.y + (h - size) / 2;
        } else {
            int h = c.getHeight();
            int w = c.getWidth();
            size = Math.max(Math.min((h - 4) / 3, (w - 4) / 3), 2);
            x = (w - size) / 2;
            y = (h - size) / 2;
        }
        Path2D.Double path = new Path2D.Double();
        path.moveTo(-size, size / 2);
        path.lineTo(size, size / 2);
        path.lineTo(0.0, -size / 2);
        path.closePath();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.PI * (double)(direction - 1) / 4.0);
        path.transform(affineTransform);
        Graphics2D g2d = (Graphics2D)g.create();
        double tx = x + (double)(size / 2);
        double ty = y + (double)(size / 2);
        g2d.translate(tx, ty);
        Color oldColor = g.getColor();
        int shiftX = 0;
        int shiftY = 0;
        this.colors.setActiveColors(c);
        if (state == 1) {
            switch (direction) {
                case 1: {
                    shiftY = -1;
                    break;
                }
                case 5: {
                    shiftY = 1;
                    break;
                }
                case 3: {
                    shiftX = 1;
                    break;
                }
                case 7: {
                    shiftX = -1;
                }
            }
            g2d.translate(shiftX, shiftY);
        }
        g2d.setColor(this.colors.getActiveColor(0));
        g2d.fill(path);
        g2d.setColor(this.colors.getActiveColor(2));
        g2d.draw(path);
        if (state == 1) {
            g2d.translate(-shiftX, -shiftY);
        }
        g2d.translate(-tx, -ty);
        g2d.setColor(oldColor);
        g2d.dispose();
    }
}

