/*
 * Decompiled with CFR 0.152.
 */
package JMScrollBars;

import JMConstants.Constants;
import JMScrollBars.JMScrollBar;
import JMScrollBars.Thumb;
import JMScrollBars.ValueRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedProgressBarUI;
import java.awt.Color;
import java.awt.Graphics;
import java.beans.BeanProperty;

public class JMProgressScrollBar
extends JMScrollBar {
    private static ValueRenderer defaultValueRenderer = null;
    private static Renderer defaultTrackRenderer = null;
    private static Renderer defaultThumbRenderer = null;

    public static ValueRenderer getDefaultValueRenderer() {
        return defaultValueRenderer != null ? defaultValueRenderer : RenderedProgressBarUI.getDefaultValueRenderer();
    }

    public static Renderer getDefaultTrackRenderer() {
        return defaultTrackRenderer != null ? defaultTrackRenderer : RenderedProgressBarUI.getDefaultTrackRenderer();
    }

    public static Renderer getDefaultThumbRenderer() {
        return defaultThumbRenderer != null ? defaultThumbRenderer : RenderedProgressBarUI.getDefaultThumbRenderer();
    }

    public static void setDefaultTrackRenderer(Renderer renderer) {
        defaultTrackRenderer = renderer;
    }

    public static void setDefaultValueRenderer(ValueRenderer renderer) {
        defaultValueRenderer = renderer;
    }

    public static void setDefaultThumbRenderer(Renderer renderer) {
        defaultThumbRenderer = renderer;
    }

    @Override
    public ValueRenderer getActiveValueRenderer() {
        return this.valueRenderer != null ? this.valueRenderer : JMProgressScrollBar.getDefaultValueRenderer();
    }

    @Override
    public Renderer getActiveThumbRenderer() {
        return this.thumbRenderer != null ? this.thumbRenderer : JMProgressScrollBar.getDefaultThumbRenderer();
    }

    @Override
    public Renderer getActiveTrackRenderer() {
        return this.renderer != null ? this.renderer : JMProgressScrollBar.getDefaultTrackRenderer();
    }

    public JMProgressScrollBar() {
        this.showValueStyle = 0;
        this.setThumb(new Thumb());
    }

    @Override
    protected boolean calculateThumb() {
        int x;
        int y;
        int wd;
        int ht;
        if (this.orientation == 0) {
            ht = this.trackRect.height;
            wd = (int)JMProgressScrollBar.scale(this.value, this.min, this.max, (float)this.trackRect.x, (float)this.trackRect.width);
            y = this.trackRect.y;
            x = this.invertDirection ? this.trackRect.width - wd : this.trackRect.x;
        } else {
            wd = this.trackRect.width;
            x = this.trackRect.x;
            ht = (int)JMProgressScrollBar.scale(this.value, this.min, this.max, (float)this.trackRect.x, (float)this.trackRect.height);
            int n = y = !this.invertDirection ? this.trackRect.height - ht : this.trackRect.y;
        }
        if (this.thumb.thumbRect.width != wd || this.thumb.thumbRect.height != ht || this.thumbRenderer == null) {
            this.thumb.thumbRect.width = wd;
            this.thumb.thumbRect.height = ht;
            if (this.thumbGraphics != null) {
                this.thumbGraphics.dispose();
            }
            this.resetThumbBuffer();
            this.thumb.thumbRect.x = x;
            this.thumb.thumbRect.y = y;
            return true;
        }
        this.thumb.resize(wd, ht);
        return false;
    }

    @Override
    protected int getValueFromX(int pos) {
        if (this.invertDirection) {
            pos = this.trackRect.width - pos;
        }
        return (int)JMProgressScrollBar.scale((float)pos, 0.0f, (float)this.trackRect.width, this.min, this.max);
    }

    @Override
    protected int getValueFromY(int pos) {
        if (!this.invertDirection) {
            pos = this.trackRect.height - pos;
        }
        return (int)JMProgressScrollBar.scale((float)pos, 0.0f, (float)this.trackRect.height, this.min, this.max);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setThumbShape(int shape) {
        super.setThumbShape(shape);
    }

    @BeanProperty(preferred=true, description="Sets the color of the progress indicator.")
    public void setProgressBarColor(Color color) {
        super.setThumbColor(color);
        super.setThumbColorOver(color);
        super.setThumbColorPressed(color);
    }

    public Color getProgressBarColor() {
        return this.getThumbColor();
    }

    @BeanProperty(preferred=true, description="Sets the style of the thumb.")
    public void setProgressBarStyle(Constants.DEFAULTRENDERERS style) {
        super.setThumbStyle(style);
    }

    public Constants.DEFAULTRENDERERS getProgressBarStyle() {
        return this.getThumbStyle();
    }

    @Override
    @BeanProperty(hidden=true)
    public void setThumbStyle(Constants.DEFAULTRENDERERS style) {
        super.setThumbStyle(style);
    }

    @Override
    public void paint(Graphics g) {
        this.currentHt = this.getHeight();
        this.currentWd = this.getWidth();
        this.trackState = this.getState();
        switch (this.trackState) {
            case 1: {
                this.thumbState = this.thumbPressed ? 1 : 5;
                this.trackState = 5;
                break;
            }
            default: {
                this.thumbState = this.trackState;
            }
        }
        this.paintTrack(g);
        this.paintThumb(g);
        this.paintBorder(g);
        if (this.showValueStyle != -1) {
            this.paintValue(g);
        }
    }
}

