/*
 * Decompiled with CFR 0.152.
 */
package JMScrollBars;

import BaseClasses.JMRenderedComponent;
import JMConstants.Constants;
import JMScrollBars.PercentValueRenderer;
import JMScrollBars.RawValueRenderer;
import JMScrollBars.Thumb;
import JMScrollBars.ValueRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedProgressBarUI;
import UIRenderers.RenderedScrollBarUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.BeanProperty;
import java.util.ArrayList;
import javax.swing.Timer;

public class JMScrollBar
extends JMRenderedComponent {
    private static ValueRenderer defaultValueRenderer = null;
    private static Renderer defaultTrackRenderer = null;
    private static Renderer defaultThumbRenderer = null;
    private static final int SCROLL_TIMER_INTERVAL = 250;
    boolean invertThumb = false;
    int thumbShape = 2;
    protected Constants.DEFAULTRENDERERS thumbStyle = Constants.DEFAULTRENDERERS.Default;
    boolean showThumbBorder = true;
    Thumb thumb;
    Renderer thumbRenderer;
    ValueRenderer valueRenderer;
    BufferedImage trackBuffer = null;
    Graphics trackGraphics = null;
    BufferedImage thumbBuffer = null;
    Graphics thumbGraphics = null;
    int orientation = 0;
    long min = 0L;
    long max = 100L;
    long value = 50L;
    int bigChange = 10;
    int smallChange = 1;
    Color thumbColorNormal;
    Color thumbColorOver = this.thumbColorNormal = Color.gray;
    Color thumbColorPressed = this.thumbColorNormal;
    Color thumbColorBorder = this.thumbColorNormal.darker();
    boolean mouseOver = false;
    boolean mousePressed = false;
    boolean thumbPressed = false;
    private final ScrollTimer scrollTimer = new ScrollTimer();
    ArrayList<ActionListener> actionListeners = null;
    int showValueStyle = -1;
    int minThumbSize = 20;
    boolean invertDirection = false;
    protected final Rectangle trackRect = new Rectangle();
    protected int lastState = 0;
    protected int lastThumbState = 0;
    protected int currentHt = this.getHeight();
    protected int currentWd = this.getWidth();
    protected int trackState;
    protected int thumbState = this.trackState = this.getState();

    public static ValueRenderer getDefaultValueRenderer() {
        return defaultValueRenderer != null ? defaultValueRenderer : RenderedProgressBarUI.getDefaultValueRenderer();
    }

    public static Renderer getDefaultTrackRenderer() {
        return defaultTrackRenderer != null ? defaultTrackRenderer : RenderedScrollBarUI.getDefaultTrackRenderer();
    }

    public static Renderer getDefaultThumbRenderer() {
        return defaultThumbRenderer != null ? defaultThumbRenderer : RenderedScrollBarUI.getDefaultThumbRenderer();
    }

    public static void setDefaultTrackRenderer(Renderer renderer) {
        defaultTrackRenderer = renderer;
    }

    public static void setDefaultValueRenderer(ValueRenderer renderer) {
        defaultValueRenderer = renderer;
    }

    public static void setDefaultThumbRenderer(Renderer renderer) {
        defaultThumbRenderer = renderer;
    }

    public ValueRenderer getActiveValueRenderer() {
        return this.valueRenderer != null ? this.valueRenderer : JMScrollBar.getDefaultValueRenderer();
    }

    public Renderer getActiveThumbRenderer() {
        return this.thumbRenderer != null ? this.thumbRenderer : JMScrollBar.getDefaultThumbRenderer();
    }

    public Renderer getActiveTrackRenderer() {
        return this.renderer != null ? this.renderer : JMScrollBar.getDefaultTrackRenderer();
    }

    public boolean isRollover() {
        return this.mouseOver;
    }

    public boolean isThumbPressed() {
        return this.thumbPressed;
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public JMScrollBar() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                JMScrollBar.this.trackRect.width = JMScrollBar.this.getWidth();
                JMScrollBar.this.trackRect.height = JMScrollBar.this.getHeight();
                JMScrollBar.this.resetTrackBuffer();
                JMScrollBar.this.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.init();
    }

    public void init() {
        this.setOpaque(true);
        this.setThumb(new Thumb());
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (JMScrollBar.this.showFocus) {
                    JMScrollBar.this.resetTrackBuffer();
                    JMScrollBar.this.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (JMScrollBar.this.showFocus) {
                    JMScrollBar.this.resetTrackBuffer();
                    JMScrollBar.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!JMScrollBar.this.isEnabled()) {
                    return;
                }
                JMScrollBar.this.mousePressed = true;
                JMScrollBar.this.requestFocus();
                int x = e.getX();
                int y = e.getY();
                if (JMScrollBar.this.thumb != null && JMScrollBar.this.thumb.thumbRect.contains(x, y)) {
                    JMScrollBar.this.thumbPressed = true;
                    JMScrollBar.this.repaint();
                } else if (JMScrollBar.this.orientation == 0) {
                    JMScrollBar.this.scrollTimer.start(JMScrollBar.this.value, JMScrollBar.this.getValueFromX(x));
                } else {
                    JMScrollBar.this.scrollTimer.start(JMScrollBar.this.value, JMScrollBar.this.getValueFromY(y));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!JMScrollBar.this.isEnabled()) {
                    return;
                }
                JMScrollBar.this.mousePressed = false;
                JMScrollBar.this.thumbPressed = false;
                JMScrollBar.this.scrollTimer.stop();
                JMScrollBar.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!JMScrollBar.this.isEnabled()) {
                    return;
                }
                JMScrollBar.this.mouseOver = true;
                JMScrollBar.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!JMScrollBar.this.isEnabled()) {
                    return;
                }
                JMScrollBar.this.mouseOver = false;
                JMScrollBar.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!JMScrollBar.this.isEnabled()) {
                    return;
                }
                if (JMScrollBar.this.orientation == 0) {
                    if (JMScrollBar.this.thumbPressed) {
                        JMScrollBar.this.setValue(JMScrollBar.this.getValueFromX(e.getX()));
                    } else {
                        JMScrollBar.this.scrollTimer.start(JMScrollBar.this.value, JMScrollBar.this.getValueFromX(e.getX()));
                    }
                } else if (JMScrollBar.this.thumbPressed) {
                    JMScrollBar.this.setValue(JMScrollBar.this.getValueFromY(e.getY()));
                } else {
                    JMScrollBar.this.scrollTimer.start(JMScrollBar.this.value, JMScrollBar.this.getValueFromY(e.getY()));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!JMScrollBar.this.isEnabled()) {
                    return;
                }
                if (JMScrollBar.this.orientation == 0) {
                    if (e.getWheelRotation() < 0) {
                        JMScrollBar.this.setValue(JMScrollBar.this.value + (long)(!JMScrollBar.this.invertDirection ? -JMScrollBar.this.smallChange : JMScrollBar.this.smallChange));
                    } else {
                        JMScrollBar.this.setValue(JMScrollBar.this.value + (long)(!JMScrollBar.this.invertDirection ? JMScrollBar.this.smallChange : -JMScrollBar.this.smallChange));
                    }
                } else if (e.getWheelRotation() < 0) {
                    JMScrollBar.this.setValue(JMScrollBar.this.value + (long)(!JMScrollBar.this.invertDirection ? JMScrollBar.this.smallChange : -JMScrollBar.this.smallChange));
                } else {
                    JMScrollBar.this.setValue(JMScrollBar.this.value + (long)(!JMScrollBar.this.invertDirection ? -JMScrollBar.this.smallChange : JMScrollBar.this.smallChange));
                }
            }
        });
        this.updateTrack();
        this.updateThumb();
    }

    void resetTrackBuffer() {
        if (this.trackGraphics != null) {
            this.trackGraphics.dispose();
        }
        this.trackBuffer = null;
        this.trackGraphics = null;
    }

    void resetThumbBuffer() {
        if (this.thumbGraphics != null) {
            this.thumbGraphics.dispose();
        }
        this.thumbBuffer = null;
        this.thumbGraphics = null;
    }

    void resetBuffers() {
        this.resetTrackBuffer();
        this.resetThumbBuffer();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled && this.scrollTimer.isRunning()) {
            this.scrollTimer.stop();
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList();
        }
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(listener);
            if (this.actionListeners.isEmpty()) {
                this.actionListeners = null;
            }
        }
    }

    public void setBlockIncrement(int val) {
        this.bigChange = val;
    }

    public int getBlockIncrement() {
        return this.bigChange;
    }

    public void setUnitIncrement(int val) {
        this.smallChange = val;
    }

    public int getUnitIncrement() {
        return this.smallChange;
    }

    public void setBlockIncrements(int val) {
        this.bigChange = val;
        this.smallChange = val;
    }

    @BeanProperty(hidden=true)
    public void setThumb(Thumb thumb) {
        if (thumb != null) {
            if (this.thumb != null) {
                this.thumb.parent = null;
            }
            if (thumb.parent != null) {
                thumb.parent.thumb = null;
            }
            thumb.parent = this;
            this.thumb = thumb;
            this.repaint();
        }
    }

    private void updateThumb() {
        if (this.thumbRenderer != null) {
            this.thumbRenderer.getColors().setColor(1, 0, this.thumbColorNormal);
            this.thumbRenderer.getColors().setColor(1, 5, this.thumbColorOver);
            this.thumbRenderer.getColors().setColor(1, 1, this.thumbColorPressed);
            this.thumbRenderer.getColors().setColors(2, this.thumbColorBorder);
            this.thumbRenderer.setPaintBorder(this.showThumbBorder);
            this.thumbRenderer.setRounded(this.rounded);
            this.thumbRenderer.setShowFocus(false);
            this.resetBuffers();
            this.repaint();
        }
    }

    private void updateTrack() {
        if (this.renderer != null) {
            super.updateRenderer();
            this.resetBuffers();
            this.repaint();
        }
    }

    public void setThumbRenderer(Renderer renderer) {
        this.thumbRenderer = renderer;
        this.updateThumb();
    }

    public Renderer getThumbRenderer() {
        return this.thumbRenderer;
    }

    @BeanProperty(hidden=true)
    public void setValueRenderer(ValueRenderer valueRenderer) {
        this.valueRenderer = valueRenderer;
        this.repaint();
    }

    public ValueRenderer getValueRenderer() {
        return this.valueRenderer;
    }

    @BeanProperty(hidden=true, description="Sets the scrollbar track and border renderer.")
    public void setTrackRenderer(Renderer renderer) {
        super.setRenderer(renderer);
    }

    public Renderer getTrackRenderer() {
        return super.getRenderer();
    }

    @BeanProperty(hidden=true, description="Sets the color of the scrollbar track in all states.")
    public void setTrackColors(Color color) {
        super.setColors(color);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setColorSelected(Color color) {
        super.setColorSelected(color);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setColorNormal(Color color) {
        super.setColorNormal(color);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setColorPressed(Color color) {
        super.setColorPressed(color);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setColorRollover(Color color) {
        super.setColorRollover(color);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setStyle(Constants.DEFAULTRENDERERS style) {
        super.setStyle(style);
    }

    @Override
    @BeanProperty(hidden=true)
    public Constants.DEFAULTRENDERERS getStyle() {
        return super.getStyle();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar track when the mouse is not over.")
    public void setTrackColor(Color color) {
        super.setBackground(color);
    }

    public Color getTrackColor() {
        return super.getBackground();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar track when the mouse is not over.")
    public void setTrackColorRollOver(Color color) {
        super.setColorRollover(color);
    }

    public Color getTrackColorRollOver() {
        return super.getColorRollover();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar track when the mouse is not over.")
    public void setTrackColorPressed(Color color) {
        super.setColorPressed(color);
    }

    public Color getTrackColorPressed() {
        return super.getColorPressed();
    }

    public boolean isShowThumbBorder() {
        return this.showBorder;
    }

    @BeanProperty(preferred=true, description="Toggle the border of the scrollbar's thumb.")
    public void setShowThumbBorder(boolean show) {
        this.showThumbBorder = show;
        this.updateThumb();
    }

    public void setThumbColors(Color color) {
        this.thumbColorOver = color;
        this.thumbColorPressed = color;
        this.thumbColorNormal = color;
        this.updateThumb();
    }

    public Color getThumbColorOver() {
        return this.thumbColorOver;
    }

    @BeanProperty(preferred=true, description="Sets the color of the thumb/slider when mouse is over the scrollbar.")
    public void setThumbColorOver(Color color) {
        this.thumbColorOver = color;
        this.updateThumb();
    }

    public Color getThumbBorderColor() {
        return this.thumbColorBorder;
    }

    @BeanProperty(preferred=true, description="Sets the color of the thumb/slider when mouse is over the scrollbar.")
    public void setThumbBorderColor(Color color) {
        this.thumbColorBorder = color;
        this.updateThumb();
    }

    public Color getThumbColorPressed() {
        return this.thumbColorPressed;
    }

    @BeanProperty(preferred=true, description="Sets the color of the thumb/slider when mouse pressed over the thumb.")
    public void setThumbColorPressed(Color color) {
        this.thumbColorPressed = color;
        this.updateThumb();
    }

    public Color getThumbColor() {
        return this.thumbColorNormal;
    }

    @BeanProperty(preferred=true, description="Sets the color of the thumb/slider when mouse not over the control.")
    public void setThumbColor(Color color) {
        this.thumbColorNormal = color;
        this.updateThumb();
    }

    public Thumb getThumb() {
        return this.thumb;
    }

    @BeanProperty(preferred=true, description="Sets the maximum value of the scrollbar.")
    public void setMaximum(long newMax) {
        this.setMaximum(newMax, true);
    }

    @BeanProperty(preferred=true, description="Sets the minimum value of the scrollbar.")
    public void setMinimum(long newMin) {
        this.setMinimum(newMin, true);
    }

    @BeanProperty(preferred=true, description="Sets the value of the scrollbar.")
    public void setValue(long newValue) {
        this.setValue(newValue, true);
    }

    public void setValue(int newValue) {
        this.setValue(newValue, true);
    }

    public void setValues(int value, int extent, int min, int max) {
        this.setValues(value, extent, min, max, true);
    }

    public void setValues(int value, int extent, int min, int max, boolean update) {
        this.min = JMScrollBar.constrain(min, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.max = JMScrollBar.constrain(max, min, Integer.MAX_VALUE);
        this.bigChange = extent;
        this.setValue(value, update);
    }

    public long getMaximum() {
        return this.max;
    }

    public long getMinimum() {
        return this.min;
    }

    public long getValue() {
        return this.value;
    }

    @BeanProperty(hidden=true)
    public void setMaximum(long newMax, boolean update) {
        this.max = JMScrollBar.constrain(newMax, Long.MIN_VALUE, Long.MAX_VALUE);
        if (this.min > this.max) {
            this.min = this.max;
        }
        this.setValue(this.value, update);
    }

    @BeanProperty(hidden=true)
    public void setMinimum(long newMin, boolean update) {
        this.min = JMScrollBar.constrain(newMin, Long.MIN_VALUE, Long.MAX_VALUE);
        if (this.max < this.min) {
            this.max = this.min;
        }
        this.setValue(this.value, update);
    }

    @BeanProperty(hidden=true)
    public void setValue(long newValue, boolean update) {
        this.value = JMScrollBar.constrain(newValue, this.min, this.max);
        if (update && this.isVisible()) {
            if (this.min < this.max) {
                this.valueChanged(this.value);
                if (this.actionListeners != null) {
                    ActionEvent e = new ActionEvent(this, 0, "valuechange");
                    for (ActionListener listener : this.actionListeners) {
                        listener.actionPerformed(e);
                    }
                }
            }
            this.repaint();
        }
    }

    @BeanProperty(preferred=true, description="Sets the orientation of the scrollbar.", enumerationValues={"HORIZONTAL", "VERTICAL"})
    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.resetBuffers();
        this.repaint();
    }

    public int getOrientation() {
        return this.orientation;
    }

    @BeanProperty(preferred=true, description="Sets the style of the track.")
    public void setTrackStyle(Constants.DEFAULTRENDERERS style) {
        super.setStyle(style);
        this.resetBuffers();
        this.repaint();
    }

    public Constants.DEFAULTRENDERERS getTrackStyle() {
        return super.getStyle();
    }

    public int getState() {
        if (!this.isEnabled()) {
            return 2;
        }
        if (this.mousePressed) {
            return 1;
        }
        if (this.mouseOver) {
            return 5;
        }
        return 0;
    }

    public int getShowValueStyle() {
        return this.showValueStyle;
    }

    @BeanProperty(preferred=true, description="Sets the default style of rendering the scrollbar's value.", enumerationValues={"NONE", "PERCENT", "RAW"})
    public void setShowValueStyle(int style) {
        switch (style) {
            case -1: {
                this.setValueRenderer(null);
                this.showValueStyle = style;
                break;
            }
            case 0: {
                this.setValueRenderer(new PercentValueRenderer());
                this.showValueStyle = style;
                break;
            }
            case 2: {
                this.setValueRenderer(new RawValueRenderer());
                this.showValueStyle = style;
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets the style of the thumb.")
    public void setThumbStyle(Constants.DEFAULTRENDERERS style) {
        this.setThumbRenderer(this.getRendererStyle(style));
        this.thumbStyle = style;
        this.resetBuffers();
        this.repaint();
    }

    public Constants.DEFAULTRENDERERS getThumbStyle() {
        return this.thumbStyle;
    }

    @BeanProperty(preferred=true, description="Sets the shape of the thumb.", enumerationValues={"RECTANGLE", "ROUNDED", "CIRCLE", "TRIANGLE"})
    public void setThumbShape(int shape) {
        this.thumbShape = shape;
        this.resetBuffers();
        this.repaint();
    }

    public int getThumbShape() {
        return this.thumbShape;
    }

    @BeanProperty(preferred=true, description="Sets whether the thumb shape is inverted.  This applies only to certain shapes such as the triangle.")
    public void setInvertThumb(boolean inverted) {
        this.invertThumb = inverted;
        this.resetBuffers();
        this.repaint();
    }

    public boolean isInvertThumb() {
        return this.invertThumb;
    }

    public void valueChanged(long value) {
    }

    @BeanProperty(preferred=true, description="Sets whether the direction of thumb progression is inverted.  If true, the top and right will represent the minimum values for vertical and horizontal scrollbars/sliders respectively.")
    public void setInvertDirection(boolean invert) {
        this.invertDirection = invert;
        this.resetBuffers();
        this.repaint();
    }

    public boolean isInvertDirection() {
        return this.invertDirection;
    }

    protected boolean calculateThumb() {
        int y;
        int x;
        int wd;
        int ht;
        if (this.orientation == 0) {
            ht = this.trackRect.height;
            wd = (int)(this.min == this.max ? (long)this.trackRect.width : Math.max((long)this.minThumbSize, (long)this.trackRect.width / (this.max - this.min)));
            x = (int)JMScrollBar.scale(this.value, this.min, this.max, (float)this.trackRect.x, (float)(this.trackRect.width - this.thumb.getWidth()));
            y = (this.trackRect.height - this.thumb.getHeight() - 1) / 2;
            if (this.invertDirection) {
                x = this.trackRect.width - x;
            }
        } else {
            wd = this.trackRect.width;
            ht = (int)(this.min == this.max ? (long)this.trackRect.height : Math.max((long)this.minThumbSize, (long)this.trackRect.height / (this.max - this.min)));
            x = (this.trackRect.width - this.thumb.getWidth() - 1) / 2;
            y = (int)JMScrollBar.scale(this.value, this.min, this.max, 0.0f, (float)(this.trackRect.height - this.thumb.getHeight()));
            if (!this.invertDirection) {
                y = this.trackRect.height - y - this.thumb.getHeight();
            }
        }
        if (this.thumb.thumbRect.width != wd || this.thumb.thumbRect.height != ht || this.thumbRenderer == null) {
            this.resetThumbBuffer();
            this.thumb.thumbRect.width = wd;
            this.thumb.thumbRect.height = ht;
            this.thumb.thumbRect.x = x;
            this.thumb.thumbRect.y = y;
            return true;
        }
        this.thumb.thumbRect.x = x;
        this.thumb.thumbRect.y = y;
        return false;
    }

    protected int getValueFromX(int pos) {
        if (this.invertDirection) {
            pos = this.trackRect.width - pos;
        }
        if (this.thumb != null) {
            return (int)JMScrollBar.scale((float)(pos - this.thumb.getWidth() / 2), 0.0f, (float)(this.trackRect.width - this.thumb.getWidth()), this.min, this.max);
        }
        return (int)JMScrollBar.scale((float)pos, 0.0f, (float)this.trackRect.width, this.min, this.max);
    }

    protected int getValueFromY(int pos) {
        if (!this.invertDirection) {
            pos = this.trackRect.height - pos;
        }
        if (this.thumb != null) {
            return (int)JMScrollBar.scale((float)(pos - this.thumb.getHeight() / 2), 0.0f, (float)(this.trackRect.height - this.thumb.getHeight()), this.min, this.max);
        }
        return (int)JMScrollBar.scale((float)pos, 0.0f, (float)this.trackRect.height, this.min, this.max);
    }

    @Override
    public void paint(Graphics g) {
        this.currentHt = this.getHeight();
        this.currentWd = this.getWidth();
        this.trackState = this.getState();
        switch (this.trackState) {
            case 1: {
                this.thumbState = this.thumbPressed ? 1 : 5;
                this.trackState = 5;
                break;
            }
            default: {
                this.thumbState = this.trackState;
            }
        }
        this.paintTrack(g);
        this.paintBorder(g);
        this.paintThumb(g);
        if (this.showValueStyle != -1) {
            this.paintValue(g);
        }
    }

    public void paintValue(Graphics g) {
        this.getActiveValueRenderer().paint((Graphics2D)g, this, this.trackRect, this.trackState);
    }

    public void paintTrack(Graphics g) {
        Renderer rendererTrack = this.getActiveTrackRenderer();
        if (this.currentHt > this.trackRect.height || this.currentWd > this.trackRect.width || this.trackBuffer == null || this.trackGraphics == null || this.lastState != this.trackState || this.renderer == null) {
            this.lastState = this.trackState;
            this.regenBuffer();
            rendererTrack.setOrientation(this.orientation);
            rendererTrack.paintBackground(this.trackGraphics, this, this.trackRect, this.trackState);
        }
        g.drawImage(this.trackBuffer, this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height, this);
    }

    public void paintThumb(Graphics g) {
        if (this.thumb != null && this.min < this.max) {
            this.calculateThumb();
            if (this.thumb.thumbRect.width > 0 && this.thumb.thumbRect.height > 0) {
                if (this.thumbRenderer == null || this.thumbGraphics == null || this.thumbBuffer == null || this.lastThumbState != this.thumbState) {
                    this.lastThumbState = this.thumbState;
                    this.regenThumbBuffer();
                    Renderer rendererThumb = this.getActiveThumbRenderer();
                    rendererThumb.setOrientation(this.orientation);
                    rendererThumb.paint(this.thumbGraphics, this, new Rectangle(0, 0, this.thumb.thumbRect.width, this.thumb.thumbRect.height), this.thumbState);
                }
                g.drawImage(this.thumbBuffer, this.thumb.thumbRect.x, this.thumb.thumbRect.y, this);
            }
        }
    }

    @Override
    public void paintBorder(Graphics g) {
        Renderer rendererTrack = this.getActiveTrackRenderer();
        if (rendererTrack.isPaintBorder()) {
            rendererTrack.paintBorder((Graphics2D)g, this, this.trackRect);
        }
    }

    void regenBuffer() {
        if (this.trackGraphics != null) {
            this.trackGraphics.dispose();
        }
        this.trackRect.height = Math.max(1, this.getHeight());
        this.trackRect.width = Math.max(1, this.getWidth());
        this.trackBuffer = new BufferedImage(this.trackRect.width, this.trackRect.height, 2);
        this.trackGraphics = (Graphics2D)this.trackBuffer.getGraphics();
        this.trackGraphics.setFont(this.getFont());
        ((Graphics2D)this.trackGraphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)this.trackGraphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    void regenThumbBuffer() {
        if (this.thumbGraphics != null) {
            this.thumbGraphics.dispose();
        }
        this.thumbBuffer = new BufferedImage(this.thumb.thumbRect.width, this.thumb.thumbRect.height, 2);
        this.thumbGraphics = (Graphics2D)this.thumbBuffer.getGraphics();
        ((Graphics2D)this.thumbGraphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)this.thumbGraphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    static float scale(float value, float inputMin, float inputMax, float outputMin, float outputMax) {
        value = JMScrollBar.constrain(value, inputMin, inputMax);
        return (value - inputMin) / (inputMax - inputMin) * (outputMax - outputMin) + outputMin;
    }

    static float scale(int value, int inputMin, int inputMax, int outputMin, int outputMax) {
        value = JMScrollBar.constrain(value, inputMin, inputMax);
        return (float)(value - inputMin) / (float)(inputMax - inputMin) * (float)(outputMax - outputMin) + (float)outputMin;
    }

    static int constrain(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    static long constrain(long value, long min, long max) {
        return Math.min(Math.max(value, min), max);
    }

    static double constrain(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    static float constrain(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    class ScrollTimer
    extends Timer {
        long currentValue;
        long valueLimit;
        int step;
        private ActionListener scrollActionListener;

        public ScrollTimer() {
            this(250);
        }

        public ScrollTimer(int delay) {
            super(delay, e -> {});
            this.currentValue = 0L;
            this.valueLimit = 0L;
            this.step = 0;
            this.scrollActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScrollTimer.this.currentValue = ScrollTimer.this.step > 0 ? Math.min(ScrollTimer.this.currentValue + (long)ScrollTimer.this.step, ScrollTimer.this.valueLimit) : Math.max(ScrollTimer.this.currentValue + (long)ScrollTimer.this.step, ScrollTimer.this.valueLimit);
                    JMScrollBar.this.setValue(ScrollTimer.this.currentValue);
                }
            };
            this.addActionListener(this.scrollActionListener);
        }

        public void setValueLimit(int valueLimit) {
            this.setLimits(this.currentValue, valueLimit);
        }

        public void setStartValue(int startValue) {
            this.setLimits(startValue, this.valueLimit);
        }

        public void setLimits(long startValue, long valueLimit) {
            this.currentValue = startValue;
            this.valueLimit = valueLimit;
            this.step = this.currentValue > valueLimit ? -JMScrollBar.this.bigChange : JMScrollBar.this.bigChange;
        }

        public void start(long currentValue, long valueLimit) {
            this.setLimits(currentValue, valueLimit);
            if (!this.isRunning()) {
                this.scrollActionListener.actionPerformed(null);
            }
            super.start();
        }
    }
}

