/*
 * Decompiled with CFR 0.152.
 */
package JMScrollBars;

import JMScrollBars.JMScrollBar;
import JMScrollBars.SliderThumb;
import Renderers.Renderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

public class JMSlider
extends JMScrollBar {
    @Override
    public void init() {
        super.init();
        this.setOpaque(false);
        this.setThumb(new SliderThumb());
    }

    @Override
    public void paintValue(Graphics g) {
        this.getActiveValueRenderer().paint((Graphics2D)g, this, this.trackRect, this.trackState);
    }

    @Override
    public void paintTrack(Graphics g) {
        Renderer renderer = this.getActiveTrackRenderer();
        Shape trackShape = this.getTrackShape();
        if (this.currentHt > this.trackRect.height || this.currentWd > this.trackRect.width || this.trackBuffer == null || this.trackGraphics == null || this.lastState != this.trackState || this.renderer == null) {
            this.lastState = this.trackState;
            this.regenBuffer();
            renderer.setOrientation(this.orientation);
            renderer.paintBackground(this.trackGraphics, this, trackShape, this.trackState);
        }
        g.drawImage(this.trackBuffer, this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height, this);
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.thumb != null && this.min < this.max) {
            this.calculateThumb();
            if (this.thumb.thumbRect.width > 0 && this.thumb.thumbRect.height > 0) {
                if (this.thumbRenderer == null || this.thumbGraphics == null || this.thumbBuffer == null || this.lastThumbState != this.thumbState) {
                    this.lastThumbState = this.thumbState;
                    this.regenThumbBuffer();
                    Renderer rendererThumb = this.getActiveThumbRenderer();
                    rendererThumb.setOrientation(this.orientation);
                    Graphics2D tG = (Graphics2D)this.thumbGraphics;
                    Shape oldClip = tG.getClip();
                    tG.clip(this.thumb.getShape());
                    rendererThumb.paintBackground(this.thumbGraphics, this, new Rectangle(0, 0, this.thumb.thumbRect.width, this.thumb.thumbRect.height), this.thumbState);
                    if (rendererThumb.getBorderColor() != null && rendererThumb.isPaintBorder()) {
                        tG.setColor(rendererThumb.getBorderColor());
                        tG.draw(this.thumb.getShape());
                    }
                    this.thumbGraphics.setClip(oldClip);
                }
                g.drawImage(this.thumbBuffer, this.thumb.thumbRect.x, this.thumb.thumbRect.y, this);
            }
        }
    }

    @Override
    public void paintBorder(Graphics g) {
    }

    Shape getTrackShape() {
        int left;
        int wd;
        int ht;
        int top;
        if (this.orientation == 0) {
            int half = (this.trackRect.height - 1) / 2;
            int thumbWd = this.thumb != null ? this.thumb.getWidth() : 0;
            top = half - 2;
            ht = 4;
            wd = this.trackRect.width - thumbWd;
            left = thumbWd / 2;
        } else {
            int half = (this.trackRect.width - 1) / 2;
            int thumbHt = this.thumb != null ? this.thumb.getHeight() : 0;
            left = half - 2;
            wd = 4;
            top = thumbHt / 2;
            ht = this.trackRect.height - thumbHt;
        }
        if (this.rounded) {
            return new RoundRectangle2D.Double(left, top, wd, ht, 10.0, 10.0);
        }
        return new Rectangle(left, top, wd, ht);
    }
}

